"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.openSaveModal = openSaveModal;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/saved-objects-plugin/public");
var _save_modal = require("../components/save_modal");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/graph/public/services/save_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function openSaveModal({
  savePolicy,
  hasData,
  workspace,
  saveWorkspace,
  services
}) {
  const currentTitle = workspace.title;
  const currentDescription = workspace.description;
  const onSave = async ({
    newTitle,
    newDescription,
    newCopyOnSave,
    isTitleDuplicateConfirmed,
    onTitleDuplicate,
    dataConsent
  }) => {
    workspace.title = newTitle;
    workspace.description = newDescription;
    workspace.copyOnSave = newCopyOnSave;
    const saveOptions = {
      confirmOverwrite: false,
      isTitleDuplicateConfirmed,
      onTitleDuplicate
    };
    return saveWorkspace(saveOptions, dataConsent, services).then(response => {
      // If the save wasn't successful, put the original values back.
      if (!('id' in response) || !Boolean(response.id)) {
        workspace.title = currentTitle;
        workspace.description = currentDescription;
      }
      return response;
    });
  };
  (0, _public.showSaveModal)(/*#__PURE__*/_react.default.createElement(_save_modal.SaveModal, {
    savePolicy: savePolicy,
    hasData: hasData,
    onSave: onSave,
    onClose: () => {},
    title: workspace.title,
    description: workspace.description,
    showCopyOnSave: Boolean(workspace.id),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 5
    }
  }));
}