"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.confirmModalPromise = confirmModalPromise;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/graph/public/helpers/saved_objects_utils/confirm_modal_promise.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function confirmModalPromise(message = '', title = '', confirmBtnText = '', startServices) {
  return new Promise((resolve, reject) => {
    const cancelButtonText = _i18n.i18n.translate('xpack.graph.confirmModal.cancelButtonLabel', {
      defaultMessage: 'Cancel'
    });
    const confirmModalTitleId = (0, _eui.htmlIdGenerator)()('confirmModalTitleId');
    const modal = startServices.overlays.openModal((0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
      "aria-labelledby": confirmModalTitleId,
      titleProps: {
        id: confirmModalTitleId
      },
      onCancel: () => {
        modal.close();
        reject();
      },
      onConfirm: () => {
        modal.close();
        resolve(true);
      },
      confirmButtonText: confirmBtnText,
      cancelButtonText: cancelButtonText,
      title: title,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 29,
        columnNumber: 9
      }
    }, message), startServices));
  });
}