"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePackageIconType = void 0;
var _react = require("react");
var _eui = require("@elastic/eui");
var _use_links = require("../applications/integrations/hooks/use_links");
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// TODO: Determine whether this can be relocated
// Import the specific hook to avoid a circular dependency in Babel

const CACHED_ICONS = new Map();
const usePackageIconType = ({
  packageName,
  integrationName,
  version,
  icons: paramIcons,
  tryApi = false
}) => {
  var _CACHED_ICONS$get;
  const {
    toPackageImage
  } = (0, _use_links.useLinks)();
  const [iconList, setIconList] = (0, _react.useState)();
  const [iconType, setIconType] = (0, _react.useState)(''); // FIXME: use `empty` icon during initialization - see: https://github.com/elastic/kibana/issues/60622
  const cacheKey = `${packageName}-${version}${integrationName ? `-${integrationName}` : ''}`;

  // Generates an icon path or Eui Icon name based on an icon list from the package
  // or by using the package name against logo icons from Eui
  (0, _react.useEffect)(() => {
    var _ref;
    if (CACHED_ICONS.has(cacheKey)) {
      setIconType(CACHED_ICONS.get(cacheKey) || '');
      return;
    }
    const svgIcons = (_ref = paramIcons && paramIcons.length ? paramIcons : iconList) === null || _ref === void 0 ? void 0 : _ref.filter(iconDef => iconDef.type === 'image/svg+xml');
    const localIconSrc = Array.isArray(svgIcons) && toPackageImage(svgIcons[0], packageName, version);
    if (localIconSrc) {
      CACHED_ICONS.set(cacheKey, localIconSrc);
      setIconType(CACHED_ICONS.get(cacheKey) || '');
      return;
    }
    const euiLogoIcon = _eui.ICON_TYPES.find(key => key.toLowerCase() === `logo${packageName}`);
    if (euiLogoIcon) {
      CACHED_ICONS.set(cacheKey, euiLogoIcon);
      setIconType(euiLogoIcon);
      return;
    }
    if (tryApi && !paramIcons && !iconList) {
      (0, _.sendGetPackageInfoByKeyForRq)(packageName, version).catch(error => undefined) // Ignore API errors
      .then(res => {
        var _res$item, _res$item2;
        CACHED_ICONS.delete(cacheKey);
        setIconList(res === null || res === void 0 ? void 0 : (_res$item = res.item) === null || _res$item === void 0 ? void 0 : _res$item.icons);

        // fallback to default package icon if no icons found from API
        if (!(res !== null && res !== void 0 && (_res$item2 = res.item) !== null && _res$item2 !== void 0 && _res$item2.icons)) {
          CACHED_ICONS.set(cacheKey, 'package');
          setIconType('package');
        }
      });
    }
  }, [paramIcons, cacheKey, toPackageImage, iconList, packageName, iconType, tryApi, version]);
  if (iconType !== '') {
    return iconType;
  }

  // Avoid blinking
  return (_CACHED_ICONS$get = CACHED_ICONS.get(cacheKey)) !== null && _CACHED_ICONS$get !== void 0 ? _CACHED_ICONS$get : iconType;
};
exports.usePackageIconType = usePackageIconType;