"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteAgentlessPolicyResponseSchema = exports.DeleteAgentlessPolicyRequestSchema = exports.CreateAgentlessPolicyResponseSchema = exports.CreateAgentlessPolicyRequestSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _package_policy_schema = require("../models/package_policy_schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CreateAgentlessPolicyRequestSchema = exports.CreateAgentlessPolicyRequestSchema = {
  query: _configSchema.schema.object({
    format: _configSchema.schema.oneOf([_configSchema.schema.literal('legacy'), _configSchema.schema.literal('simplified')], {
      defaultValue: 'simplified',
      meta: {
        description: 'The format of the response package policy.'
      }
    })
  }),
  body: _package_policy_schema.SimplifiedCreatePackagePolicyRequestBodySchema.extends({
    // Remove all properties that are not relevant for agentless policies
    cloud_connector_id: undefined,
    supports_cloud_connector: undefined,
    policy_id: undefined,
    policy_ids: undefined,
    supports_agentless: undefined,
    output_id: undefined
  })
};
const DeleteAgentlessPolicyRequestSchema = exports.DeleteAgentlessPolicyRequestSchema = {
  query: _configSchema.schema.object({
    force: _configSchema.schema.maybe(_configSchema.schema.boolean({
      defaultValue: false,
      meta: {
        description: 'Force delete the policy even if the policy is managed.'
      }
    }))
  }),
  params: _configSchema.schema.object({
    policyId: _configSchema.schema.string({
      meta: {
        description: 'The ID of the policy to delete.'
      }
    })
  })
};
const DeleteAgentlessPolicyResponseSchema = exports.DeleteAgentlessPolicyResponseSchema = _configSchema.schema.object({
  id: _configSchema.schema.string({
    meta: {
      description: 'The ID of the deleted agentless package policy.'
    }
  })
}, {
  meta: {
    description: 'Response for deleting an agentless package policy.'
  }
});
const CreateAgentlessPolicyResponseSchema = exports.CreateAgentlessPolicyResponseSchema = _configSchema.schema.object({
  item: _package_policy_schema.PackagePolicyResponseSchema.extends({}, {
    meta: {
      description: 'The created agentless package policy.'
    }
  })
});