"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSplitDimensionAccessor = void 0;
var _chartExpressionsCommon = require("@kbn/chart-expressions-common");
var _formatters = require("./formatters");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getSplitDimensionAccessor = (columns, splitDimension, formatters, defaultFormatFactory) => {
  const splitChartColumn = (0, _chartExpressionsCommon.getColumnByAccessor)(splitDimension, columns);
  const accessor = splitChartColumn.id;
  const formatter = (0, _formatters.getFormatter)(splitChartColumn, formatters, defaultFormatFactory);
  const fn = d => {
    const v = d[accessor];
    if (v === undefined) {
      return;
    }
    const f = formatter.convert(v);
    return f;
  };
  return fn;
};
exports.getSplitDimensionAccessor = getSplitDimensionAccessor;