"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRoutes = void 0;
var _get_inference_endpoints = require("./get_inference_endpoints");
var _get_join_indices = require("./get_join_indices");
var _get_timeseries_indices = require("./get_timeseries_indices");
var _get_esql_extensions_route = require("./get_esql_extensions_route");
var _lookup_index = require("./lookup_index");
var _get_all_sources = require("./get_all_sources");
var _get_timefield = require("./get_timefield");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const registerRoutes = (setup, extensionsRegistry, initContext) => {
  const router = setup.http.createRouter();
  (0, _get_join_indices.registerGetJoinIndicesRoute)(router, initContext);
  (0, _get_timeseries_indices.registerGetTimeseriesIndicesRoute)(router, initContext);
  (0, _get_esql_extensions_route.registerESQLExtensionsRoute)(router, extensionsRegistry, initContext);
  (0, _get_inference_endpoints.registerGetInferenceEndpointsRoute)(router, initContext);
  (0, _lookup_index.registerLookupIndexRoutes)(router, initContext);
  (0, _get_all_sources.registerGetSourcesRoute)(router, initContext);
  (0, _get_timefield.registerGetTimeFieldRoute)(router, initContext);
};
exports.registerRoutes = registerRoutes;