"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getColumnsByTypeRetriever = getColumnsByTypeRetriever;
var _esqlAst = require("@kbn/esql-ast");
var _utils = require("@kbn/esql-ast/src/definitions/utils");
var _resources_helpers = require("./resources_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getColumnsByTypeRetriever(query, queryText, resourceRetriever) {
  var _resourceRetriever$ca, _resourceRetriever$ca2;
  const helpers = new _resources_helpers.QueryColumns(query, queryText, resourceRetriever);
  const getVariables = resourceRetriever === null || resourceRetriever === void 0 ? void 0 : resourceRetriever.getVariables;
  const canSuggestVariables = (_resourceRetriever$ca = resourceRetriever === null || resourceRetriever === void 0 ? void 0 : (_resourceRetriever$ca2 = resourceRetriever.canSuggestVariables) === null || _resourceRetriever$ca2 === void 0 ? void 0 : _resourceRetriever$ca2.call(resourceRetriever)) !== null && _resourceRetriever$ca !== void 0 ? _resourceRetriever$ca : false;
  const queryString = queryText;
  const lastCharacterTyped = queryString[queryString.length - 1];
  const lastCharIsQuestionMark = lastCharacterTyped === _esqlAst.ESQL_VARIABLES_PREFIX;
  return {
    getColumnsByType: async (expectedType = 'any', ignored = [], options) => {
      var _await$resourceRetrie, _resourceRetriever$ge;
      const updatedOptions = {
        ...options,
        supportsControls: canSuggestVariables && !lastCharIsQuestionMark
      };
      const editorExtensions = (_await$resourceRetrie = await (resourceRetriever === null || resourceRetriever === void 0 ? void 0 : (_resourceRetriever$ge = resourceRetriever.getEditorExtensions) === null || _resourceRetriever$ge === void 0 ? void 0 : _resourceRetriever$ge.call(resourceRetriever, queryText))) !== null && _await$resourceRetrie !== void 0 ? _await$resourceRetrie : {
        recommendedQueries: [],
        recommendedFields: []
      };
      const recommendedFieldsFromExtensions = editorExtensions.recommendedFields;
      const columns = await helpers.byType(expectedType, ignored);
      return (0, _utils.buildFieldsDefinitionsWithMetadata)(columns, recommendedFieldsFromExtensions, updatedOptions, await (getVariables === null || getVariables === void 0 ? void 0 : getVariables()));
    },
    getColumnMap: helpers.asMap.bind(helpers)
  };
}