"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createTag = void 0;
var _holes = require("./holes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const createTag = generator => {
  const templateStringTag = opts => {
    return (template, ...holes) => {
      let src = '';
      const length = template.length;
      for (let i = 0; i < length; i++) {
        src += template[i];
        if (i < holes.length) {
          const hole = holes[i];
          const fragment = (0, _holes.holeToFragment)(hole);
          src += fragment;
        }
      }
      return generator(src, opts);
    };
  };
  const method = (...args) => {
    const [first] = args;

    /**
     * Usage as function:
     *
     * ```js
     * expr('42');
     * ```
     */
    if (typeof first === 'string') return generator(first, args[1]);

    /**
     * Usage as tagged template:
     *
     * ```js
     * expr`42`;
     * ```
     */
    if (Array.isArray(first)) {
      return templateStringTag()(first, ...args.slice(1));
    }

    /**
     * Usage as tagged template, with ability to specify parsing options:
     *
     * ```js
     * expr({ withFormatting: false })`42`;
     * ```
     */
    return templateStringTag(args[0]);
  };
  return method;
};
exports.createTag = createTag;