"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setCommand = void 0;
var _i18n = require("@kbn/i18n");
var _autocomplete = require("./autocomplete");
var _validate = require("./validate");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const setCommandMethods = {
  autocomplete: _autocomplete.autocomplete,
  validate: _validate.validate
};
const setCommand = exports.setCommand = {
  name: 'set',
  methods: setCommandMethods,
  metadata: {
    description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.setDoc', {
      defaultMessage: 'Sets a query setting'
    }),
    declaration: `SET <setting> = <value>`,
    examples: ['SET project_routing = "_alias:_origin";', 'SET project_routing = "_alias: *";'],
    hidden: process.env.NODE_ENV === 'test' ? false : true,
    // Temporary until making it GA
    preview: true,
    name: 'set'
  }
};