"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fromCommand = void 0;
var _i18n = require("@kbn/i18n");
var _autocomplete = require("./autocomplete");
var _validate = require("./validate");
var _columns_after = require("./columns_after");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const fromCommandMethods = {
  autocomplete: _autocomplete.autocomplete,
  validate: _validate.validate,
  columnsAfter: _columns_after.columnsAfter
};
const fromCommand = exports.fromCommand = {
  name: 'from',
  methods: fromCommandMethods,
  metadata: {
    description: _i18n.i18n.translate('kbn-esql-ast.esql.definitions.fromDoc', {
      defaultMessage: 'Retrieves data from one or more data streams, indices, or aliases. In a query or subquery, you must use the from command first and it does not need a leading pipe. For example, to retrieve data from an index:'
    }),
    declaration: 'FROM index_pattern [METADATA fields]',
    examples: ['FROM logs', 'FROM logs-*', 'FROM logs_*, events-*']
  }
};