"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validate = void 0;
var _walker = require("../../../walker");
var _validation = require("../../../definitions/utils/validation");
var _ = require("../..");
var _utils = require("../../../definitions/utils");
var _is = require("../../../ast/is");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const MIN_BRANCHES = 2;
const MAX_BRANCHES = 8;
const validate = (command, ast, context, callbacks) => {
  const messages = [];
  if (command.args.length < MIN_BRANCHES) {
    messages.push(_utils.errors.forkTooFewBranches(command));
  }
  if (command.args.length > MAX_BRANCHES) {
    messages.push(_utils.errors.forkTooManyBranches(command));
  }
  messages.push(...(0, _validation.validateCommandArguments)(command, ast, context, callbacks));
  for (const arg of command.args.flat()) {
    if (!Array.isArray(arg) && arg.type === 'query') {
      // all the args should be commands
      arg.commands.forEach(subCommand => {
        var _subCommandMethods$va;
        const subCommandMethods = _.esqlCommandRegistry.getCommandMethods(subCommand.name);
        const validationMessages = subCommandMethods === null || subCommandMethods === void 0 ? void 0 : (_subCommandMethods$va = subCommandMethods.validate) === null || _subCommandMethods$va === void 0 ? void 0 : _subCommandMethods$va.call(subCommandMethods, subCommand, arg.commands, context);
        messages.push(...(validationMessages || []));
      });
    }
  }
  const allCommands = _walker.Walker.commands(ast);
  const forks = allCommands.filter(({
    name
  }) => name === 'fork');
  if (forks.length > 1) {
    messages.push(_utils.errors.tooManyForks(forks[1]));
  }

  // FORK is not allowed when the query contains subqueries
  const fromCommands = allCommands.filter(({
    name
  }) => name.toLowerCase() === 'from');
  const hasSubqueries = fromCommands.some(cmd => cmd.args.some(arg => (0, _is.isSubQuery)(arg)));
  if (hasSubqueries) {
    messages.push(_utils.errors.forkNotAllowedWithSubqueries(command));
  }
  return messages;
};
exports.validate = validate;