"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _antlr = require("antlr4");
var _lexer_config = _interopRequireDefault(require("./lexer_config.js"));
var _esql_lexer; // @ts-nocheck
// Generated from src/antlr/esql_lexer.g4 by ANTLR 4.13.2
// noinspection ES6UnusedImports,JSUnusedGlobalSymbols,JSUnusedLocalSymbols
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class esql_lexer extends _lexer_config.default {
  constructor(input) {
    super(input);
    this._interp = new _antlr.LexerATNSimulator(this, esql_lexer._ATN, esql_lexer.DecisionsToDFA, new _antlr.PredictionContextCache());
  }
  get grammarFileName() {
    return "esql_lexer.g4";
  }
  get literalNames() {
    return esql_lexer.literalNames;
  }
  get symbolicNames() {
    return esql_lexer.symbolicNames;
  }
  get ruleNames() {
    return esql_lexer.ruleNames;
  }
  get serializedATN() {
    return esql_lexer._serializedATN;
  }
  get channelNames() {
    return esql_lexer.channelNames;
  }
  get modeNames() {
    return esql_lexer.modeNames;
  }

  // @Override
  sempred(localctx, ruleIndex, predIndex) {
    switch (ruleIndex) {
      case 5:
        return this.DEV_EXPLAIN_sempred(localctx, predIndex);
      case 24:
        return this.DEV_JOIN_FULL_sempred(localctx, predIndex);
      case 25:
        return this.DEV_JOIN_LEFT_sempred(localctx, predIndex);
      case 26:
        return this.DEV_JOIN_RIGHT_sempred(localctx, predIndex);
      case 27:
        return this.DEV_LOOKUP_sempred(localctx, predIndex);
      case 31:
        return this.DEV_INSIST_sempred(localctx, predIndex);
    }
    return true;
  }
  DEV_EXPLAIN_sempred(localctx, predIndex) {
    switch (predIndex) {
      case 0:
        return this.isDevVersion();
    }
    return true;
  }
  DEV_JOIN_FULL_sempred(localctx, predIndex) {
    switch (predIndex) {
      case 1:
        return this.isDevVersion();
    }
    return true;
  }
  DEV_JOIN_LEFT_sempred(localctx, predIndex) {
    switch (predIndex) {
      case 2:
        return this.isDevVersion();
    }
    return true;
  }
  DEV_JOIN_RIGHT_sempred(localctx, predIndex) {
    switch (predIndex) {
      case 3:
        return this.isDevVersion();
    }
    return true;
  }
  DEV_LOOKUP_sempred(localctx, predIndex) {
    switch (predIndex) {
      case 4:
        return this.isDevVersion();
    }
    return true;
  }
  DEV_INSIST_sempred(localctx, predIndex) {
    switch (predIndex) {
      case 5:
        return this.isDevVersion();
    }
    return true;
  }
  static get _ATN() {
    if (!esql_lexer.__ATN) {
      esql_lexer.__ATN = new _antlr.ATNDeserializer().deserialize(esql_lexer._serializedATN);
    }
    return esql_lexer.__ATN;
  }
}
exports.default = esql_lexer;
_esql_lexer = esql_lexer;
(0, _defineProperty2.default)(esql_lexer, "LINE_COMMENT", 1);
(0, _defineProperty2.default)(esql_lexer, "MULTILINE_COMMENT", 2);
(0, _defineProperty2.default)(esql_lexer, "WS", 3);
(0, _defineProperty2.default)(esql_lexer, "CHANGE_POINT", 4);
(0, _defineProperty2.default)(esql_lexer, "ENRICH", 5);
(0, _defineProperty2.default)(esql_lexer, "DEV_EXPLAIN", 6);
(0, _defineProperty2.default)(esql_lexer, "COMPLETION", 7);
(0, _defineProperty2.default)(esql_lexer, "DISSECT", 8);
(0, _defineProperty2.default)(esql_lexer, "EVAL", 9);
(0, _defineProperty2.default)(esql_lexer, "GROK", 10);
(0, _defineProperty2.default)(esql_lexer, "LIMIT", 11);
(0, _defineProperty2.default)(esql_lexer, "RERANK", 12);
(0, _defineProperty2.default)(esql_lexer, "ROW", 13);
(0, _defineProperty2.default)(esql_lexer, "SAMPLE", 14);
(0, _defineProperty2.default)(esql_lexer, "SORT", 15);
(0, _defineProperty2.default)(esql_lexer, "STATS", 16);
(0, _defineProperty2.default)(esql_lexer, "WHERE", 17);
(0, _defineProperty2.default)(esql_lexer, "FROM", 18);
(0, _defineProperty2.default)(esql_lexer, "TS", 19);
(0, _defineProperty2.default)(esql_lexer, "FORK", 20);
(0, _defineProperty2.default)(esql_lexer, "FUSE", 21);
(0, _defineProperty2.default)(esql_lexer, "INLINE", 22);
(0, _defineProperty2.default)(esql_lexer, "INLINESTATS", 23);
(0, _defineProperty2.default)(esql_lexer, "JOIN_LOOKUP", 24);
(0, _defineProperty2.default)(esql_lexer, "DEV_JOIN_FULL", 25);
(0, _defineProperty2.default)(esql_lexer, "DEV_JOIN_LEFT", 26);
(0, _defineProperty2.default)(esql_lexer, "DEV_JOIN_RIGHT", 27);
(0, _defineProperty2.default)(esql_lexer, "DEV_LOOKUP", 28);
(0, _defineProperty2.default)(esql_lexer, "MV_EXPAND", 29);
(0, _defineProperty2.default)(esql_lexer, "DROP", 30);
(0, _defineProperty2.default)(esql_lexer, "KEEP", 31);
(0, _defineProperty2.default)(esql_lexer, "DEV_INSIST", 32);
(0, _defineProperty2.default)(esql_lexer, "RENAME", 33);
(0, _defineProperty2.default)(esql_lexer, "SET", 34);
(0, _defineProperty2.default)(esql_lexer, "SHOW", 35);
(0, _defineProperty2.default)(esql_lexer, "UNKNOWN_CMD", 36);
(0, _defineProperty2.default)(esql_lexer, "CHANGE_POINT_LINE_COMMENT", 37);
(0, _defineProperty2.default)(esql_lexer, "CHANGE_POINT_MULTILINE_COMMENT", 38);
(0, _defineProperty2.default)(esql_lexer, "CHANGE_POINT_WS", 39);
(0, _defineProperty2.default)(esql_lexer, "ENRICH_POLICY_NAME", 40);
(0, _defineProperty2.default)(esql_lexer, "ENRICH_LINE_COMMENT", 41);
(0, _defineProperty2.default)(esql_lexer, "ENRICH_MULTILINE_COMMENT", 42);
(0, _defineProperty2.default)(esql_lexer, "ENRICH_WS", 43);
(0, _defineProperty2.default)(esql_lexer, "ENRICH_FIELD_LINE_COMMENT", 44);
(0, _defineProperty2.default)(esql_lexer, "ENRICH_FIELD_MULTILINE_COMMENT", 45);
(0, _defineProperty2.default)(esql_lexer, "ENRICH_FIELD_WS", 46);
(0, _defineProperty2.default)(esql_lexer, "EXPLAIN_WS", 47);
(0, _defineProperty2.default)(esql_lexer, "EXPLAIN_LINE_COMMENT", 48);
(0, _defineProperty2.default)(esql_lexer, "EXPLAIN_MULTILINE_COMMENT", 49);
(0, _defineProperty2.default)(esql_lexer, "PIPE", 50);
(0, _defineProperty2.default)(esql_lexer, "QUOTED_STRING", 51);
(0, _defineProperty2.default)(esql_lexer, "INTEGER_LITERAL", 52);
(0, _defineProperty2.default)(esql_lexer, "DECIMAL_LITERAL", 53);
(0, _defineProperty2.default)(esql_lexer, "AND", 54);
(0, _defineProperty2.default)(esql_lexer, "ASC", 55);
(0, _defineProperty2.default)(esql_lexer, "ASSIGN", 56);
(0, _defineProperty2.default)(esql_lexer, "BY", 57);
(0, _defineProperty2.default)(esql_lexer, "CAST_OP", 58);
(0, _defineProperty2.default)(esql_lexer, "COLON", 59);
(0, _defineProperty2.default)(esql_lexer, "SEMICOLON", 60);
(0, _defineProperty2.default)(esql_lexer, "COMMA", 61);
(0, _defineProperty2.default)(esql_lexer, "DESC", 62);
(0, _defineProperty2.default)(esql_lexer, "DOT", 63);
(0, _defineProperty2.default)(esql_lexer, "FALSE", 64);
(0, _defineProperty2.default)(esql_lexer, "FIRST", 65);
(0, _defineProperty2.default)(esql_lexer, "IN", 66);
(0, _defineProperty2.default)(esql_lexer, "IS", 67);
(0, _defineProperty2.default)(esql_lexer, "LAST", 68);
(0, _defineProperty2.default)(esql_lexer, "LIKE", 69);
(0, _defineProperty2.default)(esql_lexer, "NOT", 70);
(0, _defineProperty2.default)(esql_lexer, "NULL", 71);
(0, _defineProperty2.default)(esql_lexer, "NULLS", 72);
(0, _defineProperty2.default)(esql_lexer, "ON", 73);
(0, _defineProperty2.default)(esql_lexer, "OR", 74);
(0, _defineProperty2.default)(esql_lexer, "PARAM", 75);
(0, _defineProperty2.default)(esql_lexer, "RLIKE", 76);
(0, _defineProperty2.default)(esql_lexer, "TRUE", 77);
(0, _defineProperty2.default)(esql_lexer, "WITH", 78);
(0, _defineProperty2.default)(esql_lexer, "EQ", 79);
(0, _defineProperty2.default)(esql_lexer, "CIEQ", 80);
(0, _defineProperty2.default)(esql_lexer, "NEQ", 81);
(0, _defineProperty2.default)(esql_lexer, "LT", 82);
(0, _defineProperty2.default)(esql_lexer, "LTE", 83);
(0, _defineProperty2.default)(esql_lexer, "GT", 84);
(0, _defineProperty2.default)(esql_lexer, "GTE", 85);
(0, _defineProperty2.default)(esql_lexer, "PLUS", 86);
(0, _defineProperty2.default)(esql_lexer, "MINUS", 87);
(0, _defineProperty2.default)(esql_lexer, "ASTERISK", 88);
(0, _defineProperty2.default)(esql_lexer, "SLASH", 89);
(0, _defineProperty2.default)(esql_lexer, "PERCENT", 90);
(0, _defineProperty2.default)(esql_lexer, "LEFT_BRACES", 91);
(0, _defineProperty2.default)(esql_lexer, "RIGHT_BRACES", 92);
(0, _defineProperty2.default)(esql_lexer, "DOUBLE_PARAMS", 93);
(0, _defineProperty2.default)(esql_lexer, "NAMED_OR_POSITIONAL_PARAM", 94);
(0, _defineProperty2.default)(esql_lexer, "NAMED_OR_POSITIONAL_DOUBLE_PARAMS", 95);
(0, _defineProperty2.default)(esql_lexer, "OPENING_BRACKET", 96);
(0, _defineProperty2.default)(esql_lexer, "CLOSING_BRACKET", 97);
(0, _defineProperty2.default)(esql_lexer, "LP", 98);
(0, _defineProperty2.default)(esql_lexer, "RP", 99);
(0, _defineProperty2.default)(esql_lexer, "UNQUOTED_IDENTIFIER", 100);
(0, _defineProperty2.default)(esql_lexer, "QUOTED_IDENTIFIER", 101);
(0, _defineProperty2.default)(esql_lexer, "EXPR_LINE_COMMENT", 102);
(0, _defineProperty2.default)(esql_lexer, "EXPR_MULTILINE_COMMENT", 103);
(0, _defineProperty2.default)(esql_lexer, "EXPR_WS", 104);
(0, _defineProperty2.default)(esql_lexer, "METADATA", 105);
(0, _defineProperty2.default)(esql_lexer, "UNQUOTED_SOURCE", 106);
(0, _defineProperty2.default)(esql_lexer, "FROM_LINE_COMMENT", 107);
(0, _defineProperty2.default)(esql_lexer, "FROM_MULTILINE_COMMENT", 108);
(0, _defineProperty2.default)(esql_lexer, "FROM_WS", 109);
(0, _defineProperty2.default)(esql_lexer, "FORK_WS", 110);
(0, _defineProperty2.default)(esql_lexer, "FORK_LINE_COMMENT", 111);
(0, _defineProperty2.default)(esql_lexer, "FORK_MULTILINE_COMMENT", 112);
(0, _defineProperty2.default)(esql_lexer, "GROUP", 113);
(0, _defineProperty2.default)(esql_lexer, "SCORE", 114);
(0, _defineProperty2.default)(esql_lexer, "KEY", 115);
(0, _defineProperty2.default)(esql_lexer, "FUSE_LINE_COMMENT", 116);
(0, _defineProperty2.default)(esql_lexer, "FUSE_MULTILINE_COMMENT", 117);
(0, _defineProperty2.default)(esql_lexer, "FUSE_WS", 118);
(0, _defineProperty2.default)(esql_lexer, "INLINE_STATS", 119);
(0, _defineProperty2.default)(esql_lexer, "INLINE_LINE_COMMENT", 120);
(0, _defineProperty2.default)(esql_lexer, "INLINE_MULTILINE_COMMENT", 121);
(0, _defineProperty2.default)(esql_lexer, "INLINE_WS", 122);
(0, _defineProperty2.default)(esql_lexer, "JOIN", 123);
(0, _defineProperty2.default)(esql_lexer, "USING", 124);
(0, _defineProperty2.default)(esql_lexer, "JOIN_LINE_COMMENT", 125);
(0, _defineProperty2.default)(esql_lexer, "JOIN_MULTILINE_COMMENT", 126);
(0, _defineProperty2.default)(esql_lexer, "JOIN_WS", 127);
(0, _defineProperty2.default)(esql_lexer, "LOOKUP_LINE_COMMENT", 128);
(0, _defineProperty2.default)(esql_lexer, "LOOKUP_MULTILINE_COMMENT", 129);
(0, _defineProperty2.default)(esql_lexer, "LOOKUP_WS", 130);
(0, _defineProperty2.default)(esql_lexer, "LOOKUP_FIELD_LINE_COMMENT", 131);
(0, _defineProperty2.default)(esql_lexer, "LOOKUP_FIELD_MULTILINE_COMMENT", 132);
(0, _defineProperty2.default)(esql_lexer, "LOOKUP_FIELD_WS", 133);
(0, _defineProperty2.default)(esql_lexer, "MVEXPAND_LINE_COMMENT", 134);
(0, _defineProperty2.default)(esql_lexer, "MVEXPAND_MULTILINE_COMMENT", 135);
(0, _defineProperty2.default)(esql_lexer, "MVEXPAND_WS", 136);
(0, _defineProperty2.default)(esql_lexer, "ID_PATTERN", 137);
(0, _defineProperty2.default)(esql_lexer, "PROJECT_LINE_COMMENT", 138);
(0, _defineProperty2.default)(esql_lexer, "PROJECT_MULTILINE_COMMENT", 139);
(0, _defineProperty2.default)(esql_lexer, "PROJECT_WS", 140);
(0, _defineProperty2.default)(esql_lexer, "AS", 141);
(0, _defineProperty2.default)(esql_lexer, "RENAME_LINE_COMMENT", 142);
(0, _defineProperty2.default)(esql_lexer, "RENAME_MULTILINE_COMMENT", 143);
(0, _defineProperty2.default)(esql_lexer, "RENAME_WS", 144);
(0, _defineProperty2.default)(esql_lexer, "SET_LINE_COMMENT", 145);
(0, _defineProperty2.default)(esql_lexer, "SET_MULTILINE_COMMENT", 146);
(0, _defineProperty2.default)(esql_lexer, "SET_WS", 147);
(0, _defineProperty2.default)(esql_lexer, "INFO", 148);
(0, _defineProperty2.default)(esql_lexer, "SHOW_LINE_COMMENT", 149);
(0, _defineProperty2.default)(esql_lexer, "SHOW_MULTILINE_COMMENT", 150);
(0, _defineProperty2.default)(esql_lexer, "SHOW_WS", 151);
(0, _defineProperty2.default)(esql_lexer, "EOF", _antlr.Token.EOF);
(0, _defineProperty2.default)(esql_lexer, "CHANGE_POINT_MODE", 1);
(0, _defineProperty2.default)(esql_lexer, "ENRICH_MODE", 2);
(0, _defineProperty2.default)(esql_lexer, "ENRICH_FIELD_MODE", 3);
(0, _defineProperty2.default)(esql_lexer, "EXPLAIN_MODE", 4);
(0, _defineProperty2.default)(esql_lexer, "EXPRESSION_MODE", 5);
(0, _defineProperty2.default)(esql_lexer, "FROM_MODE", 6);
(0, _defineProperty2.default)(esql_lexer, "FORK_MODE", 7);
(0, _defineProperty2.default)(esql_lexer, "FUSE_MODE", 8);
(0, _defineProperty2.default)(esql_lexer, "INLINE_MODE", 9);
(0, _defineProperty2.default)(esql_lexer, "JOIN_MODE", 10);
(0, _defineProperty2.default)(esql_lexer, "LOOKUP_MODE", 11);
(0, _defineProperty2.default)(esql_lexer, "LOOKUP_FIELD_MODE", 12);
(0, _defineProperty2.default)(esql_lexer, "MVEXPAND_MODE", 13);
(0, _defineProperty2.default)(esql_lexer, "PROJECT_MODE", 14);
(0, _defineProperty2.default)(esql_lexer, "RENAME_MODE", 15);
(0, _defineProperty2.default)(esql_lexer, "SET_MODE", 16);
(0, _defineProperty2.default)(esql_lexer, "SHOW_MODE", 17);
(0, _defineProperty2.default)(esql_lexer, "channelNames", ["DEFAULT_TOKEN_CHANNEL", "HIDDEN"]);
(0, _defineProperty2.default)(esql_lexer, "literalNames", [null, null, null, null, "'change_point'", "'enrich'", null, "'completion'", "'dissect'", "'eval'", "'grok'", "'limit'", "'rerank'", "'row'", "'sample'", "'sort'", null, "'where'", "'from'", "'ts'", "'fork'", "'fuse'", "'inline'", "'inlinestats'", "'lookup'", null, null, null, null, "'mv_expand'", "'drop'", "'keep'", null, "'rename'", "'set'", "'show'", null, null, null, null, null, null, null, null, null, null, null, null, null, null, "'|'", null, null, null, "'and'", "'asc'", "'='", "'by'", "'::'", "':'", "';'", "','", "'desc'", "'.'", "'false'", "'first'", "'in'", "'is'", "'last'", "'like'", "'not'", "'null'", "'nulls'", "'on'", "'or'", "'?'", "'rlike'", "'true'", "'with'", "'=='", "'=~'", "'!='", "'<'", "'<='", "'>'", "'>='", "'+'", "'-'", "'*'", "'/'", "'%'", "'{'", "'}'", "'??'", null, null, null, "']'", null, "')'", null, null, null, null, null, "'metadata'", null, null, null, null, null, null, null, "'group'", "'score'", "'key'", null, null, null, null, null, null, null, "'join'", "'USING'", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "'as'", null, null, null, null, null, null, "'info'"]);
(0, _defineProperty2.default)(esql_lexer, "symbolicNames", [null, "LINE_COMMENT", "MULTILINE_COMMENT", "WS", "CHANGE_POINT", "ENRICH", "DEV_EXPLAIN", "COMPLETION", "DISSECT", "EVAL", "GROK", "LIMIT", "RERANK", "ROW", "SAMPLE", "SORT", "STATS", "WHERE", "FROM", "TS", "FORK", "FUSE", "INLINE", "INLINESTATS", "JOIN_LOOKUP", "DEV_JOIN_FULL", "DEV_JOIN_LEFT", "DEV_JOIN_RIGHT", "DEV_LOOKUP", "MV_EXPAND", "DROP", "KEEP", "DEV_INSIST", "RENAME", "SET", "SHOW", "UNKNOWN_CMD", "CHANGE_POINT_LINE_COMMENT", "CHANGE_POINT_MULTILINE_COMMENT", "CHANGE_POINT_WS", "ENRICH_POLICY_NAME", "ENRICH_LINE_COMMENT", "ENRICH_MULTILINE_COMMENT", "ENRICH_WS", "ENRICH_FIELD_LINE_COMMENT", "ENRICH_FIELD_MULTILINE_COMMENT", "ENRICH_FIELD_WS", "EXPLAIN_WS", "EXPLAIN_LINE_COMMENT", "EXPLAIN_MULTILINE_COMMENT", "PIPE", "QUOTED_STRING", "INTEGER_LITERAL", "DECIMAL_LITERAL", "AND", "ASC", "ASSIGN", "BY", "CAST_OP", "COLON", "SEMICOLON", "COMMA", "DESC", "DOT", "FALSE", "FIRST", "IN", "IS", "LAST", "LIKE", "NOT", "NULL", "NULLS", "ON", "OR", "PARAM", "RLIKE", "TRUE", "WITH", "EQ", "CIEQ", "NEQ", "LT", "LTE", "GT", "GTE", "PLUS", "MINUS", "ASTERISK", "SLASH", "PERCENT", "LEFT_BRACES", "RIGHT_BRACES", "DOUBLE_PARAMS", "NAMED_OR_POSITIONAL_PARAM", "NAMED_OR_POSITIONAL_DOUBLE_PARAMS", "OPENING_BRACKET", "CLOSING_BRACKET", "LP", "RP", "UNQUOTED_IDENTIFIER", "QUOTED_IDENTIFIER", "EXPR_LINE_COMMENT", "EXPR_MULTILINE_COMMENT", "EXPR_WS", "METADATA", "UNQUOTED_SOURCE", "FROM_LINE_COMMENT", "FROM_MULTILINE_COMMENT", "FROM_WS", "FORK_WS", "FORK_LINE_COMMENT", "FORK_MULTILINE_COMMENT", "GROUP", "SCORE", "KEY", "FUSE_LINE_COMMENT", "FUSE_MULTILINE_COMMENT", "FUSE_WS", "INLINE_STATS", "INLINE_LINE_COMMENT", "INLINE_MULTILINE_COMMENT", "INLINE_WS", "JOIN", "USING", "JOIN_LINE_COMMENT", "JOIN_MULTILINE_COMMENT", "JOIN_WS", "LOOKUP_LINE_COMMENT", "LOOKUP_MULTILINE_COMMENT", "LOOKUP_WS", "LOOKUP_FIELD_LINE_COMMENT", "LOOKUP_FIELD_MULTILINE_COMMENT", "LOOKUP_FIELD_WS", "MVEXPAND_LINE_COMMENT", "MVEXPAND_MULTILINE_COMMENT", "MVEXPAND_WS", "ID_PATTERN", "PROJECT_LINE_COMMENT", "PROJECT_MULTILINE_COMMENT", "PROJECT_WS", "AS", "RENAME_LINE_COMMENT", "RENAME_MULTILINE_COMMENT", "RENAME_WS", "SET_LINE_COMMENT", "SET_MULTILINE_COMMENT", "SET_WS", "INFO", "SHOW_LINE_COMMENT", "SHOW_MULTILINE_COMMENT", "SHOW_WS"]);
(0, _defineProperty2.default)(esql_lexer, "modeNames", ["DEFAULT_MODE", "CHANGE_POINT_MODE", "ENRICH_MODE", "ENRICH_FIELD_MODE", "EXPLAIN_MODE", "EXPRESSION_MODE", "FROM_MODE", "FORK_MODE", "FUSE_MODE", "INLINE_MODE", "JOIN_MODE", "LOOKUP_MODE", "LOOKUP_FIELD_MODE", "MVEXPAND_MODE", "PROJECT_MODE", "RENAME_MODE", "SET_MODE", "SHOW_MODE"]);
(0, _defineProperty2.default)(esql_lexer, "ruleNames", ["LINE_COMMENT", "MULTILINE_COMMENT", "WS", "CHANGE_POINT", "ENRICH", "DEV_EXPLAIN", "COMPLETION", "DISSECT", "EVAL", "GROK", "LIMIT", "RERANK", "ROW", "SAMPLE", "SORT", "STATS", "WHERE", "FROM", "TS", "FORK", "FUSE", "INLINE", "INLINESTATS", "JOIN_LOOKUP", "DEV_JOIN_FULL", "DEV_JOIN_LEFT", "DEV_JOIN_RIGHT", "DEV_LOOKUP", "MV_EXPAND", "DROP", "KEEP", "DEV_INSIST", "RENAME", "SET", "SHOW", "UNKNOWN_CMD", "CHANGE_POINT_PIPE", "CHANGE_POINT_RP", "CHANGE_POINT_ON", "CHANGE_POINT_AS", "CHANGE_POINT_DOT", "CHANGE_POINT_COMMA", "CHANGE_POINT_OPENING_BRACKET", "CHANGE_POINT_CLOSING_BRACKET", "CHANGE_POINT_QUOTED_IDENTIFIER", "CHANGE_POINT_UNQUOTED_IDENTIFIER", "CHANGE_POINT_LINE_COMMENT", "CHANGE_POINT_MULTILINE_COMMENT", "CHANGE_POINT_WS", "ENRICH_PIPE", "ENRICH_RP", "ENRICH_ON", "ENRICH_WITH", "ENRICH_POLICY_NAME_BODY", "ENRICH_POLICY_NAME", "ENRICH_MODE_UNQUOTED_VALUE", "ENRICH_QUOTED_POLICY_NAME", "ENRICH_LINE_COMMENT", "ENRICH_MULTILINE_COMMENT", "ENRICH_WS", "ENRICH_FIELD_PIPE", "ENRICH_FIELD_RP", "ENRICH_FIELD_OPENING_BRACKET", "ENRICH_FIELD_CLOSING_BRACKET", "ENRICH_FIELD_ASSIGN", "ENRICH_FIELD_COMMA", "ENRICH_FIELD_DOT", "ENRICH_FIELD_WITH", "ENRICH_FIELD_ID_PATTERN", "ENRICH_FIELD_QUOTED_IDENTIFIER", "ENRICH_FIELD_PARAM", "ENRICH_FIELD_NAMED_OR_POSITIONAL_PARAM", "ENRICH_FIELD_DOUBLE_PARAMS", "ENRICH_FIELD_NAMED_OR_POSITIONAL_DOUBLE_PARAMS", "ENRICH_FIELD_LINE_COMMENT", "ENRICH_FIELD_MULTILINE_COMMENT", "ENRICH_FIELD_WS", "EXPLAIN_LP", "EXPLAIN_PIPE", "EXPLAIN_WS", "EXPLAIN_LINE_COMMENT", "EXPLAIN_MULTILINE_COMMENT", "PIPE", "DIGIT", "LETTER", "ESCAPE_SEQUENCE", "UNESCAPED_CHARS", "EXPONENT", "ASPERAND", "BACKQUOTE", "BACKQUOTE_BLOCK", "UNDERSCORE", "UNQUOTED_ID_BODY", "QUOTED_STRING", "INTEGER_LITERAL", "DECIMAL_LITERAL", "AND", "ASC", "ASSIGN", "BY", "CAST_OP", "COLON", "SEMICOLON", "COMMA", "DESC", "DOT", "FALSE", "FIRST", "IN", "IS", "LAST", "LIKE", "NOT", "NULL", "NULLS", "ON", "OR", "PARAM", "RLIKE", "TRUE", "WITH", "EQ", "CIEQ", "NEQ", "LT", "LTE", "GT", "GTE", "PLUS", "MINUS", "ASTERISK", "SLASH", "PERCENT", "LEFT_BRACES", "RIGHT_BRACES", "DOUBLE_PARAMS", "NESTED_WHERE", "NAMED_OR_POSITIONAL_PARAM", "NAMED_OR_POSITIONAL_DOUBLE_PARAMS", "OPENING_BRACKET", "CLOSING_BRACKET", "LP", "RP", "UNQUOTED_IDENTIFIER", "QUOTED_ID", "QUOTED_IDENTIFIER", "EXPR_LINE_COMMENT", "EXPR_MULTILINE_COMMENT", "EXPR_WS", "FROM_PIPE", "FROM_COLON", "FROM_SELECTOR", "FROM_COMMA", "FROM_ASSIGN", "METADATA", "FROM_RP", "FROM_LP", "UNQUOTED_SOURCE_PART", "UNQUOTED_SOURCE", "FROM_UNQUOTED_SOURCE", "FROM_QUOTED_SOURCE", "FROM_LINE_COMMENT", "FROM_MULTILINE_COMMENT", "FROM_WS", "FORK_LP", "FORK_RP", "FORK_PIPE", "FORK_WS", "FORK_LINE_COMMENT", "FORK_MULTILINE_COMMENT", "FUSE_PIPE", "FUSE_RP", "GROUP", "SCORE", "KEY", "FUSE_WITH", "FUSE_COMMA", "FUSE_DOT", "FUSE_PARAM", "FUSE_NAMED_OR_POSITIONAL_PARAM", "FUSE_DOUBLE_PARAMS", "FUSE_NAMED_OR_POSITIONAL_DOUBLE_PARAMS", "FUSE_BY", "FUSE_QUOTED_IDENTIFIER", "FUSE_UNQUOTED_IDENTIFIER", "FUSE_LINE_COMMENT", "FUSE_MULTILINE_COMMENT", "FUSE_WS", "INLINE_STATS", "INLINE_LINE_COMMENT", "INLINE_MULTILINE_COMMENT", "INLINE_WS", "JOIN_PIPE", "JOIN", "JOIN_AS", "JOIN_ON", "USING", "JOIN_UNQUOTED_SOURCE", "JOIN_QUOTED_SOURCE", "JOIN_COLON", "JOIN_LINE_COMMENT", "JOIN_MULTILINE_COMMENT", "JOIN_WS", "LOOKUP_PIPE", "LOOKUP_RP", "LOOKUP_COLON", "LOOKUP_COMMA", "LOOKUP_DOT", "LOOKUP_ON", "LOOKUP_UNQUOTED_SOURCE", "LOOKUP_QUOTED_SOURCE", "LOOKUP_LINE_COMMENT", "LOOKUP_MULTILINE_COMMENT", "LOOKUP_WS", "LOOKUP_FIELD_PIPE", "LOOK_FIELD_RP", "LOOKUP_FIELD_COMMA", "LOOKUP_FIELD_DOT", "LOOKUP_FIELD_ID_PATTERN", "LOOKUP_FIELD_LINE_COMMENT", "LOOKUP_FIELD_MULTILINE_COMMENT", "LOOKUP_FIELD_WS", "MVEXPAND_PIPE", "MVEXPAND_RP", "MV_EXPAND_OPENING_BRACKET", "MV_EXPAND_CLOSING_BRACKET", "MVEXPAND_DOT", "MVEXPAND_PARAM", "MVEXPAND_NAMED_OR_POSITIONAL_PARAM", "MVEXPAND_DOUBLE_PARAMS", "MVEXPAND_NAMED_OR_POSITIONAL_DOUBLE_PARAMS", "MVEXPAND_QUOTED_IDENTIFIER", "MVEXPAND_UNQUOTED_IDENTIFIER", "MVEXPAND_LINE_COMMENT", "MVEXPAND_MULTILINE_COMMENT", "MVEXPAND_WS", "PROJECT_PIPE", "PROJECT_RP", "PROJECT_DOT", "PROJECT_OPENING_BRACKET", "PROJECT_CLOSING_BRACKET", "PROJECT_COMMA", "PROJECT_PARAM", "PROJECT_NAMED_OR_POSITIONAL_PARAM", "PROJECT_DOUBLE_PARAMS", "PROJECT_NAMED_OR_POSITIONAL_DOUBLE_PARAMS", "UNQUOTED_ID_BODY_WITH_PATTERN", "UNQUOTED_ID_PATTERN", "ID_PATTERN", "PROJECT_LINE_COMMENT", "PROJECT_MULTILINE_COMMENT", "PROJECT_WS", "RENAME_PIPE", "RENAME_RP", "RENAME_OPENING_BRACKET", "RENAME_CLOSING_BRACKET", "RENAME_ASSIGN", "RENAME_COMMA", "RENAME_DOT", "RENAME_PARAM", "RENAME_NAMED_OR_POSITIONAL_PARAM", "RENAME_DOUBLE_PARAMS", "RENAME_NAMED_OR_POSITIONAL_DOUBLE_PARAMS", "AS", "RENAME_ID_PATTERN", "RENAME_LINE_COMMENT", "RENAME_MULTILINE_COMMENT", "RENAME_WS", "SET_TRUE", "SET_FALSE", "SET_NULL", "SET_SEMICOLON", "SET_ASSIGN", "SET_QUOTED_STRING", "SET_UNQUOTED_IDENTIFIER", "SET_QUOTED_IDENTIFIER", "SET_DECIMAL_LITERAL", "SET_INTEGER_LITERAL", "SET_COMMA", "SET_DOT", "SET_PARAM", "SET_NAMED_OR_POSITIONAL_PARAM", "SET_DOUBLE_PARAMS", "SET_NAMED_OR_POSITIONAL_DOUBLE_PARAMS", "SET_OPENING_BRACKET", "SET_CLOSING_BRACKET", "SET_ID_PATTERN", "SET_LINE_COMMENT", "SET_MULTILINE_COMMENT", "SET_WS", "SHOW_PIPE", "INFO", "SHOW_LINE_COMMENT", "SHOW_MULTILINE_COMMENT", "SHOW_WS"]);
(0, _defineProperty2.default)(esql_lexer, "_serializedATN", [4, 0, 151, 2158, 6, -1, 6, -1, 6, -1, 6, -1, 6, -1, 6, -1, 6, -1, 6, -1, 6, -1, 6, -1, 6, -1, 6, -1, 6, -1, 6, -1, 6, -1, 6, -1, 6, -1, 6, -1, 2, 0, 7, 0, 2, 1, 7, 1, 2, 2, 7, 2, 2, 3, 7, 3, 2, 4, 7, 4, 2, 5, 7, 5, 2, 6, 7, 6, 2, 7, 7, 7, 2, 8, 7, 8, 2, 9, 7, 9, 2, 10, 7, 10, 2, 11, 7, 11, 2, 12, 7, 12, 2, 13, 7, 13, 2, 14, 7, 14, 2, 15, 7, 15, 2, 16, 7, 16, 2, 17, 7, 17, 2, 18, 7, 18, 2, 19, 7, 19, 2, 20, 7, 20, 2, 21, 7, 21, 2, 22, 7, 22, 2, 23, 7, 23, 2, 24, 7, 24, 2, 25, 7, 25, 2, 26, 7, 26, 2, 27, 7, 27, 2, 28, 7, 28, 2, 29, 7, 29, 2, 30, 7, 30, 2, 31, 7, 31, 2, 32, 7, 32, 2, 33, 7, 33, 2, 34, 7, 34, 2, 35, 7, 35, 2, 36, 7, 36, 2, 37, 7, 37, 2, 38, 7, 38, 2, 39, 7, 39, 2, 40, 7, 40, 2, 41, 7, 41, 2, 42, 7, 42, 2, 43, 7, 43, 2, 44, 7, 44, 2, 45, 7, 45, 2, 46, 7, 46, 2, 47, 7, 47, 2, 48, 7, 48, 2, 49, 7, 49, 2, 50, 7, 50, 2, 51, 7, 51, 2, 52, 7, 52, 2, 53, 7, 53, 2, 54, 7, 54, 2, 55, 7, 55, 2, 56, 7, 56, 2, 57, 7, 57, 2, 58, 7, 58, 2, 59, 7, 59, 2, 60, 7, 60, 2, 61, 7, 61, 2, 62, 7, 62, 2, 63, 7, 63, 2, 64, 7, 64, 2, 65, 7, 65, 2, 66, 7, 66, 2, 67, 7, 67, 2, 68, 7, 68, 2, 69, 7, 69, 2, 70, 7, 70, 2, 71, 7, 71, 2, 72, 7, 72, 2, 73, 7, 73, 2, 74, 7, 74, 2, 75, 7, 75, 2, 76, 7, 76, 2, 77, 7, 77, 2, 78, 7, 78, 2, 79, 7, 79, 2, 80, 7, 80, 2, 81, 7, 81, 2, 82, 7, 82, 2, 83, 7, 83, 2, 84, 7, 84, 2, 85, 7, 85, 2, 86, 7, 86, 2, 87, 7, 87, 2, 88, 7, 88, 2, 89, 7, 89, 2, 90, 7, 90, 2, 91, 7, 91, 2, 92, 7, 92, 2, 93, 7, 93, 2, 94, 7, 94, 2, 95, 7, 95, 2, 96, 7, 96, 2, 97, 7, 97, 2, 98, 7, 98, 2, 99, 7, 99, 2, 100, 7, 100, 2, 101, 7, 101, 2, 102, 7, 102, 2, 103, 7, 103, 2, 104, 7, 104, 2, 105, 7, 105, 2, 106, 7, 106, 2, 107, 7, 107, 2, 108, 7, 108, 2, 109, 7, 109, 2, 110, 7, 110, 2, 111, 7, 111, 2, 112, 7, 112, 2, 113, 7, 113, 2, 114, 7, 114, 2, 115, 7, 115, 2, 116, 7, 116, 2, 117, 7, 117, 2, 118, 7, 118, 2, 119, 7, 119, 2, 120, 7, 120, 2, 121, 7, 121, 2, 122, 7, 122, 2, 123, 7, 123, 2, 124, 7, 124, 2, 125, 7, 125, 2, 126, 7, 126, 2, 127, 7, 127, 2, 128, 7, 128, 2, 129, 7, 129, 2, 130, 7, 130, 2, 131, 7, 131, 2, 132, 7, 132, 2, 133, 7, 133, 2, 134, 7, 134, 2, 135, 7, 135, 2, 136, 7, 136, 2, 137, 7, 137, 2, 138, 7, 138, 2, 139, 7, 139, 2, 140, 7, 140, 2, 141, 7, 141, 2, 142, 7, 142, 2, 143, 7, 143, 2, 144, 7, 144, 2, 145, 7, 145, 2, 146, 7, 146, 2, 147, 7, 147, 2, 148, 7, 148, 2, 149, 7, 149, 2, 150, 7, 150, 2, 151, 7, 151, 2, 152, 7, 152, 2, 153, 7, 153, 2, 154, 7, 154, 2, 155, 7, 155, 2, 156, 7, 156, 2, 157, 7, 157, 2, 158, 7, 158, 2, 159, 7, 159, 2, 160, 7, 160, 2, 161, 7, 161, 2, 162, 7, 162, 2, 163, 7, 163, 2, 164, 7, 164, 2, 165, 7, 165, 2, 166, 7, 166, 2, 167, 7, 167, 2, 168, 7, 168, 2, 169, 7, 169, 2, 170, 7, 170, 2, 171, 7, 171, 2, 172, 7, 172, 2, 173, 7, 173, 2, 174, 7, 174, 2, 175, 7, 175, 2, 176, 7, 176, 2, 177, 7, 177, 2, 178, 7, 178, 2, 179, 7, 179, 2, 180, 7, 180, 2, 181, 7, 181, 2, 182, 7, 182, 2, 183, 7, 183, 2, 184, 7, 184, 2, 185, 7, 185, 2, 186, 7, 186, 2, 187, 7, 187, 2, 188, 7, 188, 2, 189, 7, 189, 2, 190, 7, 190, 2, 191, 7, 191, 2, 192, 7, 192, 2, 193, 7, 193, 2, 194, 7, 194, 2, 195, 7, 195, 2, 196, 7, 196, 2, 197, 7, 197, 2, 198, 7, 198, 2, 199, 7, 199, 2, 200, 7, 200, 2, 201, 7, 201, 2, 202, 7, 202, 2, 203, 7, 203, 2, 204, 7, 204, 2, 205, 7, 205, 2, 206, 7, 206, 2, 207, 7, 207, 2, 208, 7, 208, 2, 209, 7, 209, 2, 210, 7, 210, 2, 211, 7, 211, 2, 212, 7, 212, 2, 213, 7, 213, 2, 214, 7, 214, 2, 215, 7, 215, 2, 216, 7, 216, 2, 217, 7, 217, 2, 218, 7, 218, 2, 219, 7, 219, 2, 220, 7, 220, 2, 221, 7, 221, 2, 222, 7, 222, 2, 223, 7, 223, 2, 224, 7, 224, 2, 225, 7, 225, 2, 226, 7, 226, 2, 227, 7, 227, 2, 228, 7, 228, 2, 229, 7, 229, 2, 230, 7, 230, 2, 231, 7, 231, 2, 232, 7, 232, 2, 233, 7, 233, 2, 234, 7, 234, 2, 235, 7, 235, 2, 236, 7, 236, 2, 237, 7, 237, 2, 238, 7, 238, 2, 239, 7, 239, 2, 240, 7, 240, 2, 241, 7, 241, 2, 242, 7, 242, 2, 243, 7, 243, 2, 244, 7, 244, 2, 245, 7, 245, 2, 246, 7, 246, 2, 247, 7, 247, 2, 248, 7, 248, 2, 249, 7, 249, 2, 250, 7, 250, 2, 251, 7, 251, 2, 252, 7, 252, 2, 253, 7, 253, 2, 254, 7, 254, 2, 255, 7, 255, 2, 256, 7, 256, 2, 257, 7, 257, 2, 258, 7, 258, 2, 259, 7, 259, 2, 260, 7, 260, 2, 261, 7, 261, 2, 262, 7, 262, 2, 263, 7, 263, 2, 264, 7, 264, 2, 265, 7, 265, 2, 266, 7, 266, 2, 267, 7, 267, 2, 268, 7, 268, 2, 269, 7, 269, 2, 270, 7, 270, 2, 271, 7, 271, 2, 272, 7, 272, 2, 273, 7, 273, 2, 274, 7, 274, 2, 275, 7, 275, 2, 276, 7, 276, 2, 277, 7, 277, 2, 278, 7, 278, 2, 279, 7, 279, 2, 280, 7, 280, 2, 281, 7, 281, 2, 282, 7, 282, 2, 283, 7, 283, 2, 284, 7, 284, 2, 285, 7, 285, 2, 286, 7, 286, 2, 287, 7, 287, 2, 288, 7, 288, 2, 289, 7, 289, 2, 290, 7, 290, 2, 291, 7, 291, 2, 292, 7, 292, 2, 293, 7, 293, 2, 294, 7, 294, 1, 0, 1, 0, 1, 0, 1, 0, 5, 0, 613, 8, 0, 10, 0, 12, 0, 616, 9, 0, 1, 0, 3, 0, 619, 8, 0, 1, 0, 3, 0, 622, 8, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 5, 1, 631, 8, 1, 10, 1, 12, 1, 634, 9, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 4, 2, 642, 8, 2, 11, 2, 12, 2, 643, 1, 2, 1, 2, 1, 3, 1, 3, 1, 3, 1, 3, 1, 3, 1, 3, 1, 3, 1, 3, 1, 3, 1, 3, 1, 3, 1, 3, 1, 3, 1, 3, 1, 3, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 4, 1, 5, 1, 5, 1, 5, 1, 5, 1, 5, 1, 5, 1, 5, 1, 5, 1, 5, 1, 5, 1, 5, 1, 6, 1, 6, 1, 6, 1, 6, 1, 6, 1, 6, 1, 6, 1, 6, 1, 6, 1, 6, 1, 6, 1, 6, 1, 6, 1, 7, 1, 7, 1, 7, 1, 7, 1, 7, 1, 7, 1, 7, 1, 7, 1, 7, 1, 7, 1, 8, 1, 8, 1, 8, 1, 8, 1, 8, 1, 8, 1, 8, 1, 9, 1, 9, 1, 9, 1, 9, 1, 9, 1, 9, 1, 9, 1, 10, 1, 10, 1, 10, 1, 10, 1, 10, 1, 10, 1, 10, 1, 10, 1, 11, 1, 11, 1, 11, 1, 11, 1, 11, 1, 11, 1, 11, 1, 11, 1, 11, 1, 12, 1, 12, 1, 12, 1, 12, 1, 12, 1, 12, 1, 13, 1, 13, 1, 13, 1, 13, 1, 13, 1, 13, 1, 13, 1, 13, 1, 13, 1, 14, 1, 14, 1, 14, 1, 14, 1, 14, 1, 14, 1, 14, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 15, 1, 16, 1, 16, 1, 16, 1, 16, 1, 16, 1, 16, 1, 16, 1, 16, 1, 17, 1, 17, 1, 17, 1, 17, 1, 17, 1, 17, 1, 17, 1, 18, 1, 18, 1, 18, 1, 18, 1, 18, 1, 19, 1, 19, 1, 19, 1, 19, 1, 19, 1, 19, 1, 19, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 20, 1, 21, 1, 21, 1, 21, 1, 21, 1, 21, 1, 21, 1, 21, 1, 21, 1, 21, 1, 22, 1, 22, 1, 22, 1, 22, 1, 22, 1, 22, 1, 22, 1, 22, 1, 22, 1, 22, 1, 22, 1, 22, 1, 22, 1, 22, 1, 23, 1, 23, 1, 23, 1, 23, 1, 23, 1, 23, 1, 23, 1, 23, 1, 23, 1, 24, 1, 24, 1, 24, 1, 24, 1, 24, 1, 24, 1, 24, 1, 24, 1, 25, 1, 25, 1, 25, 1, 25, 1, 25, 1, 25, 1, 25, 1, 25, 1, 26, 1, 26, 1, 26, 1, 26, 1, 26, 1, 26, 1, 26, 1, 26, 1, 26, 1, 27, 1, 27, 1, 27, 1, 27, 1, 27, 1, 27, 1, 27, 1, 27, 1, 27, 1, 27, 1, 27, 1, 27, 1, 28, 1, 28, 1, 28, 1, 28, 1, 28, 1, 28, 1, 28, 1, 28, 1, 28, 1, 28, 1, 28, 1, 28, 1, 29, 1, 29, 1, 29, 1, 29, 1, 29, 1, 29, 1, 29, 1, 30, 1, 30, 1, 30, 1, 30, 1, 30, 1, 30, 1, 30, 1, 31, 1, 31, 1, 31, 1, 31, 1, 31, 1, 31, 1, 31, 1, 31, 1, 31, 1, 31, 1, 31, 1, 31, 1, 32, 1, 32, 1, 32, 1, 32, 1, 32, 1, 32, 1, 32, 1, 32, 1, 32, 1, 33, 1, 33, 1, 33, 1, 33, 1, 33, 1, 33, 1, 34, 1, 34, 1, 34, 1, 34, 1, 34, 1, 34, 1, 34, 1, 35, 4, 35, 931, 8, 35, 11, 35, 12, 35, 932, 1, 35, 1, 35, 1, 36, 1, 36, 1, 36, 1, 36, 1, 36, 1, 37, 1, 37, 1, 37, 1, 37, 1, 37, 1, 37, 1, 38, 1, 38, 1, 38, 1, 38, 1, 39, 1, 39, 1, 39, 1, 39, 1, 40, 1, 40, 1, 40, 1, 40, 1, 41, 1, 41, 1, 41, 1, 41, 1, 42, 1, 42, 1, 42, 1, 42, 1, 43, 1, 43, 1, 43, 1, 43, 1, 44, 1, 44, 1, 44, 1, 44, 1, 45, 1, 45, 1, 45, 1, 45, 1, 46, 1, 46, 1, 46, 1, 46, 1, 47, 1, 47, 1, 47, 1, 47, 1, 48, 1, 48, 1, 48, 1, 48, 1, 49, 1, 49, 1, 49, 1, 49, 1, 49, 1, 50, 1, 50, 1, 50, 1, 50, 1, 50, 1, 50, 1, 51, 1, 51, 1, 51, 1, 51, 1, 51, 1, 52, 1, 52, 1, 52, 1, 52, 1, 52, 1, 53, 1, 53, 1, 54, 4, 54, 1016, 8, 54, 11, 54, 12, 54, 1017, 1, 54, 1, 54, 3, 54, 1022, 8, 54, 1, 54, 4, 54, 1025, 8, 54, 11, 54, 12, 54, 1026, 1, 55, 1, 55, 1, 55, 1, 55, 1, 56, 1, 56, 1, 56, 1, 56, 1, 57, 1, 57, 1, 57, 1, 57, 1, 58, 1, 58, 1, 58, 1, 58, 1, 59, 1, 59, 1, 59, 1, 59, 1, 60, 1, 60, 1, 60, 1, 60, 1, 60, 1, 60, 1, 61, 1, 61, 1, 61, 1, 61, 1, 61, 1, 61, 1, 61, 1, 62, 1, 62, 1, 62, 1, 62, 1, 63, 1, 63, 1, 63, 1, 63, 1, 64, 1, 64, 1, 64, 1, 64, 1, 65, 1, 65, 1, 65, 1, 65, 1, 66, 1, 66, 1, 66, 1, 66, 1, 67, 1, 67, 1, 67, 1, 67, 1, 68, 1, 68, 1, 68, 1, 68, 1, 69, 1, 69, 1, 69, 1, 69, 1, 70, 1, 70, 1, 70, 1, 70, 1, 71, 1, 71, 1, 71, 1, 71, 1, 72, 1, 72, 1, 72, 1, 72, 1, 73, 1, 73, 1, 73, 1, 73, 1, 74, 1, 74, 1, 74, 1, 74, 1, 75, 1, 75, 1, 75, 1, 75, 1, 76, 1, 76, 1, 76, 1, 76, 1, 77, 1, 77, 1, 77, 1, 77, 1, 77, 1, 78, 1, 78, 1, 78, 1, 78, 1, 78, 1, 79, 1, 79, 1, 79, 1, 79, 1, 80, 1, 80, 1, 80, 1, 80, 1, 81, 1, 81, 1, 81, 1, 81, 1, 82, 1, 82, 1, 82, 1, 82, 1, 83, 1, 83, 1, 84, 1, 84, 1, 85, 1, 85, 1, 85, 1, 86, 1, 86, 1, 87, 1, 87, 3, 87, 1159, 8, 87, 1, 87, 4, 87, 1162, 8, 87, 11, 87, 12, 87, 1163, 1, 88, 1, 88, 1, 89, 1, 89, 1, 90, 1, 90, 1, 90, 3, 90, 1173, 8, 90, 1, 91, 1, 91, 1, 92, 1, 92, 1, 92, 3, 92, 1180, 8, 92, 1, 93, 1, 93, 1, 93, 5, 93, 1185, 8, 93, 10, 93, 12, 93, 1188, 9, 93, 1, 93, 1, 93, 1, 93, 1, 93, 1, 93, 1, 93, 5, 93, 1196, 8, 93, 10, 93, 12, 93, 1199, 9, 93, 1, 93, 1, 93, 1, 93, 1, 93, 1, 93, 3, 93, 1206, 8, 93, 1, 93, 3, 93, 1209, 8, 93, 3, 93, 1211, 8, 93, 1, 94, 4, 94, 1214, 8, 94, 11, 94, 12, 94, 1215, 1, 95, 4, 95, 1219, 8, 95, 11, 95, 12, 95, 1220, 1, 95, 1, 95, 5, 95, 1225, 8, 95, 10, 95, 12, 95, 1228, 9, 95, 1, 95, 1, 95, 4, 95, 1232, 8, 95, 11, 95, 12, 95, 1233, 1, 95, 4, 95, 1237, 8, 95, 11, 95, 12, 95, 1238, 1, 95, 1, 95, 5, 95, 1243, 8, 95, 10, 95, 12, 95, 1246, 9, 95, 3, 95, 1248, 8, 95, 1, 95, 1, 95, 1, 95, 1, 95, 4, 95, 1254, 8, 95, 11, 95, 12, 95, 1255, 1, 95, 1, 95, 3, 95, 1260, 8, 95, 1, 96, 1, 96, 1, 96, 1, 96, 1, 97, 1, 97, 1, 97, 1, 97, 1, 98, 1, 98, 1, 99, 1, 99, 1, 99, 1, 100, 1, 100, 1, 100, 1, 101, 1, 101, 1, 102, 1, 102, 1, 103, 1, 103, 1, 104, 1, 104, 1, 104, 1, 104, 1, 104, 1, 105, 1, 105, 1, 106, 1, 106, 1, 106, 1, 106, 1, 106, 1, 106, 1, 107, 1, 107, 1, 107, 1, 107, 1, 107, 1, 107, 1, 108, 1, 108, 1, 108, 1, 109, 1, 109, 1, 109, 1, 110, 1, 110, 1, 110, 1, 110, 1, 110, 1, 111, 1, 111, 1, 111, 1, 111, 1, 111, 1, 112, 1, 112, 1, 112, 1, 112, 1, 113, 1, 113, 1, 113, 1, 113, 1, 113, 1, 114, 1, 114, 1, 114, 1, 114, 1, 114, 1, 114, 1, 115, 1, 115, 1, 115, 1, 116, 1, 116, 1, 116, 1, 117, 1, 117, 1, 118, 1, 118, 1, 118, 1, 118, 1, 118, 1, 118, 1, 119, 1, 119, 1, 119, 1, 119, 1, 119, 1, 120, 1, 120, 1, 120, 1, 120, 1, 120, 1, 121, 1, 121, 1, 121, 1, 122, 1, 122, 1, 122, 1, 123, 1, 123, 1, 123, 1, 124, 1, 124, 1, 125, 1, 125, 1, 125, 1, 126, 1, 126, 1, 127, 1, 127, 1, 127, 1, 128, 1, 128, 1, 129, 1, 129, 1, 130, 1, 130, 1, 131, 1, 131, 1, 132, 1, 132, 1, 133, 1, 133, 1, 134, 1, 134, 1, 135, 1, 135, 1, 135, 1, 136, 1, 136, 1, 136, 1, 136, 1, 137, 1, 137, 1, 137, 3, 137, 1401, 8, 137, 1, 137, 5, 137, 1404, 8, 137, 10, 137, 12, 137, 1407, 9, 137, 1, 137, 1, 137, 4, 137, 1411, 8, 137, 11, 137, 12, 137, 1412, 3, 137, 1415, 8, 137, 1, 138, 1, 138, 1, 138, 3, 138, 1420, 8, 138, 1, 138, 5, 138, 1423, 8, 138, 10, 138, 12, 138, 1426, 9, 138, 1, 138, 1, 138, 4, 138, 1430, 8, 138, 11, 138, 12, 138, 1431, 3, 138, 1434, 8, 138, 1, 139, 1, 139, 1, 139, 1, 139, 1, 139, 1, 140, 1, 140, 1, 140, 1, 140, 1, 140, 1, 141, 1, 141, 1, 141, 1, 141, 1, 141, 1, 142, 1, 142, 1, 142, 1, 142, 1, 142, 1, 143, 1, 143, 5, 143, 1458, 8, 143, 10, 143, 12, 143, 1461, 9, 143, 1, 143, 1, 143, 3, 143, 1465, 8, 143, 1, 143, 4, 143, 1468, 8, 143, 11, 143, 12, 143, 1469, 3, 143, 1472, 8, 143, 1, 144, 1, 144, 4, 144, 1476, 8, 144, 11, 144, 12, 144, 1477, 1, 144, 1, 144, 1, 145, 1, 145, 1, 146, 1, 146, 1, 146, 1, 146, 1, 147, 1, 147, 1, 147, 1, 147, 1, 148, 1, 148, 1, 148, 1, 148, 1, 149, 1, 149, 1, 149, 1, 149, 1, 149, 1, 150, 1, 150, 1, 150, 1, 150, 1, 151, 1, 151, 1, 151, 1, 151, 1, 152, 1, 152, 1, 152, 1, 152, 1, 153, 1, 153, 1, 153, 1, 153, 1, 154, 1, 154, 1, 154, 1, 154, 1, 154, 1, 154, 1, 154, 1, 154, 1, 154, 1, 155, 1, 155, 1, 155, 1, 155, 1, 155, 1, 155, 1, 156, 1, 156, 1, 156, 1, 156, 1, 156, 1, 157, 1, 157, 1, 157, 3, 157, 1540, 8, 157, 1, 158, 4, 158, 1543, 8, 158, 11, 158, 12, 158, 1544, 1, 159, 1, 159, 1, 159, 1, 159, 1, 160, 1, 160, 1, 160, 1, 160, 1, 161, 1, 161, 1, 161, 1, 161, 1, 162, 1, 162, 1, 162, 1, 162, 1, 163, 1, 163, 1, 163, 1, 163, 1, 164, 1, 164, 1, 164, 1, 164, 1, 164, 1, 165, 1, 165, 1, 165, 1, 165, 1, 165, 1, 165, 1, 166, 1, 166, 1, 166, 1, 166, 1, 166, 1, 167, 1, 167, 1, 167, 1, 167, 1, 168, 1, 168, 1, 168, 1, 168, 1, 169, 1, 169, 1, 169, 1, 169, 1, 170, 1, 170, 1, 170, 1, 170, 1, 170, 1, 171, 1, 171, 1, 171, 1, 171, 1, 171, 1, 171, 1, 172, 1, 172, 1, 172, 1, 172, 1, 172, 1, 172, 1, 173, 1, 173, 1, 173, 1, 173, 1, 173, 1, 173, 1, 174, 1, 174, 1, 174, 1, 174, 1, 175, 1, 175, 1, 175, 1, 175, 1, 175, 1, 175, 1, 176, 1, 176, 1, 176, 1, 176, 1, 177, 1, 177, 1, 177, 1, 177, 1, 178, 1, 178, 1, 178, 1, 178, 1, 179, 1, 179, 1, 179, 1, 179, 1, 180, 1, 180, 1, 180, 1, 180, 1, 181, 1, 181, 1, 181, 1, 181, 1, 182, 1, 182, 1, 182, 1, 182, 1, 183, 1, 183, 1, 183, 1, 183, 1, 184, 1, 184, 1, 184, 1, 184, 1, 185, 1, 185, 1, 185, 1, 185, 1, 186, 1, 186, 1, 186, 1, 186, 1, 187, 1, 187, 1, 187, 1, 187, 1, 188, 1, 188, 1, 188, 1, 188, 1, 188, 1, 188, 1, 188, 1, 188, 1, 188, 1, 189, 1, 189, 1, 189, 1, 189, 1, 190, 1, 190, 1, 190, 1, 190, 1, 191, 1, 191, 1, 191, 1, 191, 1, 192, 1, 192, 1, 192, 1, 192, 1, 192, 1, 193, 1, 193, 1, 193, 1, 193, 1, 193, 1, 194, 1, 194, 1, 194, 1, 194, 1, 195, 1, 195, 1, 195, 1, 195, 1, 195, 1, 195, 1, 196, 1, 196, 1, 196, 1, 196, 1, 196, 1, 196, 1, 196, 1, 196, 1, 196, 1, 197, 1, 197, 1, 197, 1, 197, 1, 198, 1, 198, 1, 198, 1, 198, 1, 199, 1, 199, 1, 199, 1, 199, 1, 200, 1, 200, 1, 200, 1, 200, 1, 201, 1, 201, 1, 201, 1, 201, 1, 202, 1, 202, 1, 202, 1, 202, 1, 203, 1, 203, 1, 203, 1, 203, 1, 203, 1, 204, 1, 204, 1, 204, 1, 204, 1, 204, 1, 204, 1, 205, 1, 205, 1, 205, 1, 205, 1, 206, 1, 206, 1, 206, 1, 206, 1, 207, 1, 207, 1, 207, 1, 207, 1, 208, 1, 208, 1, 208, 1, 208, 1, 208, 1, 209, 1, 209, 1, 209, 1, 209, 1, 210, 1, 210, 1, 210, 1, 210, 1, 211, 1, 211, 1, 211, 1, 211, 1, 212, 1, 212, 1, 212, 1, 212, 1, 213, 1, 213, 1, 213, 1, 213, 1, 214, 1, 214, 1, 214, 1, 214, 1, 214, 1, 214, 1, 215, 1, 215, 1, 215, 1, 215, 1, 215, 1, 215, 1, 215, 1, 216, 1, 216, 1, 216, 1, 216, 1, 217, 1, 217, 1, 217, 1, 217, 1, 218, 1, 218, 1, 218, 1, 218, 1, 219, 1, 219, 1, 219, 1, 219, 1, 220, 1, 220, 1, 220, 1, 220, 1, 221, 1, 221, 1, 221, 1, 221, 1, 222, 1, 222, 1, 222, 1, 222, 1, 222, 1, 223, 1, 223, 1, 223, 1, 223, 1, 223, 1, 223, 1, 224, 1, 224, 1, 224, 1, 224, 1, 225, 1, 225, 1, 225, 1, 225, 1, 226, 1, 226, 1, 226, 1, 226, 1, 227, 1, 227, 1, 227, 1, 227, 1, 228, 1, 228, 1, 228, 1, 228, 1, 229, 1, 229, 1, 229, 1, 229, 1, 230, 1, 230, 1, 230, 1, 230, 1, 231, 1, 231, 1, 231, 1, 231, 1, 232, 1, 232, 1, 232, 1, 232, 1, 233, 1, 233, 1, 233, 1, 233, 1, 234, 1, 234, 1, 234, 1, 234, 1, 235, 1, 235, 1, 235, 1, 235, 1, 236, 1, 236, 1, 236, 1, 236, 1, 236, 1, 237, 1, 237, 1, 237, 1, 237, 1, 237, 1, 237, 1, 238, 1, 238, 1, 238, 1, 238, 1, 239, 1, 239, 1, 239, 1, 239, 1, 240, 1, 240, 1, 240, 1, 240, 1, 241, 1, 241, 1, 241, 1, 241, 1, 242, 1, 242, 1, 242, 1, 242, 1, 243, 1, 243, 1, 243, 1, 243, 1, 244, 1, 244, 1, 244, 1, 244, 1, 245, 1, 245, 1, 245, 1, 245, 1, 246, 1, 246, 1, 246, 1, 246, 3, 246, 1941, 8, 246, 1, 247, 1, 247, 3, 247, 1945, 8, 247, 1, 247, 5, 247, 1948, 8, 247, 10, 247, 12, 247, 1951, 9, 247, 1, 247, 1, 247, 3, 247, 1955, 8, 247, 1, 247, 4, 247, 1958, 8, 247, 11, 247, 12, 247, 1959, 3, 247, 1962, 8, 247, 1, 248, 1, 248, 4, 248, 1966, 8, 248, 11, 248, 12, 248, 1967, 1, 249, 1, 249, 1, 249, 1, 249, 1, 250, 1, 250, 1, 250, 1, 250, 1, 251, 1, 251, 1, 251, 1, 251, 1, 252, 1, 252, 1, 252, 1, 252, 1, 252, 1, 253, 1, 253, 1, 253, 1, 253, 1, 253, 1, 253, 1, 254, 1, 254, 1, 254, 1, 254, 1, 255, 1, 255, 1, 255, 1, 255, 1, 256, 1, 256, 1, 256, 1, 256, 1, 257, 1, 257, 1, 257, 1, 257, 1, 258, 1, 258, 1, 258, 1, 258, 1, 259, 1, 259, 1, 259, 1, 259, 1, 260, 1, 260, 1, 260, 1, 260, 1, 261, 1, 261, 1, 261, 1, 261, 1, 262, 1, 262, 1, 262, 1, 262, 1, 263, 1, 263, 1, 263, 1, 264, 1, 264, 1, 264, 1, 264, 1, 265, 1, 265, 1, 265, 1, 265, 1, 266, 1, 266, 1, 266, 1, 266, 1, 267, 1, 267, 1, 267, 1, 267, 1, 268, 1, 268, 1, 268, 1, 268, 1, 269, 1, 269, 1, 269, 1, 269, 1, 270, 1, 270, 1, 270, 1, 270, 1, 271, 1, 271, 1, 271, 1, 271, 1, 271, 1, 272, 1, 272, 1, 272, 1, 272, 1, 273, 1, 273, 1, 273, 1, 273, 1, 274, 1, 274, 1, 274, 1, 274, 1, 275, 1, 275, 1, 275, 1, 275, 1, 276, 1, 276, 1, 276, 1, 276, 1, 277, 1, 277, 1, 277, 1, 277, 1, 278, 1, 278, 1, 278, 1, 278, 1, 279, 1, 279, 1, 279, 1, 279, 1, 280, 1, 280, 1, 280, 1, 280, 1, 281, 1, 281, 1, 281, 1, 281, 1, 282, 1, 282, 1, 282, 1, 282, 1, 283, 1, 283, 1, 283, 1, 283, 1, 284, 1, 284, 1, 284, 1, 284, 1, 285, 1, 285, 1, 285, 1, 285, 1, 286, 1, 286, 1, 286, 1, 286, 1, 287, 1, 287, 1, 287, 1, 287, 1, 288, 1, 288, 1, 288, 1, 288, 1, 289, 1, 289, 1, 289, 1, 289, 1, 290, 1, 290, 1, 290, 1, 290, 1, 290, 1, 291, 1, 291, 1, 291, 1, 291, 1, 291, 1, 292, 1, 292, 1, 292, 1, 292, 1, 293, 1, 293, 1, 293, 1, 293, 1, 294, 1, 294, 1, 294, 1, 294, 2, 632, 1197, 0, 295, 18, 1, 20, 2, 22, 3, 24, 4, 26, 5, 28, 6, 30, 7, 32, 8, 34, 9, 36, 10, 38, 11, 40, 12, 42, 13, 44, 14, 46, 15, 48, 16, 50, 17, 52, 18, 54, 19, 56, 20, 58, 21, 60, 22, 62, 23, 64, 24, 66, 25, 68, 26, 70, 27, 72, 28, 74, 29, 76, 30, 78, 31, 80, 32, 82, 33, 84, 34, 86, 35, 88, 36, 90, 0, 92, 0, 94, 0, 96, 0, 98, 0, 100, 0, 102, 0, 104, 0, 106, 0, 108, 0, 110, 37, 112, 38, 114, 39, 116, 0, 118, 0, 120, 0, 122, 0, 124, 0, 126, 40, 128, 0, 130, 0, 132, 41, 134, 42, 136, 43, 138, 0, 140, 0, 142, 0, 144, 0, 146, 0, 148, 0, 150, 0, 152, 0, 154, 0, 156, 0, 158, 0, 160, 0, 162, 0, 164, 0, 166, 44, 168, 45, 170, 46, 172, 0, 174, 0, 176, 47, 178, 48, 180, 49, 182, 50, 184, 0, 186, 0, 188, 0, 190, 0, 192, 0, 194, 0, 196, 0, 198, 0, 200, 0, 202, 0, 204, 51, 206, 52, 208, 53, 210, 54, 212, 55, 214, 56, 216, 57, 218, 58, 220, 59, 222, 60, 224, 61, 226, 62, 228, 63, 230, 64, 232, 65, 234, 66, 236, 67, 238, 68, 240, 69, 242, 70, 244, 71, 246, 72, 248, 73, 250, 74, 252, 75, 254, 76, 256, 77, 258, 78, 260, 79, 262, 80, 264, 81, 266, 82, 268, 83, 270, 84, 272, 85, 274, 86, 276, 87, 278, 88, 280, 89, 282, 90, 284, 91, 286, 92, 288, 93, 290, 0, 292, 94, 294, 95, 296, 96, 298, 97, 300, 98, 302, 99, 304, 100, 306, 0, 308, 101, 310, 102, 312, 103, 314, 104, 316, 0, 318, 0, 320, 0, 322, 0, 324, 0, 326, 105, 328, 0, 330, 0, 332, 0, 334, 106, 336, 0, 338, 0, 340, 107, 342, 108, 344, 109, 346, 0, 348, 0, 350, 0, 352, 110, 354, 111, 356, 112, 358, 0, 360, 0, 362, 113, 364, 114, 366, 115, 368, 0, 370, 0, 372, 0, 374, 0, 376, 0, 378, 0, 380, 0, 382, 0, 384, 0, 386, 0, 388, 116, 390, 117, 392, 118, 394, 119, 396, 120, 398, 121, 400, 122, 402, 0, 404, 123, 406, 0, 408, 0, 410, 124, 412, 0, 414, 0, 416, 0, 418, 125, 420, 126, 422, 127, 424, 0, 426, 0, 428, 0, 430, 0, 432, 0, 434, 0, 436, 0, 438, 0, 440, 128, 442, 129, 444, 130, 446, 0, 448, 0, 450, 0, 452, 0, 454, 0, 456, 131, 458, 132, 460, 133, 462, 0, 464, 0, 466, 0, 468, 0, 470, 0, 472, 0, 474, 0, 476, 0, 478, 0, 480, 0, 482, 0, 484, 134, 486, 135, 488, 136, 490, 0, 492, 0, 494, 0, 496, 0, 498, 0, 500, 0, 502, 0, 504, 0, 506, 0, 508, 0, 510, 0, 512, 0, 514, 137, 516, 138, 518, 139, 520, 140, 522, 0, 524, 0, 526, 0, 528, 0, 530, 0, 532, 0, 534, 0, 536, 0, 538, 0, 540, 0, 542, 0, 544, 141, 546, 0, 548, 142, 550, 143, 552, 144, 554, 0, 556, 0, 558, 0, 560, 0, 562, 0, 564, 0, 566, 0, 568, 0, 570, 0, 572, 0, 574, 0, 576, 0, 578, 0, 580, 0, 582, 0, 584, 0, 586, 0, 588, 0, 590, 0, 592, 145, 594, 146, 596, 147, 598, 0, 600, 148, 602, 149, 604, 150, 606, 151, 18, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 36, 2, 0, 10, 10, 13, 13, 3, 0, 9, 10, 13, 13, 32, 32, 2, 0, 67, 67, 99, 99, 2, 0, 72, 72, 104, 104, 2, 0, 65, 65, 97, 97, 2, 0, 78, 78, 110, 110, 2, 0, 71, 71, 103, 103, 2, 0, 69, 69, 101, 101, 2, 0, 80, 80, 112, 112, 2, 0, 79, 79, 111, 111, 2, 0, 73, 73, 105, 105, 2, 0, 84, 84, 116, 116, 2, 0, 82, 82, 114, 114, 2, 0, 88, 88, 120, 120, 2, 0, 76, 76, 108, 108, 2, 0, 77, 77, 109, 109, 2, 0, 68, 68, 100, 100, 2, 0, 83, 83, 115, 115, 2, 0, 86, 86, 118, 118, 2, 0, 75, 75, 107, 107, 2, 0, 87, 87, 119, 119, 2, 0, 70, 70, 102, 102, 2, 0, 85, 85, 117, 117, 6, 0, 9, 10, 13, 13, 32, 32, 47, 47, 91, 91, 93, 93, 12, 0, 9, 10, 13, 13, 32, 32, 34, 35, 40, 41, 44, 44, 47, 47, 58, 58, 60, 60, 62, 63, 92, 92, 124, 124, 1, 0, 48, 57, 2, 0, 65, 90, 97, 122, 8, 0, 34, 34, 78, 78, 82, 82, 84, 84, 92, 92, 110, 110, 114, 114, 116, 116, 4, 0, 10, 10, 13, 13, 34, 34, 92, 92, 2, 0, 43, 43, 45, 45, 1, 0, 96, 96, 2, 0, 66, 66, 98, 98, 2, 0, 89, 89, 121, 121, 12, 0, 9, 10, 13, 13, 32, 32, 34, 34, 40, 41, 44, 44, 47, 47, 58, 58, 61, 61, 91, 91, 93, 93, 124, 124, 2, 0, 42, 42, 47, 47, 2, 0, 74, 74, 106, 106, 2182, 0, 18, 1, 0, 0, 0, 0, 20, 1, 0, 0, 0, 0, 22, 1, 0, 0, 0, 0, 24, 1, 0, 0, 0, 0, 26, 1, 0, 0, 0, 0, 28, 1, 0, 0, 0, 0, 30, 1, 0, 0, 0, 0, 32, 1, 0, 0, 0, 0, 34, 1, 0, 0, 0, 0, 36, 1, 0, 0, 0, 0, 38, 1, 0, 0, 0, 0, 40, 1, 0, 0, 0, 0, 42, 1, 0, 0, 0, 0, 44, 1, 0, 0, 0, 0, 46, 1, 0, 0, 0, 0, 48, 1, 0, 0, 0, 0, 50, 1, 0, 0, 0, 0, 52, 1, 0, 0, 0, 0, 54, 1, 0, 0, 0, 0, 56, 1, 0, 0, 0, 0, 58, 1, 0, 0, 0, 0, 60, 1, 0, 0, 0, 0, 62, 1, 0, 0, 0, 0, 64, 1, 0, 0, 0, 0, 66, 1, 0, 0, 0, 0, 68, 1, 0, 0, 0, 0, 70, 1, 0, 0, 0, 0, 72, 1, 0, 0, 0, 0, 74, 1, 0, 0, 0, 0, 76, 1, 0, 0, 0, 0, 78, 1, 0, 0, 0, 0, 80, 1, 0, 0, 0, 0, 82, 1, 0, 0, 0, 0, 84, 1, 0, 0, 0, 0, 86, 1, 0, 0, 0, 0, 88, 1, 0, 0, 0, 1, 90, 1, 0, 0, 0, 1, 92, 1, 0, 0, 0, 1, 94, 1, 0, 0, 0, 1, 96, 1, 0, 0, 0, 1, 98, 1, 0, 0, 0, 1, 100, 1, 0, 0, 0, 1, 102, 1, 0, 0, 0, 1, 104, 1, 0, 0, 0, 1, 106, 1, 0, 0, 0, 1, 108, 1, 0, 0, 0, 1, 110, 1, 0, 0, 0, 1, 112, 1, 0, 0, 0, 1, 114, 1, 0, 0, 0, 2, 116, 1, 0, 0, 0, 2, 118, 1, 0, 0, 0, 2, 120, 1, 0, 0, 0, 2, 122, 1, 0, 0, 0, 2, 126, 1, 0, 0, 0, 2, 128, 1, 0, 0, 0, 2, 130, 1, 0, 0, 0, 2, 132, 1, 0, 0, 0, 2, 134, 1, 0, 0, 0, 2, 136, 1, 0, 0, 0, 3, 138, 1, 0, 0, 0, 3, 140, 1, 0, 0, 0, 3, 142, 1, 0, 0, 0, 3, 144, 1, 0, 0, 0, 3, 146, 1, 0, 0, 0, 3, 148, 1, 0, 0, 0, 3, 150, 1, 0, 0, 0, 3, 152, 1, 0, 0, 0, 3, 154, 1, 0, 0, 0, 3, 156, 1, 0, 0, 0, 3, 158, 1, 0, 0, 0, 3, 160, 1, 0, 0, 0, 3, 162, 1, 0, 0, 0, 3, 164, 1, 0, 0, 0, 3, 166, 1, 0, 0, 0, 3, 168, 1, 0, 0, 0, 3, 170, 1, 0, 0, 0, 4, 172, 1, 0, 0, 0, 4, 174, 1, 0, 0, 0, 4, 176, 1, 0, 0, 0, 4, 178, 1, 0, 0, 0, 4, 180, 1, 0, 0, 0, 5, 182, 1, 0, 0, 0, 5, 204, 1, 0, 0, 0, 5, 206, 1, 0, 0, 0, 5, 208, 1, 0, 0, 0, 5, 210, 1, 0, 0, 0, 5, 212, 1, 0, 0, 0, 5, 214, 1, 0, 0, 0, 5, 216, 1, 0, 0, 0, 5, 218, 1, 0, 0, 0, 5, 220, 1, 0, 0, 0, 5, 222, 1, 0, 0, 0, 5, 224, 1, 0, 0, 0, 5, 226, 1, 0, 0, 0, 5, 228, 1, 0, 0, 0, 5, 230, 1, 0, 0, 0, 5, 232, 1, 0, 0, 0, 5, 234, 1, 0, 0, 0, 5, 236, 1, 0, 0, 0, 5, 238, 1, 0, 0, 0, 5, 240, 1, 0, 0, 0, 5, 242, 1, 0, 0, 0, 5, 244, 1, 0, 0, 0, 5, 246, 1, 0, 0, 0, 5, 248, 1, 0, 0, 0, 5, 250, 1, 0, 0, 0, 5, 252, 1, 0, 0, 0, 5, 254, 1, 0, 0, 0, 5, 256, 1, 0, 0, 0, 5, 258, 1, 0, 0, 0, 5, 260, 1, 0, 0, 0, 5, 262, 1, 0, 0, 0, 5, 264, 1, 0, 0, 0, 5, 266, 1, 0, 0, 0, 5, 268, 1, 0, 0, 0, 5, 270, 1, 0, 0, 0, 5, 272, 1, 0, 0, 0, 5, 274, 1, 0, 0, 0, 5, 276, 1, 0, 0, 0, 5, 278, 1, 0, 0, 0, 5, 280, 1, 0, 0, 0, 5, 282, 1, 0, 0, 0, 5, 284, 1, 0, 0, 0, 5, 286, 1, 0, 0, 0, 5, 288, 1, 0, 0, 0, 5, 290, 1, 0, 0, 0, 5, 292, 1, 0, 0, 0, 5, 294, 1, 0, 0, 0, 5, 296, 1, 0, 0, 0, 5, 298, 1, 0, 0, 0, 5, 300, 1, 0, 0, 0, 5, 302, 1, 0, 0, 0, 5, 304, 1, 0, 0, 0, 5, 308, 1, 0, 0, 0, 5, 310, 1, 0, 0, 0, 5, 312, 1, 0, 0, 0, 5, 314, 1, 0, 0, 0, 6, 316, 1, 0, 0, 0, 6, 318, 1, 0, 0, 0, 6, 320, 1, 0, 0, 0, 6, 322, 1, 0, 0, 0, 6, 324, 1, 0, 0, 0, 6, 326, 1, 0, 0, 0, 6, 328, 1, 0, 0, 0, 6, 330, 1, 0, 0, 0, 6, 334, 1, 0, 0, 0, 6, 336, 1, 0, 0, 0, 6, 338, 1, 0, 0, 0, 6, 340, 1, 0, 0, 0, 6, 342, 1, 0, 0, 0, 6, 344, 1, 0, 0, 0, 7, 346, 1, 0, 0, 0, 7, 348, 1, 0, 0, 0, 7, 350, 1, 0, 0, 0, 7, 352, 1, 0, 0, 0, 7, 354, 1, 0, 0, 0, 7, 356, 1, 0, 0, 0, 8, 358, 1, 0, 0, 0, 8, 360, 1, 0, 0, 0, 8, 362, 1, 0, 0, 0, 8, 364, 1, 0, 0, 0, 8, 366, 1, 0, 0, 0, 8, 368, 1, 0, 0, 0, 8, 370, 1, 0, 0, 0, 8, 372, 1, 0, 0, 0, 8, 374, 1, 0, 0, 0, 8, 376, 1, 0, 0, 0, 8, 378, 1, 0, 0, 0, 8, 380, 1, 0, 0, 0, 8, 382, 1, 0, 0, 0, 8, 384, 1, 0, 0, 0, 8, 386, 1, 0, 0, 0, 8, 388, 1, 0, 0, 0, 8, 390, 1, 0, 0, 0, 8, 392, 1, 0, 0, 0, 9, 394, 1, 0, 0, 0, 9, 396, 1, 0, 0, 0, 9, 398, 1, 0, 0, 0, 9, 400, 1, 0, 0, 0, 10, 402, 1, 0, 0, 0, 10, 404, 1, 0, 0, 0, 10, 406, 1, 0, 0, 0, 10, 408, 1, 0, 0, 0, 10, 410, 1, 0, 0, 0, 10, 412, 1, 0, 0, 0, 10, 414, 1, 0, 0, 0, 10, 416, 1, 0, 0, 0, 10, 418, 1, 0, 0, 0, 10, 420, 1, 0, 0, 0, 10, 422, 1, 0, 0, 0, 11, 424, 1, 0, 0, 0, 11, 426, 1, 0, 0, 0, 11, 428, 1, 0, 0, 0, 11, 430, 1, 0, 0, 0, 11, 432, 1, 0, 0, 0, 11, 434, 1, 0, 0, 0, 11, 436, 1, 0, 0, 0, 11, 438, 1, 0, 0, 0, 11, 440, 1, 0, 0, 0, 11, 442, 1, 0, 0, 0, 11, 444, 1, 0, 0, 0, 12, 446, 1, 0, 0, 0, 12, 448, 1, 0, 0, 0, 12, 450, 1, 0, 0, 0, 12, 452, 1, 0, 0, 0, 12, 454, 1, 0, 0, 0, 12, 456, 1, 0, 0, 0, 12, 458, 1, 0, 0, 0, 12, 460, 1, 0, 0, 0, 13, 462, 1, 0, 0, 0, 13, 464, 1, 0, 0, 0, 13, 466, 1, 0, 0, 0, 13, 468, 1, 0, 0, 0, 13, 470, 1, 0, 0, 0, 13, 472, 1, 0, 0, 0, 13, 474, 1, 0, 0, 0, 13, 476, 1, 0, 0, 0, 13, 478, 1, 0, 0, 0, 13, 480, 1, 0, 0, 0, 13, 482, 1, 0, 0, 0, 13, 484, 1, 0, 0, 0, 13, 486, 1, 0, 0, 0, 13, 488, 1, 0, 0, 0, 14, 490, 1, 0, 0, 0, 14, 492, 1, 0, 0, 0, 14, 494, 1, 0, 0, 0, 14, 496, 1, 0, 0, 0, 14, 498, 1, 0, 0, 0, 14, 500, 1, 0, 0, 0, 14, 502, 1, 0, 0, 0, 14, 504, 1, 0, 0, 0, 14, 506, 1, 0, 0, 0, 14, 508, 1, 0, 0, 0, 14, 514, 1, 0, 0, 0, 14, 516, 1, 0, 0, 0, 14, 518, 1, 0, 0, 0, 14, 520, 1, 0, 0, 0, 15, 522, 1, 0, 0, 0, 15, 524, 1, 0, 0, 0, 15, 526, 1, 0, 0, 0, 15, 528, 1, 0, 0, 0, 15, 530, 1, 0, 0, 0, 15, 532, 1, 0, 0, 0, 15, 534, 1, 0, 0, 0, 15, 536, 1, 0, 0, 0, 15, 538, 1, 0, 0, 0, 15, 540, 1, 0, 0, 0, 15, 542, 1, 0, 0, 0, 15, 544, 1, 0, 0, 0, 15, 546, 1, 0, 0, 0, 15, 548, 1, 0, 0, 0, 15, 550, 1, 0, 0, 0, 15, 552, 1, 0, 0, 0, 16, 554, 1, 0, 0, 0, 16, 556, 1, 0, 0, 0, 16, 558, 1, 0, 0, 0, 16, 560, 1, 0, 0, 0, 16, 562, 1, 0, 0, 0, 16, 564, 1, 0, 0, 0, 16, 566, 1, 0, 0, 0, 16, 568, 1, 0, 0, 0, 16, 570, 1, 0, 0, 0, 16, 572, 1, 0, 0, 0, 16, 574, 1, 0, 0, 0, 16, 576, 1, 0, 0, 0, 16, 578, 1, 0, 0, 0, 16, 580, 1, 0, 0, 0, 16, 582, 1, 0, 0, 0, 16, 584, 1, 0, 0, 0, 16, 586, 1, 0, 0, 0, 16, 588, 1, 0, 0, 0, 16, 590, 1, 0, 0, 0, 16, 592, 1, 0, 0, 0, 16, 594, 1, 0, 0, 0, 16, 596, 1, 0, 0, 0, 17, 598, 1, 0, 0, 0, 17, 600, 1, 0, 0, 0, 17, 602, 1, 0, 0, 0, 17, 604, 1, 0, 0, 0, 17, 606, 1, 0, 0, 0, 18, 608, 1, 0, 0, 0, 20, 625, 1, 0, 0, 0, 22, 641, 1, 0, 0, 0, 24, 647, 1, 0, 0, 0, 26, 662, 1, 0, 0, 0, 28, 671, 1, 0, 0, 0, 30, 682, 1, 0, 0, 0, 32, 695, 1, 0, 0, 0, 34, 705, 1, 0, 0, 0, 36, 712, 1, 0, 0, 0, 38, 719, 1, 0, 0, 0, 40, 727, 1, 0, 0, 0, 42, 736, 1, 0, 0, 0, 44, 742, 1, 0, 0, 0, 46, 751, 1, 0, 0, 0, 48, 758, 1, 0, 0, 0, 50, 766, 1, 0, 0, 0, 52, 774, 1, 0, 0, 0, 54, 781, 1, 0, 0, 0, 56, 786, 1, 0, 0, 0, 58, 793, 1, 0, 0, 0, 60, 800, 1, 0, 0, 0, 62, 809, 1, 0, 0, 0, 64, 823, 1, 0, 0, 0, 66, 832, 1, 0, 0, 0, 68, 840, 1, 0, 0, 0, 70, 848, 1, 0, 0, 0, 72, 857, 1, 0, 0, 0, 74, 869, 1, 0, 0, 0, 76, 881, 1, 0, 0, 0, 78, 888, 1, 0, 0, 0, 80, 895, 1, 0, 0, 0, 82, 907, 1, 0, 0, 0, 84, 916, 1, 0, 0, 0, 86, 922, 1, 0, 0, 0, 88, 930, 1, 0, 0, 0, 90, 936, 1, 0, 0, 0, 92, 941, 1, 0, 0, 0, 94, 947, 1, 0, 0, 0, 96, 951, 1, 0, 0, 0, 98, 955, 1, 0, 0, 0, 100, 959, 1, 0, 0, 0, 102, 963, 1, 0, 0, 0, 104, 967, 1, 0, 0, 0, 106, 971, 1, 0, 0, 0, 108, 975, 1, 0, 0, 0, 110, 979, 1, 0, 0, 0, 112, 983, 1, 0, 0, 0, 114, 987, 1, 0, 0, 0, 116, 991, 1, 0, 0, 0, 118, 996, 1, 0, 0, 0, 120, 1002, 1, 0, 0, 0, 122, 1007, 1, 0, 0, 0, 124, 1012, 1, 0, 0, 0, 126, 1021, 1, 0, 0, 0, 128, 1028, 1, 0, 0, 0, 130, 1032, 1, 0, 0, 0, 132, 1036, 1, 0, 0, 0, 134, 1040, 1, 0, 0, 0, 136, 1044, 1, 0, 0, 0, 138, 1048, 1, 0, 0, 0, 140, 1054, 1, 0, 0, 0, 142, 1061, 1, 0, 0, 0, 144, 1065, 1, 0, 0, 0, 146, 1069, 1, 0, 0, 0, 148, 1073, 1, 0, 0, 0, 150, 1077, 1, 0, 0, 0, 152, 1081, 1, 0, 0, 0, 154, 1085, 1, 0, 0, 0, 156, 1089, 1, 0, 0, 0, 158, 1093, 1, 0, 0, 0, 160, 1097, 1, 0, 0, 0, 162, 1101, 1, 0, 0, 0, 164, 1105, 1, 0, 0, 0, 166, 1109, 1, 0, 0, 0, 168, 1113, 1, 0, 0, 0, 170, 1117, 1, 0, 0, 0, 172, 1121, 1, 0, 0, 0, 174, 1126, 1, 0, 0, 0, 176, 1131, 1, 0, 0, 0, 178, 1135, 1, 0, 0, 0, 180, 1139, 1, 0, 0, 0, 182, 1143, 1, 0, 0, 0, 184, 1147, 1, 0, 0, 0, 186, 1149, 1, 0, 0, 0, 188, 1151, 1, 0, 0, 0, 190, 1154, 1, 0, 0, 0, 192, 1156, 1, 0, 0, 0, 194, 1165, 1, 0, 0, 0, 196, 1167, 1, 0, 0, 0, 198, 1172, 1, 0, 0, 0, 200, 1174, 1, 0, 0, 0, 202, 1179, 1, 0, 0, 0, 204, 1210, 1, 0, 0, 0, 206, 1213, 1, 0, 0, 0, 208, 1259, 1, 0, 0, 0, 210, 1261, 1, 0, 0, 0, 212, 1265, 1, 0, 0, 0, 214, 1269, 1, 0, 0, 0, 216, 1271, 1, 0, 0, 0, 218, 1274, 1, 0, 0, 0, 220, 1277, 1, 0, 0, 0, 222, 1279, 1, 0, 0, 0, 224, 1281, 1, 0, 0, 0, 226, 1283, 1, 0, 0, 0, 228, 1288, 1, 0, 0, 0, 230, 1290, 1, 0, 0, 0, 232, 1296, 1, 0, 0, 0, 234, 1302, 1, 0, 0, 0, 236, 1305, 1, 0, 0, 0, 238, 1308, 1, 0, 0, 0, 240, 1313, 1, 0, 0, 0, 242, 1318, 1, 0, 0, 0, 244, 1322, 1, 0, 0, 0, 246, 1327, 1, 0, 0, 0, 248, 1333, 1, 0, 0, 0, 250, 1336, 1, 0, 0, 0, 252, 1339, 1, 0, 0, 0, 254, 1341, 1, 0, 0, 0, 256, 1347, 1, 0, 0, 0, 258, 1352, 1, 0, 0, 0, 260, 1357, 1, 0, 0, 0, 262, 1360, 1, 0, 0, 0, 264, 1363, 1, 0, 0, 0, 266, 1366, 1, 0, 0, 0, 268, 1368, 1, 0, 0, 0, 270, 1371, 1, 0, 0, 0, 272, 1373, 1, 0, 0, 0, 274, 1376, 1, 0, 0, 0, 276, 1378, 1, 0, 0, 0, 278, 1380, 1, 0, 0, 0, 280, 1382, 1, 0, 0, 0, 282, 1384, 1, 0, 0, 0, 284, 1386, 1, 0, 0, 0, 286, 1388, 1, 0, 0, 0, 288, 1390, 1, 0, 0, 0, 290, 1393, 1, 0, 0, 0, 292, 1414, 1, 0, 0, 0, 294, 1433, 1, 0, 0, 0, 296, 1435, 1, 0, 0, 0, 298, 1440, 1, 0, 0, 0, 300, 1445, 1, 0, 0, 0, 302, 1450, 1, 0, 0, 0, 304, 1471, 1, 0, 0, 0, 306, 1473, 1, 0, 0, 0, 308, 1481, 1, 0, 0, 0, 310, 1483, 1, 0, 0, 0, 312, 1487, 1, 0, 0, 0, 314, 1491, 1, 0, 0, 0, 316, 1495, 1, 0, 0, 0, 318, 1500, 1, 0, 0, 0, 320, 1504, 1, 0, 0, 0, 322, 1508, 1, 0, 0, 0, 324, 1512, 1, 0, 0, 0, 326, 1516, 1, 0, 0, 0, 328, 1525, 1, 0, 0, 0, 330, 1531, 1, 0, 0, 0, 332, 1539, 1, 0, 0, 0, 334, 1542, 1, 0, 0, 0, 336, 1546, 1, 0, 0, 0, 338, 1550, 1, 0, 0, 0, 340, 1554, 1, 0, 0, 0, 342, 1558, 1, 0, 0, 0, 344, 1562, 1, 0, 0, 0, 346, 1566, 1, 0, 0, 0, 348, 1571, 1, 0, 0, 0, 350, 1577, 1, 0, 0, 0, 352, 1582, 1, 0, 0, 0, 354, 1586, 1, 0, 0, 0, 356, 1590, 1, 0, 0, 0, 358, 1594, 1, 0, 0, 0, 360, 1599, 1, 0, 0, 0, 362, 1605, 1, 0, 0, 0, 364, 1611, 1, 0, 0, 0, 366, 1617, 1, 0, 0, 0, 368, 1621, 1, 0, 0, 0, 370, 1627, 1, 0, 0, 0, 372, 1631, 1, 0, 0, 0, 374, 1635, 1, 0, 0, 0, 376, 1639, 1, 0, 0, 0, 378, 1643, 1, 0, 0, 0, 380, 1647, 1, 0, 0, 0, 382, 1651, 1, 0, 0, 0, 384, 1655, 1, 0, 0, 0, 386, 1659, 1, 0, 0, 0, 388, 1663, 1, 0, 0, 0, 390, 1667, 1, 0, 0, 0, 392, 1671, 1, 0, 0, 0, 394, 1675, 1, 0, 0, 0, 396, 1684, 1, 0, 0, 0, 398, 1688, 1, 0, 0, 0, 400, 1692, 1, 0, 0, 0, 402, 1696, 1, 0, 0, 0, 404, 1701, 1, 0, 0, 0, 406, 1706, 1, 0, 0, 0, 408, 1710, 1, 0, 0, 0, 410, 1716, 1, 0, 0, 0, 412, 1725, 1, 0, 0, 0, 414, 1729, 1, 0, 0, 0, 416, 1733, 1, 0, 0, 0, 418, 1737, 1, 0, 0, 0, 420, 1741, 1, 0, 0, 0, 422, 1745, 1, 0, 0, 0, 424, 1749, 1, 0, 0, 0, 426, 1754, 1, 0, 0, 0, 428, 1760, 1, 0, 0, 0, 430, 1764, 1, 0, 0, 0, 432, 1768, 1, 0, 0, 0, 434, 1772, 1, 0, 0, 0, 436, 1777, 1, 0, 0, 0, 438, 1781, 1, 0, 0, 0, 440, 1785, 1, 0, 0, 0, 442, 1789, 1, 0, 0, 0, 444, 1793, 1, 0, 0, 0, 446, 1797, 1, 0, 0, 0, 448, 1803, 1, 0, 0, 0, 450, 1810, 1, 0, 0, 0, 452, 1814, 1, 0, 0, 0, 454, 1818, 1, 0, 0, 0, 456, 1822, 1, 0, 0, 0, 458, 1826, 1, 0, 0, 0, 460, 1830, 1, 0, 0, 0, 462, 1834, 1, 0, 0, 0, 464, 1839, 1, 0, 0, 0, 466, 1845, 1, 0, 0, 0, 468, 1849, 1, 0, 0, 0, 470, 1853, 1, 0, 0, 0, 472, 1857, 1, 0, 0, 0, 474, 1861, 1, 0, 0, 0, 476, 1865, 1, 0, 0, 0, 478, 1869, 1, 0, 0, 0, 480, 1873, 1, 0, 0, 0, 482, 1877, 1, 0, 0, 0, 484, 1881, 1, 0, 0, 0, 486, 1885, 1, 0, 0, 0, 488, 1889, 1, 0, 0, 0, 490, 1893, 1, 0, 0, 0, 492, 1898, 1, 0, 0, 0, 494, 1904, 1, 0, 0, 0, 496, 1908, 1, 0, 0, 0, 498, 1912, 1, 0, 0, 0, 500, 1916, 1, 0, 0, 0, 502, 1920, 1, 0, 0, 0, 504, 1924, 1, 0, 0, 0, 506, 1928, 1, 0, 0, 0, 508, 1932, 1, 0, 0, 0, 510, 1940, 1, 0, 0, 0, 512, 1961, 1, 0, 0, 0, 514, 1965, 1, 0, 0, 0, 516, 1969, 1, 0, 0, 0, 518, 1973, 1, 0, 0, 0, 520, 1977, 1, 0, 0, 0, 522, 1981, 1, 0, 0, 0, 524, 1986, 1, 0, 0, 0, 526, 1992, 1, 0, 0, 0, 528, 1996, 1, 0, 0, 0, 530, 2000, 1, 0, 0, 0, 532, 2004, 1, 0, 0, 0, 534, 2008, 1, 0, 0, 0, 536, 2012, 1, 0, 0, 0, 538, 2016, 1, 0, 0, 0, 540, 2020, 1, 0, 0, 0, 542, 2024, 1, 0, 0, 0, 544, 2028, 1, 0, 0, 0, 546, 2031, 1, 0, 0, 0, 548, 2035, 1, 0, 0, 0, 550, 2039, 1, 0, 0, 0, 552, 2043, 1, 0, 0, 0, 554, 2047, 1, 0, 0, 0, 556, 2051, 1, 0, 0, 0, 558, 2055, 1, 0, 0, 0, 560, 2059, 1, 0, 0, 0, 562, 2064, 1, 0, 0, 0, 564, 2068, 1, 0, 0, 0, 566, 2072, 1, 0, 0, 0, 568, 2076, 1, 0, 0, 0, 570, 2080, 1, 0, 0, 0, 572, 2084, 1, 0, 0, 0, 574, 2088, 1, 0, 0, 0, 576, 2092, 1, 0, 0, 0, 578, 2096, 1, 0, 0, 0, 580, 2100, 1, 0, 0, 0, 582, 2104, 1, 0, 0, 0, 584, 2108, 1, 0, 0, 0, 586, 2112, 1, 0, 0, 0, 588, 2116, 1, 0, 0, 0, 590, 2120, 1, 0, 0, 0, 592, 2124, 1, 0, 0, 0, 594, 2128, 1, 0, 0, 0, 596, 2132, 1, 0, 0, 0, 598, 2136, 1, 0, 0, 0, 600, 2141, 1, 0, 0, 0, 602, 2146, 1, 0, 0, 0, 604, 2150, 1, 0, 0, 0, 606, 2154, 1, 0, 0, 0, 608, 609, 5, 47, 0, 0, 609, 610, 5, 47, 0, 0, 610, 614, 1, 0, 0, 0, 611, 613, 8, 0, 0, 0, 612, 611, 1, 0, 0, 0, 613, 616, 1, 0, 0, 0, 614, 612, 1, 0, 0, 0, 614, 615, 1, 0, 0, 0, 615, 618, 1, 0, 0, 0, 616, 614, 1, 0, 0, 0, 617, 619, 5, 13, 0, 0, 618, 617, 1, 0, 0, 0, 618, 619, 1, 0, 0, 0, 619, 621, 1, 0, 0, 0, 620, 622, 5, 10, 0, 0, 621, 620, 1, 0, 0, 0, 621, 622, 1, 0, 0, 0, 622, 623, 1, 0, 0, 0, 623, 624, 6, 0, 0, 0, 624, 19, 1, 0, 0, 0, 625, 626, 5, 47, 0, 0, 626, 627, 5, 42, 0, 0, 627, 632, 1, 0, 0, 0, 628, 631, 3, 20, 1, 0, 629, 631, 9, 0, 0, 0, 630, 628, 1, 0, 0, 0, 630, 629, 1, 0, 0, 0, 631, 634, 1, 0, 0, 0, 632, 633, 1, 0, 0, 0, 632, 630, 1, 0, 0, 0, 633, 635, 1, 0, 0, 0, 634, 632, 1, 0, 0, 0, 635, 636, 5, 42, 0, 0, 636, 637, 5, 47, 0, 0, 637, 638, 1, 0, 0, 0, 638, 639, 6, 1, 0, 0, 639, 21, 1, 0, 0, 0, 640, 642, 7, 1, 0, 0, 641, 640, 1, 0, 0, 0, 642, 643, 1, 0, 0, 0, 643, 641, 1, 0, 0, 0, 643, 644, 1, 0, 0, 0, 644, 645, 1, 0, 0, 0, 645, 646, 6, 2, 0, 0, 646, 23, 1, 0, 0, 0, 647, 648, 7, 2, 0, 0, 648, 649, 7, 3, 0, 0, 649, 650, 7, 4, 0, 0, 650, 651, 7, 5, 0, 0, 651, 652, 7, 6, 0, 0, 652, 653, 7, 7, 0, 0, 653, 654, 5, 95, 0, 0, 654, 655, 7, 8, 0, 0, 655, 656, 7, 9, 0, 0, 656, 657, 7, 10, 0, 0, 657, 658, 7, 5, 0, 0, 658, 659, 7, 11, 0, 0, 659, 660, 1, 0, 0, 0, 660, 661, 6, 3, 1, 0, 661, 25, 1, 0, 0, 0, 662, 663, 7, 7, 0, 0, 663, 664, 7, 5, 0, 0, 664, 665, 7, 12, 0, 0, 665, 666, 7, 10, 0, 0, 666, 667, 7, 2, 0, 0, 667, 668, 7, 3, 0, 0, 668, 669, 1, 0, 0, 0, 669, 670, 6, 4, 2, 0, 670, 27, 1, 0, 0, 0, 671, 672, 4, 5, 0, 0, 672, 673, 7, 7, 0, 0, 673, 674, 7, 13, 0, 0, 674, 675, 7, 8, 0, 0, 675, 676, 7, 14, 0, 0, 676, 677, 7, 4, 0, 0, 677, 678, 7, 10, 0, 0, 678, 679, 7, 5, 0, 0, 679, 680, 1, 0, 0, 0, 680, 681, 6, 5, 3, 0, 681, 29, 1, 0, 0, 0, 682, 683, 7, 2, 0, 0, 683, 684, 7, 9, 0, 0, 684, 685, 7, 15, 0, 0, 685, 686, 7, 8, 0, 0, 686, 687, 7, 14, 0, 0, 687, 688, 7, 7, 0, 0, 688, 689, 7, 11, 0, 0, 689, 690, 7, 10, 0, 0, 690, 691, 7, 9, 0, 0, 691, 692, 7, 5, 0, 0, 692, 693, 1, 0, 0, 0, 693, 694, 6, 6, 4, 0, 694, 31, 1, 0, 0, 0, 695, 696, 7, 16, 0, 0, 696, 697, 7, 10, 0, 0, 697, 698, 7, 17, 0, 0, 698, 699, 7, 17, 0, 0, 699, 700, 7, 7, 0, 0, 700, 701, 7, 2, 0, 0, 701, 702, 7, 11, 0, 0, 702, 703, 1, 0, 0, 0, 703, 704, 6, 7, 4, 0, 704, 33, 1, 0, 0, 0, 705, 706, 7, 7, 0, 0, 706, 707, 7, 18, 0, 0, 707, 708, 7, 4, 0, 0, 708, 709, 7, 14, 0, 0, 709, 710, 1, 0, 0, 0, 710, 711, 6, 8, 4, 0, 711, 35, 1, 0, 0, 0, 712, 713, 7, 6, 0, 0, 713, 714, 7, 12, 0, 0, 714, 715, 7, 9, 0, 0, 715, 716, 7, 19, 0, 0, 716, 717, 1, 0, 0, 0, 717, 718, 6, 9, 4, 0, 718, 37, 1, 0, 0, 0, 719, 720, 7, 14, 0, 0, 720, 721, 7, 10, 0, 0, 721, 722, 7, 15, 0, 0, 722, 723, 7, 10, 0, 0, 723, 724, 7, 11, 0, 0, 724, 725, 1, 0, 0, 0, 725, 726, 6, 10, 4, 0, 726, 39, 1, 0, 0, 0, 727, 728, 7, 12, 0, 0, 728, 729, 7, 7, 0, 0, 729, 730, 7, 12, 0, 0, 730, 731, 7, 4, 0, 0, 731, 732, 7, 5, 0, 0, 732, 733, 7, 19, 0, 0, 733, 734, 1, 0, 0, 0, 734, 735, 6, 11, 4, 0, 735, 41, 1, 0, 0, 0, 736, 737, 7, 12, 0, 0, 737, 738, 7, 9, 0, 0, 738, 739, 7, 20, 0, 0, 739, 740, 1, 0, 0, 0, 740, 741, 6, 12, 4, 0, 741, 43, 1, 0, 0, 0, 742, 743, 7, 17, 0, 0, 743, 744, 7, 4, 0, 0, 744, 745, 7, 15, 0, 0, 745, 746, 7, 8, 0, 0, 746, 747, 7, 14, 0, 0, 747, 748, 7, 7, 0, 0, 748, 749, 1, 0, 0, 0, 749, 750, 6, 13, 4, 0, 750, 45, 1, 0, 0, 0, 751, 752, 7, 17, 0, 0, 752, 753, 7, 9, 0, 0, 753, 754, 7, 12, 0, 0, 754, 755, 7, 11, 0, 0, 755, 756, 1, 0, 0, 0, 756, 757, 6, 14, 4, 0, 757, 47, 1, 0, 0, 0, 758, 759, 7, 17, 0, 0, 759, 760, 7, 11, 0, 0, 760, 761, 7, 4, 0, 0, 761, 762, 7, 11, 0, 0, 762, 763, 7, 17, 0, 0, 763, 764, 1, 0, 0, 0, 764, 765, 6, 15, 4, 0, 765, 49, 1, 0, 0, 0, 766, 767, 7, 20, 0, 0, 767, 768, 7, 3, 0, 0, 768, 769, 7, 7, 0, 0, 769, 770, 7, 12, 0, 0, 770, 771, 7, 7, 0, 0, 771, 772, 1, 0, 0, 0, 772, 773, 6, 16, 4, 0, 773, 51, 1, 0, 0, 0, 774, 775, 7, 21, 0, 0, 775, 776, 7, 12, 0, 0, 776, 777, 7, 9, 0, 0, 777, 778, 7, 15, 0, 0, 778, 779, 1, 0, 0, 0, 779, 780, 6, 17, 5, 0, 780, 53, 1, 0, 0, 0, 781, 782, 7, 11, 0, 0, 782, 783, 7, 17, 0, 0, 783, 784, 1, 0, 0, 0, 784, 785, 6, 18, 5, 0, 785, 55, 1, 0, 0, 0, 786, 787, 7, 21, 0, 0, 787, 788, 7, 9, 0, 0, 788, 789, 7, 12, 0, 0, 789, 790, 7, 19, 0, 0, 790, 791, 1, 0, 0, 0, 791, 792, 6, 19, 6, 0, 792, 57, 1, 0, 0, 0, 793, 794, 7, 21, 0, 0, 794, 795, 7, 22, 0, 0, 795, 796, 7, 17, 0, 0, 796, 797, 7, 7, 0, 0, 797, 798, 1, 0, 0, 0, 798, 799, 6, 20, 7, 0, 799, 59, 1, 0, 0, 0, 800, 801, 7, 10, 0, 0, 801, 802, 7, 5, 0, 0, 802, 803, 7, 14, 0, 0, 803, 804, 7, 10, 0, 0, 804, 805, 7, 5, 0, 0, 805, 806, 7, 7, 0, 0, 806, 807, 1, 0, 0, 0, 807, 808, 6, 21, 8, 0, 808, 61, 1, 0, 0, 0, 809, 810, 7, 10, 0, 0, 810, 811, 7, 5, 0, 0, 811, 812, 7, 14, 0, 0, 812, 813, 7, 10, 0, 0, 813, 814, 7, 5, 0, 0, 814, 815, 7, 7, 0, 0, 815, 816, 7, 17, 0, 0, 816, 817, 7, 11, 0, 0, 817, 818, 7, 4, 0, 0, 818, 819, 7, 11, 0, 0, 819, 820, 7, 17, 0, 0, 820, 821, 1, 0, 0, 0, 821, 822, 6, 22, 4, 0, 822, 63, 1, 0, 0, 0, 823, 824, 7, 14, 0, 0, 824, 825, 7, 9, 0, 0, 825, 826, 7, 9, 0, 0, 826, 827, 7, 19, 0, 0, 827, 828, 7, 22, 0, 0, 828, 829, 7, 8, 0, 0, 829, 830, 1, 0, 0, 0, 830, 831, 6, 23, 9, 0, 831, 65, 1, 0, 0, 0, 832, 833, 4, 24, 1, 0, 833, 834, 7, 21, 0, 0, 834, 835, 7, 22, 0, 0, 835, 836, 7, 14, 0, 0, 836, 837, 7, 14, 0, 0, 837, 838, 1, 0, 0, 0, 838, 839, 6, 24, 9, 0, 839, 67, 1, 0, 0, 0, 840, 841, 4, 25, 2, 0, 841, 842, 7, 14, 0, 0, 842, 843, 7, 7, 0, 0, 843, 844, 7, 21, 0, 0, 844, 845, 7, 11, 0, 0, 845, 846, 1, 0, 0, 0, 846, 847, 6, 25, 9, 0, 847, 69, 1, 0, 0, 0, 848, 849, 4, 26, 3, 0, 849, 850, 7, 12, 0, 0, 850, 851, 7, 10, 0, 0, 851, 852, 7, 6, 0, 0, 852, 853, 7, 3, 0, 0, 853, 854, 7, 11, 0, 0, 854, 855, 1, 0, 0, 0, 855, 856, 6, 26, 9, 0, 856, 71, 1, 0, 0, 0, 857, 858, 4, 27, 4, 0, 858, 859, 7, 14, 0, 0, 859, 860, 7, 9, 0, 0, 860, 861, 7, 9, 0, 0, 861, 862, 7, 19, 0, 0, 862, 863, 7, 22, 0, 0, 863, 864, 7, 8, 0, 0, 864, 865, 5, 95, 0, 0, 865, 866, 5, 128020, 0, 0, 866, 867, 1, 0, 0, 0, 867, 868, 6, 27, 10, 0, 868, 73, 1, 0, 0, 0, 869, 870, 7, 15, 0, 0, 870, 871, 7, 18, 0, 0, 871, 872, 5, 95, 0, 0, 872, 873, 7, 7, 0, 0, 873, 874, 7, 13, 0, 0, 874, 875, 7, 8, 0, 0, 875, 876, 7, 4, 0, 0, 876, 877, 7, 5, 0, 0, 877, 878, 7, 16, 0, 0, 878, 879, 1, 0, 0, 0, 879, 880, 6, 28, 11, 0, 880, 75, 1, 0, 0, 0, 881, 882, 7, 16, 0, 0, 882, 883, 7, 12, 0, 0, 883, 884, 7, 9, 0, 0, 884, 885, 7, 8, 0, 0, 885, 886, 1, 0, 0, 0, 886, 887, 6, 29, 12, 0, 887, 77, 1, 0, 0, 0, 888, 889, 7, 19, 0, 0, 889, 890, 7, 7, 0, 0, 890, 891, 7, 7, 0, 0, 891, 892, 7, 8, 0, 0, 892, 893, 1, 0, 0, 0, 893, 894, 6, 30, 12, 0, 894, 79, 1, 0, 0, 0, 895, 896, 4, 31, 5, 0, 896, 897, 7, 10, 0, 0, 897, 898, 7, 5, 0, 0, 898, 899, 7, 17, 0, 0, 899, 900, 7, 10, 0, 0, 900, 901, 7, 17, 0, 0, 901, 902, 7, 11, 0, 0, 902, 903, 5, 95, 0, 0, 903, 904, 5, 128020, 0, 0, 904, 905, 1, 0, 0, 0, 905, 906, 6, 31, 12, 0, 906, 81, 1, 0, 0, 0, 907, 908, 7, 12, 0, 0, 908, 909, 7, 7, 0, 0, 909, 910, 7, 5, 0, 0, 910, 911, 7, 4, 0, 0, 911, 912, 7, 15, 0, 0, 912, 913, 7, 7, 0, 0, 913, 914, 1, 0, 0, 0, 914, 915, 6, 32, 13, 0, 915, 83, 1, 0, 0, 0, 916, 917, 7, 17, 0, 0, 917, 918, 7, 7, 0, 0, 918, 919, 7, 11, 0, 0, 919, 920, 1, 0, 0, 0, 920, 921, 6, 33, 14, 0, 921, 85, 1, 0, 0, 0, 922, 923, 7, 17, 0, 0, 923, 924, 7, 3, 0, 0, 924, 925, 7, 9, 0, 0, 925, 926, 7, 20, 0, 0, 926, 927, 1, 0, 0, 0, 927, 928, 6, 34, 15, 0, 928, 87, 1, 0, 0, 0, 929, 931, 8, 23, 0, 0, 930, 929, 1, 0, 0, 0, 931, 932, 1, 0, 0, 0, 932, 930, 1, 0, 0, 0, 932, 933, 1, 0, 0, 0, 933, 934, 1, 0, 0, 0, 934, 935, 6, 35, 4, 0, 935, 89, 1, 0, 0, 0, 936, 937, 3, 182, 82, 0, 937, 938, 1, 0, 0, 0, 938, 939, 6, 36, 16, 0, 939, 940, 6, 36, 17, 0, 940, 91, 1, 0, 0, 0, 941, 942, 3, 302, 142, 0, 942, 943, 1, 0, 0, 0, 943, 944, 6, 37, 18, 0, 944, 945, 6, 37, 17, 0, 945, 946, 6, 37, 17, 0, 946, 93, 1, 0, 0, 0, 947, 948, 3, 248, 115, 0, 948, 949, 1, 0, 0, 0, 949, 950, 6, 38, 19, 0, 950, 95, 1, 0, 0, 0, 951, 952, 3, 544, 263, 0, 952, 953, 1, 0, 0, 0, 953, 954, 6, 39, 20, 0, 954, 97, 1, 0, 0, 0, 955, 956, 3, 228, 105, 0, 956, 957, 1, 0, 0, 0, 957, 958, 6, 40, 21, 0, 958, 99, 1, 0, 0, 0, 959, 960, 3, 224, 103, 0, 960, 961, 1, 0, 0, 0, 961, 962, 6, 41, 22, 0, 962, 101, 1, 0, 0, 0, 963, 964, 3, 296, 139, 0, 964, 965, 1, 0, 0, 0, 965, 966, 6, 42, 23, 0, 966, 103, 1, 0, 0, 0, 967, 968, 3, 298, 140, 0, 968, 969, 1, 0, 0, 0, 969, 970, 6, 43, 24, 0, 970, 105, 1, 0, 0, 0, 971, 972, 3, 308, 145, 0, 972, 973, 1, 0, 0, 0, 973, 974, 6, 44, 25, 0, 974, 107, 1, 0, 0, 0, 975, 976, 3, 304, 143, 0, 976, 977, 1, 0, 0, 0, 977, 978, 6, 45, 26, 0, 978, 109, 1, 0, 0, 0, 979, 980, 3, 18, 0, 0, 980, 981, 1, 0, 0, 0, 981, 982, 6, 46, 0, 0, 982, 111, 1, 0, 0, 0, 983, 984, 3, 20, 1, 0, 984, 985, 1, 0, 0, 0, 985, 986, 6, 47, 0, 0, 986, 113, 1, 0, 0, 0, 987, 988, 3, 22, 2, 0, 988, 989, 1, 0, 0, 0, 989, 990, 6, 48, 0, 0, 990, 115, 1, 0, 0, 0, 991, 992, 3, 182, 82, 0, 992, 993, 1, 0, 0, 0, 993, 994, 6, 49, 16, 0, 994, 995, 6, 49, 17, 0, 995, 117, 1, 0, 0, 0, 996, 997, 3, 302, 142, 0, 997, 998, 1, 0, 0, 0, 998, 999, 6, 50, 18, 0, 999, 1000, 6, 50, 17, 0, 1000, 1001, 6, 50, 17, 0, 1001, 119, 1, 0, 0, 0, 1002, 1003, 3, 248, 115, 0, 1003, 1004, 1, 0, 0, 0, 1004, 1005, 6, 51, 19, 0, 1005, 1006, 6, 51, 27, 0, 1006, 121, 1, 0, 0, 0, 1007, 1008, 3, 258, 120, 0, 1008, 1009, 1, 0, 0, 0, 1009, 1010, 6, 52, 28, 0, 1010, 1011, 6, 52, 27, 0, 1011, 123, 1, 0, 0, 0, 1012, 1013, 8, 24, 0, 0, 1013, 125, 1, 0, 0, 0, 1014, 1016, 3, 124, 53, 0, 1015, 1014, 1, 0, 0, 0, 1016, 1017, 1, 0, 0, 0, 1017, 1015, 1, 0, 0, 0, 1017, 1018, 1, 0, 0, 0, 1018, 1019, 1, 0, 0, 0, 1019, 1020, 3, 220, 101, 0, 1020, 1022, 1, 0, 0, 0, 1021, 1015, 1, 0, 0, 0, 1021, 1022, 1, 0, 0, 0, 1022, 1024, 1, 0, 0, 0, 1023, 1025, 3, 124, 53, 0, 1024, 1023, 1, 0, 0, 0, 1025, 1026, 1, 0, 0, 0, 1026, 1024, 1, 0, 0, 0, 1026, 1027, 1, 0, 0, 0, 1027, 127, 1, 0, 0, 0, 1028, 1029, 3, 126, 54, 0, 1029, 1030, 1, 0, 0, 0, 1030, 1031, 6, 55, 29, 0, 1031, 129, 1, 0, 0, 0, 1032, 1033, 3, 204, 93, 0, 1033, 1034, 1, 0, 0, 0, 1034, 1035, 6, 56, 30, 0, 1035, 131, 1, 0, 0, 0, 1036, 1037, 3, 18, 0, 0, 1037, 1038, 1, 0, 0, 0, 1038, 1039, 6, 57, 0, 0, 1039, 133, 1, 0, 0, 0, 1040, 1041, 3, 20, 1, 0, 1041, 1042, 1, 0, 0, 0, 1042, 1043, 6, 58, 0, 0, 1043, 135, 1, 0, 0, 0, 1044, 1045, 3, 22, 2, 0, 1045, 1046, 1, 0, 0, 0, 1046, 1047, 6, 59, 0, 0, 1047, 137, 1, 0, 0, 0, 1048, 1049, 3, 182, 82, 0, 1049, 1050, 1, 0, 0, 0, 1050, 1051, 6, 60, 16, 0, 1051, 1052, 6, 60, 17, 0, 1052, 1053, 6, 60, 17, 0, 1053, 139, 1, 0, 0, 0, 1054, 1055, 3, 302, 142, 0, 1055, 1056, 1, 0, 0, 0, 1056, 1057, 6, 61, 18, 0, 1057, 1058, 6, 61, 17, 0, 1058, 1059, 6, 61, 17, 0, 1059, 1060, 6, 61, 17, 0, 1060, 141, 1, 0, 0, 0, 1061, 1062, 3, 296, 139, 0, 1062, 1063, 1, 0, 0, 0, 1063, 1064, 6, 62, 23, 0, 1064, 143, 1, 0, 0, 0, 1065, 1066, 3, 298, 140, 0, 1066, 1067, 1, 0, 0, 0, 1067, 1068, 6, 63, 24, 0, 1068, 145, 1, 0, 0, 0, 1069, 1070, 3, 214, 98, 0, 1070, 1071, 1, 0, 0, 0, 1071, 1072, 6, 64, 31, 0, 1072, 147, 1, 0, 0, 0, 1073, 1074, 3, 224, 103, 0, 1074, 1075, 1, 0, 0, 0, 1075, 1076, 6, 65, 22, 0, 1076, 149, 1, 0, 0, 0, 1077, 1078, 3, 228, 105, 0, 1078, 1079, 1, 0, 0, 0, 1079, 1080, 6, 66, 21, 0, 1080, 151, 1, 0, 0, 0, 1081, 1082, 3, 258, 120, 0, 1082, 1083, 1, 0, 0, 0, 1083, 1084, 6, 67, 28, 0, 1084, 153, 1, 0, 0, 0, 1085, 1086, 3, 514, 248, 0, 1086, 1087, 1, 0, 0, 0, 1087, 1088, 6, 68, 32, 0, 1088, 155, 1, 0, 0, 0, 1089, 1090, 3, 308, 145, 0, 1090, 1091, 1, 0, 0, 0, 1091, 1092, 6, 69, 25, 0, 1092, 157, 1, 0, 0, 0, 1093, 1094, 3, 252, 117, 0, 1094, 1095, 1, 0, 0, 0, 1095, 1096, 6, 70, 33, 0, 1096, 159, 1, 0, 0, 0, 1097, 1098, 3, 292, 137, 0, 1098, 1099, 1, 0, 0, 0, 1099, 1100, 6, 71, 34, 0, 1100, 161, 1, 0, 0, 0, 1101, 1102, 3, 288, 135, 0, 1102, 1103, 1, 0, 0, 0, 1103, 1104, 6, 72, 35, 0, 1104, 163, 1, 0, 0, 0, 1105, 1106, 3, 294, 138, 0, 1106, 1107, 1, 0, 0, 0, 1107, 1108, 6, 73, 36, 0, 1108, 165, 1, 0, 0, 0, 1109, 1110, 3, 18, 0, 0, 1110, 1111, 1, 0, 0, 0, 1111, 1112, 6, 74, 0, 0, 1112, 167, 1, 0, 0, 0, 1113, 1114, 3, 20, 1, 0, 1114, 1115, 1, 0, 0, 0, 1115, 1116, 6, 75, 0, 0, 1116, 169, 1, 0, 0, 0, 1117, 1118, 3, 22, 2, 0, 1118, 1119, 1, 0, 0, 0, 1119, 1120, 6, 76, 0, 0, 1120, 171, 1, 0, 0, 0, 1121, 1122, 3, 300, 141, 0, 1122, 1123, 1, 0, 0, 0, 1123, 1124, 6, 77, 37, 0, 1124, 1125, 6, 77, 38, 0, 1125, 173, 1, 0, 0, 0, 1126, 1127, 3, 182, 82, 0, 1127, 1128, 1, 0, 0, 0, 1128, 1129, 6, 78, 16, 0, 1129, 1130, 6, 78, 17, 0, 1130, 175, 1, 0, 0, 0, 1131, 1132, 3, 22, 2, 0, 1132, 1133, 1, 0, 0, 0, 1133, 1134, 6, 79, 0, 0, 1134, 177, 1, 0, 0, 0, 1135, 1136, 3, 18, 0, 0, 1136, 1137, 1, 0, 0, 0, 1137, 1138, 6, 80, 0, 0, 1138, 179, 1, 0, 0, 0, 1139, 1140, 3, 20, 1, 0, 1140, 1141, 1, 0, 0, 0, 1141, 1142, 6, 81, 0, 0, 1142, 181, 1, 0, 0, 0, 1143, 1144, 5, 124, 0, 0, 1144, 1145, 1, 0, 0, 0, 1145, 1146, 6, 82, 17, 0, 1146, 183, 1, 0, 0, 0, 1147, 1148, 7, 25, 0, 0, 1148, 185, 1, 0, 0, 0, 1149, 1150, 7, 26, 0, 0, 1150, 187, 1, 0, 0, 0, 1151, 1152, 5, 92, 0, 0, 1152, 1153, 7, 27, 0, 0, 1153, 189, 1, 0, 0, 0, 1154, 1155, 8, 28, 0, 0, 1155, 191, 1, 0, 0, 0, 1156, 1158, 7, 7, 0, 0, 1157, 1159, 7, 29, 0, 0, 1158, 1157, 1, 0, 0, 0, 1158, 1159, 1, 0, 0, 0, 1159, 1161, 1, 0, 0, 0, 1160, 1162, 3, 184, 83, 0, 1161, 1160, 1, 0, 0, 0, 1162, 1163, 1, 0, 0, 0, 1163, 1161, 1, 0, 0, 0, 1163, 1164, 1, 0, 0, 0, 1164, 193, 1, 0, 0, 0, 1165, 1166, 5, 64, 0, 0, 1166, 195, 1, 0, 0, 0, 1167, 1168, 5, 96, 0, 0, 1168, 197, 1, 0, 0, 0, 1169, 1173, 8, 30, 0, 0, 1170, 1171, 5, 96, 0, 0, 1171, 1173, 5, 96, 0, 0, 1172, 1169, 1, 0, 0, 0, 1172, 1170, 1, 0, 0, 0, 1173, 199, 1, 0, 0, 0, 1174, 1175, 5, 95, 0, 0, 1175, 201, 1, 0, 0, 0, 1176, 1180, 3, 186, 84, 0, 1177, 1180, 3, 184, 83, 0, 1178, 1180, 3, 200, 91, 0, 1179, 1176, 1, 0, 0, 0, 1179, 1177, 1, 0, 0, 0, 1179, 1178, 1, 0, 0, 0, 1180, 203, 1, 0, 0, 0, 1181, 1186, 5, 34, 0, 0, 1182, 1185, 3, 188, 85, 0, 1183, 1185, 3, 190, 86, 0, 1184, 1182, 1, 0, 0, 0, 1184, 1183, 1, 0, 0, 0, 1185, 1188, 1, 0, 0, 0, 1186, 1184, 1, 0, 0, 0, 1186, 1187, 1, 0, 0, 0, 1187, 1189, 1, 0, 0, 0, 1188, 1186, 1, 0, 0, 0, 1189, 1211, 5, 34, 0, 0, 1190, 1191, 5, 34, 0, 0, 1191, 1192, 5, 34, 0, 0, 1192, 1193, 5, 34, 0, 0, 1193, 1197, 1, 0, 0, 0, 1194, 1196, 8, 0, 0, 0, 1195, 1194, 1, 0, 0, 0, 1196, 1199, 1, 0, 0, 0, 1197, 1198, 1, 0, 0, 0, 1197, 1195, 1, 0, 0, 0, 1198, 1200, 1, 0, 0, 0, 1199, 1197, 1, 0, 0, 0, 1200, 1201, 5, 34, 0, 0, 1201, 1202, 5, 34, 0, 0, 1202, 1203, 5, 34, 0, 0, 1203, 1205, 1, 0, 0, 0, 1204, 1206, 5, 34, 0, 0, 1205, 1204, 1, 0, 0, 0, 1205, 1206, 1, 0, 0, 0, 1206, 1208, 1, 0, 0, 0, 1207, 1209, 5, 34, 0, 0, 1208, 1207, 1, 0, 0, 0, 1208, 1209, 1, 0, 0, 0, 1209, 1211, 1, 0, 0, 0, 1210, 1181, 1, 0, 0, 0, 1210, 1190, 1, 0, 0, 0, 1211, 205, 1, 0, 0, 0, 1212, 1214, 3, 184, 83, 0, 1213, 1212, 1, 0, 0, 0, 1214, 1215, 1, 0, 0, 0, 1215, 1213, 1, 0, 0, 0, 1215, 1216, 1, 0, 0, 0, 1216, 207, 1, 0, 0, 0, 1217, 1219, 3, 184, 83, 0, 1218, 1217, 1, 0, 0, 0, 1219, 1220, 1, 0, 0, 0, 1220, 1218, 1, 0, 0, 0, 1220, 1221, 1, 0, 0, 0, 1221, 1222, 1, 0, 0, 0, 1222, 1226, 3, 228, 105, 0, 1223, 1225, 3, 184, 83, 0, 1224, 1223, 1, 0, 0, 0, 1225, 1228, 1, 0, 0, 0, 1226, 1224, 1, 0, 0, 0, 1226, 1227, 1, 0, 0, 0, 1227, 1260, 1, 0, 0, 0, 1228, 1226, 1, 0, 0, 0, 1229, 1231, 3, 228, 105, 0, 1230, 1232, 3, 184, 83, 0, 1231, 1230, 1, 0, 0, 0, 1232, 1233, 1, 0, 0, 0, 1233, 1231, 1, 0, 0, 0, 1233, 1234, 1, 0, 0, 0, 1234, 1260, 1, 0, 0, 0, 1235, 1237, 3, 184, 83, 0, 1236, 1235, 1, 0, 0, 0, 1237, 1238, 1, 0, 0, 0, 1238, 1236, 1, 0, 0, 0, 1238, 1239, 1, 0, 0, 0, 1239, 1247, 1, 0, 0, 0, 1240, 1244, 3, 228, 105, 0, 1241, 1243, 3, 184, 83, 0, 1242, 1241, 1, 0, 0, 0, 1243, 1246, 1, 0, 0, 0, 1244, 1242, 1, 0, 0, 0, 1244, 1245, 1, 0, 0, 0, 1245, 1248, 1, 0, 0, 0, 1246, 1244, 1, 0, 0, 0, 1247, 1240, 1, 0, 0, 0, 1247, 1248, 1, 0, 0, 0, 1248, 1249, 1, 0, 0, 0, 1249, 1250, 3, 192, 87, 0, 1250, 1260, 1, 0, 0, 0, 1251, 1253, 3, 228, 105, 0, 1252, 1254, 3, 184, 83, 0, 1253, 1252, 1, 0, 0, 0, 1254, 1255, 1, 0, 0, 0, 1255, 1253, 1, 0, 0, 0, 1255, 1256, 1, 0, 0, 0, 1256, 1257, 1, 0, 0, 0, 1257, 1258, 3, 192, 87, 0, 1258, 1260, 1, 0, 0, 0, 1259, 1218, 1, 0, 0, 0, 1259, 1229, 1, 0, 0, 0, 1259, 1236, 1, 0, 0, 0, 1259, 1251, 1, 0, 0, 0, 1260, 209, 1, 0, 0, 0, 1261, 1262, 7, 4, 0, 0, 1262, 1263, 7, 5, 0, 0, 1263, 1264, 7, 16, 0, 0, 1264, 211, 1, 0, 0, 0, 1265, 1266, 7, 4, 0, 0, 1266, 1267, 7, 17, 0, 0, 1267, 1268, 7, 2, 0, 0, 1268, 213, 1, 0, 0, 0, 1269, 1270, 5, 61, 0, 0, 1270, 215, 1, 0, 0, 0, 1271, 1272, 7, 31, 0, 0, 1272, 1273, 7, 32, 0, 0, 1273, 217, 1, 0, 0, 0, 1274, 1275, 5, 58, 0, 0, 1275, 1276, 5, 58, 0, 0, 1276, 219, 1, 0, 0, 0, 1277, 1278, 5, 58, 0, 0, 1278, 221, 1, 0, 0, 0, 1279, 1280, 5, 59, 0, 0, 1280, 223, 1, 0, 0, 0, 1281, 1282, 5, 44, 0, 0, 1282, 225, 1, 0, 0, 0, 1283, 1284, 7, 16, 0, 0, 1284, 1285, 7, 7, 0, 0, 1285, 1286, 7, 17, 0, 0, 1286, 1287, 7, 2, 0, 0, 1287, 227, 1, 0, 0, 0, 1288, 1289, 5, 46, 0, 0, 1289, 229, 1, 0, 0, 0, 1290, 1291, 7, 21, 0, 0, 1291, 1292, 7, 4, 0, 0, 1292, 1293, 7, 14, 0, 0, 1293, 1294, 7, 17, 0, 0, 1294, 1295, 7, 7, 0, 0, 1295, 231, 1, 0, 0, 0, 1296, 1297, 7, 21, 0, 0, 1297, 1298, 7, 10, 0, 0, 1298, 1299, 7, 12, 0, 0, 1299, 1300, 7, 17, 0, 0, 1300, 1301, 7, 11, 0, 0, 1301, 233, 1, 0, 0, 0, 1302, 1303, 7, 10, 0, 0, 1303, 1304, 7, 5, 0, 0, 1304, 235, 1, 0, 0, 0, 1305, 1306, 7, 10, 0, 0, 1306, 1307, 7, 17, 0, 0, 1307, 237, 1, 0, 0, 0, 1308, 1309, 7, 14, 0, 0, 1309, 1310, 7, 4, 0, 0, 1310, 1311, 7, 17, 0, 0, 1311, 1312, 7, 11, 0, 0, 1312, 239, 1, 0, 0, 0, 1313, 1314, 7, 14, 0, 0, 1314, 1315, 7, 10, 0, 0, 1315, 1316, 7, 19, 0, 0, 1316, 1317, 7, 7, 0, 0, 1317, 241, 1, 0, 0, 0, 1318, 1319, 7, 5, 0, 0, 1319, 1320, 7, 9, 0, 0, 1320, 1321, 7, 11, 0, 0, 1321, 243, 1, 0, 0, 0, 1322, 1323, 7, 5, 0, 0, 1323, 1324, 7, 22, 0, 0, 1324, 1325, 7, 14, 0, 0, 1325, 1326, 7, 14, 0, 0, 1326, 245, 1, 0, 0, 0, 1327, 1328, 7, 5, 0, 0, 1328, 1329, 7, 22, 0, 0, 1329, 1330, 7, 14, 0, 0, 1330, 1331, 7, 14, 0, 0, 1331, 1332, 7, 17, 0, 0, 1332, 247, 1, 0, 0, 0, 1333, 1334, 7, 9, 0, 0, 1334, 1335, 7, 5, 0, 0, 1335, 249, 1, 0, 0, 0, 1336, 1337, 7, 9, 0, 0, 1337, 1338, 7, 12, 0, 0, 1338, 251, 1, 0, 0, 0, 1339, 1340, 5, 63, 0, 0, 1340, 253, 1, 0, 0, 0, 1341, 1342, 7, 12, 0, 0, 1342, 1343, 7, 14, 0, 0, 1343, 1344, 7, 10, 0, 0, 1344, 1345, 7, 19, 0, 0, 1345, 1346, 7, 7, 0, 0, 1346, 255, 1, 0, 0, 0, 1347, 1348, 7, 11, 0, 0, 1348, 1349, 7, 12, 0, 0, 1349, 1350, 7, 22, 0, 0, 1350, 1351, 7, 7, 0, 0, 1351, 257, 1, 0, 0, 0, 1352, 1353, 7, 20, 0, 0, 1353, 1354, 7, 10, 0, 0, 1354, 1355, 7, 11, 0, 0, 1355, 1356, 7, 3, 0, 0, 1356, 259, 1, 0, 0, 0, 1357, 1358, 5, 61, 0, 0, 1358, 1359, 5, 61, 0, 0, 1359, 261, 1, 0, 0, 0, 1360, 1361, 5, 61, 0, 0, 1361, 1362, 5, 126, 0, 0, 1362, 263, 1, 0, 0, 0, 1363, 1364, 5, 33, 0, 0, 1364, 1365, 5, 61, 0, 0, 1365, 265, 1, 0, 0, 0, 1366, 1367, 5, 60, 0, 0, 1367, 267, 1, 0, 0, 0, 1368, 1369, 5, 60, 0, 0, 1369, 1370, 5, 61, 0, 0, 1370, 269, 1, 0, 0, 0, 1371, 1372, 5, 62, 0, 0, 1372, 271, 1, 0, 0, 0, 1373, 1374, 5, 62, 0, 0, 1374, 1375, 5, 61, 0, 0, 1375, 273, 1, 0, 0, 0, 1376, 1377, 5, 43, 0, 0, 1377, 275, 1, 0, 0, 0, 1378, 1379, 5, 45, 0, 0, 1379, 277, 1, 0, 0, 0, 1380, 1381, 5, 42, 0, 0, 1381, 279, 1, 0, 0, 0, 1382, 1383, 5, 47, 0, 0, 1383, 281, 1, 0, 0, 0, 1384, 1385, 5, 37, 0, 0, 1385, 283, 1, 0, 0, 0, 1386, 1387, 5, 123, 0, 0, 1387, 285, 1, 0, 0, 0, 1388, 1389, 5, 125, 0, 0, 1389, 287, 1, 0, 0, 0, 1390, 1391, 5, 63, 0, 0, 1391, 1392, 5, 63, 0, 0, 1392, 289, 1, 0, 0, 0, 1393, 1394, 3, 50, 16, 0, 1394, 1395, 1, 0, 0, 0, 1395, 1396, 6, 136, 39, 0, 1396, 291, 1, 0, 0, 0, 1397, 1400, 3, 252, 117, 0, 1398, 1401, 3, 186, 84, 0, 1399, 1401, 3, 200, 91, 0, 1400, 1398, 1, 0, 0, 0, 1400, 1399, 1, 0, 0, 0, 1401, 1405, 1, 0, 0, 0, 1402, 1404, 3, 202, 92, 0, 1403, 1402, 1, 0, 0, 0, 1404, 1407, 1, 0, 0, 0, 1405, 1403, 1, 0, 0, 0, 1405, 1406, 1, 0, 0, 0, 1406, 1415, 1, 0, 0, 0, 1407, 1405, 1, 0, 0, 0, 1408, 1410, 3, 252, 117, 0, 1409, 1411, 3, 184, 83, 0, 1410, 1409, 1, 0, 0, 0, 1411, 1412, 1, 0, 0, 0, 1412, 1410, 1, 0, 0, 0, 1412, 1413, 1, 0, 0, 0, 1413, 1415, 1, 0, 0, 0, 1414, 1397, 1, 0, 0, 0, 1414, 1408, 1, 0, 0, 0, 1415, 293, 1, 0, 0, 0, 1416, 1419, 3, 288, 135, 0, 1417, 1420, 3, 186, 84, 0, 1418, 1420, 3, 200, 91, 0, 1419, 1417, 1, 0, 0, 0, 1419, 1418, 1, 0, 0, 0, 1420, 1424, 1, 0, 0, 0, 1421, 1423, 3, 202, 92, 0, 1422, 1421, 1, 0, 0, 0, 1423, 1426, 1, 0, 0, 0, 1424, 1422, 1, 0, 0, 0, 1424, 1425, 1, 0, 0, 0, 1425, 1434, 1, 0, 0, 0, 1426, 1424, 1, 0, 0, 0, 1427, 1429, 3, 288, 135, 0, 1428, 1430, 3, 184, 83, 0, 1429, 1428, 1, 0, 0, 0, 1430, 1431, 1, 0, 0, 0, 1431, 1429, 1, 0, 0, 0, 1431, 1432, 1, 0, 0, 0, 1432, 1434, 1, 0, 0, 0, 1433, 1416, 1, 0, 0, 0, 1433, 1427, 1, 0, 0, 0, 1434, 295, 1, 0, 0, 0, 1435, 1436, 5, 91, 0, 0, 1436, 1437, 1, 0, 0, 0, 1437, 1438, 6, 139, 4, 0, 1438, 1439, 6, 139, 4, 0, 1439, 297, 1, 0, 0, 0, 1440, 1441, 5, 93, 0, 0, 1441, 1442, 1, 0, 0, 0, 1442, 1443, 6, 140, 17, 0, 1443, 1444, 6, 140, 17, 0, 1444, 299, 1, 0, 0, 0, 1445, 1446, 5, 40, 0, 0, 1446, 1447, 1, 0, 0, 0, 1447, 1448, 6, 141, 4, 0, 1448, 1449, 6, 141, 4, 0, 1449, 301, 1, 0, 0, 0, 1450, 1451, 5, 41, 0, 0, 1451, 1452, 1, 0, 0, 0, 1452, 1453, 6, 142, 17, 0, 1453, 1454, 6, 142, 17, 0, 1454, 303, 1, 0, 0, 0, 1455, 1459, 3, 186, 84, 0, 1456, 1458, 3, 202, 92, 0, 1457, 1456, 1, 0, 0, 0, 1458, 1461, 1, 0, 0, 0, 1459, 1457, 1, 0, 0, 0, 1459, 1460, 1, 0, 0, 0, 1460, 1472, 1, 0, 0, 0, 1461, 1459, 1, 0, 0, 0, 1462, 1465, 3, 200, 91, 0, 1463, 1465, 3, 194, 88, 0, 1464, 1462, 1, 0, 0, 0, 1464, 1463, 1, 0, 0, 0, 1465, 1467, 1, 0, 0, 0, 1466, 1468, 3, 202, 92, 0, 1467, 1466, 1, 0, 0, 0, 1468, 1469, 1, 0, 0, 0, 1469, 1467, 1, 0, 0, 0, 1469, 1470, 1, 0, 0, 0, 1470, 1472, 1, 0, 0, 0, 1471, 1455, 1, 0, 0, 0, 1471, 1464, 1, 0, 0, 0, 1472, 305, 1, 0, 0, 0, 1473, 1475, 3, 196, 89, 0, 1474, 1476, 3, 198, 90, 0, 1475, 1474, 1, 0, 0, 0, 1476, 1477, 1, 0, 0, 0, 1477, 1475, 1, 0, 0, 0, 1477, 1478, 1, 0, 0, 0, 1478, 1479, 1, 0, 0, 0, 1479, 1480, 3, 196, 89, 0, 1480, 307, 1, 0, 0, 0, 1481, 1482, 3, 306, 144, 0, 1482, 309, 1, 0, 0, 0, 1483, 1484, 3, 18, 0, 0, 1484, 1485, 1, 0, 0, 0, 1485, 1486, 6, 146, 0, 0, 1486, 311, 1, 0, 0, 0, 1487, 1488, 3, 20, 1, 0, 1488, 1489, 1, 0, 0, 0, 1489, 1490, 6, 147, 0, 0, 1490, 313, 1, 0, 0, 0, 1491, 1492, 3, 22, 2, 0, 1492, 1493, 1, 0, 0, 0, 1493, 1494, 6, 148, 0, 0, 1494, 315, 1, 0, 0, 0, 1495, 1496, 3, 182, 82, 0, 1496, 1497, 1, 0, 0, 0, 1497, 1498, 6, 149, 16, 0, 1498, 1499, 6, 149, 17, 0, 1499, 317, 1, 0, 0, 0, 1500, 1501, 3, 220, 101, 0, 1501, 1502, 1, 0, 0, 0, 1502, 1503, 6, 150, 40, 0, 1503, 319, 1, 0, 0, 0, 1504, 1505, 3, 218, 100, 0, 1505, 1506, 1, 0, 0, 0, 1506, 1507, 6, 151, 41, 0, 1507, 321, 1, 0, 0, 0, 1508, 1509, 3, 224, 103, 0, 1509, 1510, 1, 0, 0, 0, 1510, 1511, 6, 152, 22, 0, 1511, 323, 1, 0, 0, 0, 1512, 1513, 3, 214, 98, 0, 1513, 1514, 1, 0, 0, 0, 1514, 1515, 6, 153, 31, 0, 1515, 325, 1, 0, 0, 0, 1516, 1517, 7, 15, 0, 0, 1517, 1518, 7, 7, 0, 0, 1518, 1519, 7, 11, 0, 0, 1519, 1520, 7, 4, 0, 0, 1520, 1521, 7, 16, 0, 0, 1521, 1522, 7, 4, 0, 0, 1522, 1523, 7, 11, 0, 0, 1523, 1524, 7, 4, 0, 0, 1524, 327, 1, 0, 0, 0, 1525, 1526, 3, 302, 142, 0, 1526, 1527, 1, 0, 0, 0, 1527, 1528, 6, 155, 18, 0, 1528, 1529, 6, 155, 17, 0, 1529, 1530, 6, 155, 17, 0, 1530, 329, 1, 0, 0, 0, 1531, 1532, 3, 300, 141, 0, 1532, 1533, 1, 0, 0, 0, 1533, 1534, 6, 156, 37, 0, 1534, 1535, 6, 156, 38, 0, 1535, 331, 1, 0, 0, 0, 1536, 1540, 8, 33, 0, 0, 1537, 1538, 5, 47, 0, 0, 1538, 1540, 8, 34, 0, 0, 1539, 1536, 1, 0, 0, 0, 1539, 1537, 1, 0, 0, 0, 1540, 333, 1, 0, 0, 0, 1541, 1543, 3, 332, 157, 0, 1542, 1541, 1, 0, 0, 0, 1543, 1544, 1, 0, 0, 0, 1544, 1542, 1, 0, 0, 0, 1544, 1545, 1, 0, 0, 0, 1545, 335, 1, 0, 0, 0, 1546, 1547, 3, 334, 158, 0, 1547, 1548, 1, 0, 0, 0, 1548, 1549, 6, 159, 42, 0, 1549, 337, 1, 0, 0, 0, 1550, 1551, 3, 204, 93, 0, 1551, 1552, 1, 0, 0, 0, 1552, 1553, 6, 160, 30, 0, 1553, 339, 1, 0, 0, 0, 1554, 1555, 3, 18, 0, 0, 1555, 1556, 1, 0, 0, 0, 1556, 1557, 6, 161, 0, 0, 1557, 341, 1, 0, 0, 0, 1558, 1559, 3, 20, 1, 0, 1559, 1560, 1, 0, 0, 0, 1560, 1561, 6, 162, 0, 0, 1561, 343, 1, 0, 0, 0, 1562, 1563, 3, 22, 2, 0, 1563, 1564, 1, 0, 0, 0, 1564, 1565, 6, 163, 0, 0, 1565, 345, 1, 0, 0, 0, 1566, 1567, 3, 300, 141, 0, 1567, 1568, 1, 0, 0, 0, 1568, 1569, 6, 164, 37, 0, 1569, 1570, 6, 164, 38, 0, 1570, 347, 1, 0, 0, 0, 1571, 1572, 3, 302, 142, 0, 1572, 1573, 1, 0, 0, 0, 1573, 1574, 6, 165, 18, 0, 1574, 1575, 6, 165, 17, 0, 1575, 1576, 6, 165, 17, 0, 1576, 349, 1, 0, 0, 0, 1577, 1578, 3, 182, 82, 0, 1578, 1579, 1, 0, 0, 0, 1579, 1580, 6, 166, 16, 0, 1580, 1581, 6, 166, 17, 0, 1581, 351, 1, 0, 0, 0, 1582, 1583, 3, 22, 2, 0, 1583, 1584, 1, 0, 0, 0, 1584, 1585, 6, 167, 0, 0, 1585, 353, 1, 0, 0, 0, 1586, 1587, 3, 18, 0, 0, 1587, 1588, 1, 0, 0, 0, 1588, 1589, 6, 168, 0, 0, 1589, 355, 1, 0, 0, 0, 1590, 1591, 3, 20, 1, 0, 1591, 1592, 1, 0, 0, 0, 1592, 1593, 6, 169, 0, 0, 1593, 357, 1, 0, 0, 0, 1594, 1595, 3, 182, 82, 0, 1595, 1596, 1, 0, 0, 0, 1596, 1597, 6, 170, 16, 0, 1597, 1598, 6, 170, 17, 0, 1598, 359, 1, 0, 0, 0, 1599, 1600, 3, 302, 142, 0, 1600, 1601, 1, 0, 0, 0, 1601, 1602, 6, 171, 18, 0, 1602, 1603, 6, 171, 17, 0, 1603, 1604, 6, 171, 17, 0, 1604, 361, 1, 0, 0, 0, 1605, 1606, 7, 6, 0, 0, 1606, 1607, 7, 12, 0, 0, 1607, 1608, 7, 9, 0, 0, 1608, 1609, 7, 22, 0, 0, 1609, 1610, 7, 8, 0, 0, 1610, 363, 1, 0, 0, 0, 1611, 1612, 7, 17, 0, 0, 1612, 1613, 7, 2, 0, 0, 1613, 1614, 7, 9, 0, 0, 1614, 1615, 7, 12, 0, 0, 1615, 1616, 7, 7, 0, 0, 1616, 365, 1, 0, 0, 0, 1617, 1618, 7, 19, 0, 0, 1618, 1619, 7, 7, 0, 0, 1619, 1620, 7, 32, 0, 0, 1620, 367, 1, 0, 0, 0, 1621, 1622, 3, 258, 120, 0, 1622, 1623, 1, 0, 0, 0, 1623, 1624, 6, 175, 28, 0, 1624, 1625, 6, 175, 17, 0, 1625, 1626, 6, 175, 4, 0, 1626, 369, 1, 0, 0, 0, 1627, 1628, 3, 224, 103, 0, 1628, 1629, 1, 0, 0, 0, 1629, 1630, 6, 176, 22, 0, 1630, 371, 1, 0, 0, 0, 1631, 1632, 3, 228, 105, 0, 1632, 1633, 1, 0, 0, 0, 1633, 1634, 6, 177, 21, 0, 1634, 373, 1, 0, 0, 0, 1635, 1636, 3, 252, 117, 0, 1636, 1637, 1, 0, 0, 0, 1637, 1638, 6, 178, 33, 0, 1638, 375, 1, 0, 0, 0, 1639, 1640, 3, 292, 137, 0, 1640, 1641, 1, 0, 0, 0, 1641, 1642, 6, 179, 34, 0, 1642, 377, 1, 0, 0, 0, 1643, 1644, 3, 288, 135, 0, 1644, 1645, 1, 0, 0, 0, 1645, 1646, 6, 180, 35, 0, 1646, 379, 1, 0, 0, 0, 1647, 1648, 3, 294, 138, 0, 1648, 1649, 1, 0, 0, 0, 1649, 1650, 6, 181, 36, 0, 1650, 381, 1, 0, 0, 0, 1651, 1652, 3, 216, 99, 0, 1652, 1653, 1, 0, 0, 0, 1653, 1654, 6, 182, 43, 0, 1654, 383, 1, 0, 0, 0, 1655, 1656, 3, 308, 145, 0, 1656, 1657, 1, 0, 0, 0, 1657, 1658, 6, 183, 25, 0, 1658, 385, 1, 0, 0, 0, 1659, 1660, 3, 304, 143, 0, 1660, 1661, 1, 0, 0, 0, 1661, 1662, 6, 184, 26, 0, 1662, 387, 1, 0, 0, 0, 1663, 1664, 3, 18, 0, 0, 1664, 1665, 1, 0, 0, 0, 1665, 1666, 6, 185, 0, 0, 1666, 389, 1, 0, 0, 0, 1667, 1668, 3, 20, 1, 0, 1668, 1669, 1, 0, 0, 0, 1669, 1670, 6, 186, 0, 0, 1670, 391, 1, 0, 0, 0, 1671, 1672, 3, 22, 2, 0, 1672, 1673, 1, 0, 0, 0, 1673, 1674, 6, 187, 0, 0, 1674, 393, 1, 0, 0, 0, 1675, 1676, 7, 17, 0, 0, 1676, 1677, 7, 11, 0, 0, 1677, 1678, 7, 4, 0, 0, 1678, 1679, 7, 11, 0, 0, 1679, 1680, 7, 17, 0, 0, 1680, 1681, 1, 0, 0, 0, 1681, 1682, 6, 188, 17, 0, 1682, 1683, 6, 188, 4, 0, 1683, 395, 1, 0, 0, 0, 1684, 1685, 3, 18, 0, 0, 1685, 1686, 1, 0, 0, 0, 1686, 1687, 6, 189, 0, 0, 1687, 397, 1, 0, 0, 0, 1688, 1689, 3, 20, 1, 0, 1689, 1690, 1, 0, 0, 0, 1690, 1691, 6, 190, 0, 0, 1691, 399, 1, 0, 0, 0, 1692, 1693, 3, 22, 2, 0, 1693, 1694, 1, 0, 0, 0, 1694, 1695, 6, 191, 0, 0, 1695, 401, 1, 0, 0, 0, 1696, 1697, 3, 182, 82, 0, 1697, 1698, 1, 0, 0, 0, 1698, 1699, 6, 192, 16, 0, 1699, 1700, 6, 192, 17, 0, 1700, 403, 1, 0, 0, 0, 1701, 1702, 7, 35, 0, 0, 1702, 1703, 7, 9, 0, 0, 1703, 1704, 7, 10, 0, 0, 1704, 1705, 7, 5, 0, 0, 1705, 405, 1, 0, 0, 0, 1706, 1707, 3, 544, 263, 0, 1707, 1708, 1, 0, 0, 0, 1708, 1709, 6, 194, 20, 0, 1709, 407, 1, 0, 0, 0, 1710, 1711, 3, 248, 115, 0, 1711, 1712, 1, 0, 0, 0, 1712, 1713, 6, 195, 19, 0, 1713, 1714, 6, 195, 17, 0, 1714, 1715, 6, 195, 4, 0, 1715, 409, 1, 0, 0, 0, 1716, 1717, 7, 22, 0, 0, 1717, 1718, 7, 17, 0, 0, 1718, 1719, 7, 10, 0, 0, 1719, 1720, 7, 5, 0, 0, 1720, 1721, 7, 6, 0, 0, 1721, 1722, 1, 0, 0, 0, 1722, 1723, 6, 196, 17, 0, 1723, 1724, 6, 196, 4, 0, 1724, 411, 1, 0, 0, 0, 1725, 1726, 3, 334, 158, 0, 1726, 1727, 1, 0, 0, 0, 1727, 1728, 6, 197, 42, 0, 1728, 413, 1, 0, 0, 0, 1729, 1730, 3, 204, 93, 0, 1730, 1731, 1, 0, 0, 0, 1731, 1732, 6, 198, 30, 0, 1732, 415, 1, 0, 0, 0, 1733, 1734, 3, 220, 101, 0, 1734, 1735, 1, 0, 0, 0, 1735, 1736, 6, 199, 40, 0, 1736, 417, 1, 0, 0, 0, 1737, 1738, 3, 18, 0, 0, 1738, 1739, 1, 0, 0, 0, 1739, 1740, 6, 200, 0, 0, 1740, 419, 1, 0, 0, 0, 1741, 1742, 3, 20, 1, 0, 1742, 1743, 1, 0, 0, 0, 1743, 1744, 6, 201, 0, 0, 1744, 421, 1, 0, 0, 0, 1745, 1746, 3, 22, 2, 0, 1746, 1747, 1, 0, 0, 0, 1747, 1748, 6, 202, 0, 0, 1748, 423, 1, 0, 0, 0, 1749, 1750, 3, 182, 82, 0, 1750, 1751, 1, 0, 0, 0, 1751, 1752, 6, 203, 16, 0, 1752, 1753, 6, 203, 17, 0, 1753, 425, 1, 0, 0, 0, 1754, 1755, 3, 302, 142, 0, 1755, 1756, 1, 0, 0, 0, 1756, 1757, 6, 204, 18, 0, 1757, 1758, 6, 204, 17, 0, 1758, 1759, 6, 204, 17, 0, 1759, 427, 1, 0, 0, 0, 1760, 1761, 3, 220, 101, 0, 1761, 1762, 1, 0, 0, 0, 1762, 1763, 6, 205, 40, 0, 1763, 429, 1, 0, 0, 0, 1764, 1765, 3, 224, 103, 0, 1765, 1766, 1, 0, 0, 0, 1766, 1767, 6, 206, 22, 0, 1767, 431, 1, 0, 0, 0, 1768, 1769, 3, 228, 105, 0, 1769, 1770, 1, 0, 0, 0, 1770, 1771, 6, 207, 21, 0, 1771, 433, 1, 0, 0, 0, 1772, 1773, 3, 248, 115, 0, 1773, 1774, 1, 0, 0, 0, 1774, 1775, 6, 208, 19, 0, 1775, 1776, 6, 208, 44, 0, 1776, 435, 1, 0, 0, 0, 1777, 1778, 3, 334, 158, 0, 1778, 1779, 1, 0, 0, 0, 1779, 1780, 6, 209, 42, 0, 1780, 437, 1, 0, 0, 0, 1781, 1782, 3, 204, 93, 0, 1782, 1783, 1, 0, 0, 0, 1783, 1784, 6, 210, 30, 0, 1784, 439, 1, 0, 0, 0, 1785, 1786, 3, 18, 0, 0, 1786, 1787, 1, 0, 0, 0, 1787, 1788, 6, 211, 0, 0, 1788, 441, 1, 0, 0, 0, 1789, 1790, 3, 20, 1, 0, 1790, 1791, 1, 0, 0, 0, 1791, 1792, 6, 212, 0, 0, 1792, 443, 1, 0, 0, 0, 1793, 1794, 3, 22, 2, 0, 1794, 1795, 1, 0, 0, 0, 1795, 1796, 6, 213, 0, 0, 1796, 445, 1, 0, 0, 0, 1797, 1798, 3, 182, 82, 0, 1798, 1799, 1, 0, 0, 0, 1799, 1800, 6, 214, 16, 0, 1800, 1801, 6, 214, 17, 0, 1801, 1802, 6, 214, 17, 0, 1802, 447, 1, 0, 0, 0, 1803, 1804, 3, 302, 142, 0, 1804, 1805, 1, 0, 0, 0, 1805, 1806, 6, 215, 18, 0, 1806, 1807, 6, 215, 17, 0, 1807, 1808, 6, 215, 17, 0, 1808, 1809, 6, 215, 17, 0, 1809, 449, 1, 0, 0, 0, 1810, 1811, 3, 224, 103, 0, 1811, 1812, 1, 0, 0, 0, 1812, 1813, 6, 216, 22, 0, 1813, 451, 1, 0, 0, 0, 1814, 1815, 3, 228, 105, 0, 1815, 1816, 1, 0, 0, 0, 1816, 1817, 6, 217, 21, 0, 1817, 453, 1, 0, 0, 0, 1818, 1819, 3, 514, 248, 0, 1819, 1820, 1, 0, 0, 0, 1820, 1821, 6, 218, 32, 0, 1821, 455, 1, 0, 0, 0, 1822, 1823, 3, 18, 0, 0, 1823, 1824, 1, 0, 0, 0, 1824, 1825, 6, 219, 0, 0, 1825, 457, 1, 0, 0, 0, 1826, 1827, 3, 20, 1, 0, 1827, 1828, 1, 0, 0, 0, 1828, 1829, 6, 220, 0, 0, 1829, 459, 1, 0, 0, 0, 1830, 1831, 3, 22, 2, 0, 1831, 1832, 1, 0, 0, 0, 1832, 1833, 6, 221, 0, 0, 1833, 461, 1, 0, 0, 0, 1834, 1835, 3, 182, 82, 0, 1835, 1836, 1, 0, 0, 0, 1836, 1837, 6, 222, 16, 0, 1837, 1838, 6, 222, 17, 0, 1838, 463, 1, 0, 0, 0, 1839, 1840, 3, 302, 142, 0, 1840, 1841, 1, 0, 0, 0, 1841, 1842, 6, 223, 18, 0, 1842, 1843, 6, 223, 17, 0, 1843, 1844, 6, 223, 17, 0, 1844, 465, 1, 0, 0, 0, 1845, 1846, 3, 296, 139, 0, 1846, 1847, 1, 0, 0, 0, 1847, 1848, 6, 224, 23, 0, 1848, 467, 1, 0, 0, 0, 1849, 1850, 3, 298, 140, 0, 1850, 1851, 1, 0, 0, 0, 1851, 1852, 6, 225, 24, 0, 1852, 469, 1, 0, 0, 0, 1853, 1854, 3, 228, 105, 0, 1854, 1855, 1, 0, 0, 0, 1855, 1856, 6, 226, 21, 0, 1856, 471, 1, 0, 0, 0, 1857, 1858, 3, 252, 117, 0, 1858, 1859, 1, 0, 0, 0, 1859, 1860, 6, 227, 33, 0, 1860, 473, 1, 0, 0, 0, 1861, 1862, 3, 292, 137, 0, 1862, 1863, 1, 0, 0, 0, 1863, 1864, 6, 228, 34, 0, 1864, 475, 1, 0, 0, 0, 1865, 1866, 3, 288, 135, 0, 1866, 1867, 1, 0, 0, 0, 1867, 1868, 6, 229, 35, 0, 1868, 477, 1, 0, 0, 0, 1869, 1870, 3, 294, 138, 0, 1870, 1871, 1, 0, 0, 0, 1871, 1872, 6, 230, 36, 0, 1872, 479, 1, 0, 0, 0, 1873, 1874, 3, 308, 145, 0, 1874, 1875, 1, 0, 0, 0, 1875, 1876, 6, 231, 25, 0, 1876, 481, 1, 0, 0, 0, 1877, 1878, 3, 304, 143, 0, 1878, 1879, 1, 0, 0, 0, 1879, 1880, 6, 232, 26, 0, 1880, 483, 1, 0, 0, 0, 1881, 1882, 3, 18, 0, 0, 1882, 1883, 1, 0, 0, 0, 1883, 1884, 6, 233, 0, 0, 1884, 485, 1, 0, 0, 0, 1885, 1886, 3, 20, 1, 0, 1886, 1887, 1, 0, 0, 0, 1887, 1888, 6, 234, 0, 0, 1888, 487, 1, 0, 0, 0, 1889, 1890, 3, 22, 2, 0, 1890, 1891, 1, 0, 0, 0, 1891, 1892, 6, 235, 0, 0, 1892, 489, 1, 0, 0, 0, 1893, 1894, 3, 182, 82, 0, 1894, 1895, 1, 0, 0, 0, 1895, 1896, 6, 236, 16, 0, 1896, 1897, 6, 236, 17, 0, 1897, 491, 1, 0, 0, 0, 1898, 1899, 3, 302, 142, 0, 1899, 1900, 1, 0, 0, 0, 1900, 1901, 6, 237, 18, 0, 1901, 1902, 6, 237, 17, 0, 1902, 1903, 6, 237, 17, 0, 1903, 493, 1, 0, 0, 0, 1904, 1905, 3, 228, 105, 0, 1905, 1906, 1, 0, 0, 0, 1906, 1907, 6, 238, 21, 0, 1907, 495, 1, 0, 0, 0, 1908, 1909, 3, 296, 139, 0, 1909, 1910, 1, 0, 0, 0, 1910, 1911, 6, 239, 23, 0, 1911, 497, 1, 0, 0, 0, 1912, 1913, 3, 298, 140, 0, 1913, 1914, 1, 0, 0, 0, 1914, 1915, 6, 240, 24, 0, 1915, 499, 1, 0, 0, 0, 1916, 1917, 3, 224, 103, 0, 1917, 1918, 1, 0, 0, 0, 1918, 1919, 6, 241, 22, 0, 1919, 501, 1, 0, 0, 0, 1920, 1921, 3, 252, 117, 0, 1921, 1922, 1, 0, 0, 0, 1922, 1923, 6, 242, 33, 0, 1923, 503, 1, 0, 0, 0, 1924, 1925, 3, 292, 137, 0, 1925, 1926, 1, 0, 0, 0, 1926, 1927, 6, 243, 34, 0, 1927, 505, 1, 0, 0, 0, 1928, 1929, 3, 288, 135, 0, 1929, 1930, 1, 0, 0, 0, 1930, 1931, 6, 244, 35, 0, 1931, 507, 1, 0, 0, 0, 1932, 1933, 3, 294, 138, 0, 1933, 1934, 1, 0, 0, 0, 1934, 1935, 6, 245, 36, 0, 1935, 509, 1, 0, 0, 0, 1936, 1941, 3, 186, 84, 0, 1937, 1941, 3, 184, 83, 0, 1938, 1941, 3, 200, 91, 0, 1939, 1941, 3, 278, 130, 0, 1940, 1936, 1, 0, 0, 0, 1940, 1937, 1, 0, 0, 0, 1940, 1938, 1, 0, 0, 0, 1940, 1939, 1, 0, 0, 0, 1941, 511, 1, 0, 0, 0, 1942, 1945, 3, 186, 84, 0, 1943, 1945, 3, 278, 130, 0, 1944, 1942, 1, 0, 0, 0, 1944, 1943, 1, 0, 0, 0, 1945, 1949, 1, 0, 0, 0, 1946, 1948, 3, 510, 246, 0, 1947, 1946, 1, 0, 0, 0, 1948, 1951, 1, 0, 0, 0, 1949, 1947, 1, 0, 0, 0, 1949, 1950, 1, 0, 0, 0, 1950, 1962, 1, 0, 0, 0, 1951, 1949, 1, 0, 0, 0, 1952, 1955, 3, 200, 91, 0, 1953, 1955, 3, 194, 88, 0, 1954, 1952, 1, 0, 0, 0, 1954, 1953, 1, 0, 0, 0, 1955, 1957, 1, 0, 0, 0, 1956, 1958, 3, 510, 246, 0, 1957, 1956, 1, 0, 0, 0, 1958, 1959, 1, 0, 0, 0, 1959, 1957, 1, 0, 0, 0, 1959, 1960, 1, 0, 0, 0, 1960, 1962, 1, 0, 0, 0, 1961, 1944, 1, 0, 0, 0, 1961, 1954, 1, 0, 0, 0, 1962, 513, 1, 0, 0, 0, 1963, 1966, 3, 512, 247, 0, 1964, 1966, 3, 306, 144, 0, 1965, 1963, 1, 0, 0, 0, 1965, 1964, 1, 0, 0, 0, 1966, 1967, 1, 0, 0, 0, 1967, 1965, 1, 0, 0, 0, 1967, 1968, 1, 0, 0, 0, 1968, 515, 1, 0, 0, 0, 1969, 1970, 3, 18, 0, 0, 1970, 1971, 1, 0, 0, 0, 1971, 1972, 6, 249, 0, 0, 1972, 517, 1, 0, 0, 0, 1973, 1974, 3, 20, 1, 0, 1974, 1975, 1, 0, 0, 0, 1975, 1976, 6, 250, 0, 0, 1976, 519, 1, 0, 0, 0, 1977, 1978, 3, 22, 2, 0, 1978, 1979, 1, 0, 0, 0, 1979, 1980, 6, 251, 0, 0, 1980, 521, 1, 0, 0, 0, 1981, 1982, 3, 182, 82, 0, 1982, 1983, 1, 0, 0, 0, 1983, 1984, 6, 252, 16, 0, 1984, 1985, 6, 252, 17, 0, 1985, 523, 1, 0, 0, 0, 1986, 1987, 3, 302, 142, 0, 1987, 1988, 1, 0, 0, 0, 1988, 1989, 6, 253, 18, 0, 1989, 1990, 6, 253, 17, 0, 1990, 1991, 6, 253, 17, 0, 1991, 525, 1, 0, 0, 0, 1992, 1993, 3, 296, 139, 0, 1993, 1994, 1, 0, 0, 0, 1994, 1995, 6, 254, 23, 0, 1995, 527, 1, 0, 0, 0, 1996, 1997, 3, 298, 140, 0, 1997, 1998, 1, 0, 0, 0, 1998, 1999, 6, 255, 24, 0, 1999, 529, 1, 0, 0, 0, 2000, 2001, 3, 214, 98, 0, 2001, 2002, 1, 0, 0, 0, 2002, 2003, 6, 256, 31, 0, 2003, 531, 1, 0, 0, 0, 2004, 2005, 3, 224, 103, 0, 2005, 2006, 1, 0, 0, 0, 2006, 2007, 6, 257, 22, 0, 2007, 533, 1, 0, 0, 0, 2008, 2009, 3, 228, 105, 0, 2009, 2010, 1, 0, 0, 0, 2010, 2011, 6, 258, 21, 0, 2011, 535, 1, 0, 0, 0, 2012, 2013, 3, 252, 117, 0, 2013, 2014, 1, 0, 0, 0, 2014, 2015, 6, 259, 33, 0, 2015, 537, 1, 0, 0, 0, 2016, 2017, 3, 292, 137, 0, 2017, 2018, 1, 0, 0, 0, 2018, 2019, 6, 260, 34, 0, 2019, 539, 1, 0, 0, 0, 2020, 2021, 3, 288, 135, 0, 2021, 2022, 1, 0, 0, 0, 2022, 2023, 6, 261, 35, 0, 2023, 541, 1, 0, 0, 0, 2024, 2025, 3, 294, 138, 0, 2025, 2026, 1, 0, 0, 0, 2026, 2027, 6, 262, 36, 0, 2027, 543, 1, 0, 0, 0, 2028, 2029, 7, 4, 0, 0, 2029, 2030, 7, 17, 0, 0, 2030, 545, 1, 0, 0, 0, 2031, 2032, 3, 514, 248, 0, 2032, 2033, 1, 0, 0, 0, 2033, 2034, 6, 264, 32, 0, 2034, 547, 1, 0, 0, 0, 2035, 2036, 3, 18, 0, 0, 2036, 2037, 1, 0, 0, 0, 2037, 2038, 6, 265, 0, 0, 2038, 549, 1, 0, 0, 0, 2039, 2040, 3, 20, 1, 0, 2040, 2041, 1, 0, 0, 0, 2041, 2042, 6, 266, 0, 0, 2042, 551, 1, 0, 0, 0, 2043, 2044, 3, 22, 2, 0, 2044, 2045, 1, 0, 0, 0, 2045, 2046, 6, 267, 0, 0, 2046, 553, 1, 0, 0, 0, 2047, 2048, 3, 256, 119, 0, 2048, 2049, 1, 0, 0, 0, 2049, 2050, 6, 268, 45, 0, 2050, 555, 1, 0, 0, 0, 2051, 2052, 3, 230, 106, 0, 2052, 2053, 1, 0, 0, 0, 2053, 2054, 6, 269, 46, 0, 2054, 557, 1, 0, 0, 0, 2055, 2056, 3, 244, 113, 0, 2056, 2057, 1, 0, 0, 0, 2057, 2058, 6, 270, 47, 0, 2058, 559, 1, 0, 0, 0, 2059, 2060, 3, 222, 102, 0, 2060, 2061, 1, 0, 0, 0, 2061, 2062, 6, 271, 48, 0, 2062, 2063, 6, 271, 17, 0, 2063, 561, 1, 0, 0, 0, 2064, 2065, 3, 214, 98, 0, 2065, 2066, 1, 0, 0, 0, 2066, 2067, 6, 272, 31, 0, 2067, 563, 1, 0, 0, 0, 2068, 2069, 3, 204, 93, 0, 2069, 2070, 1, 0, 0, 0, 2070, 2071, 6, 273, 30, 0, 2071, 565, 1, 0, 0, 0, 2072, 2073, 3, 304, 143, 0, 2073, 2074, 1, 0, 0, 0, 2074, 2075, 6, 274, 26, 0, 2075, 567, 1, 0, 0, 0, 2076, 2077, 3, 308, 145, 0, 2077, 2078, 1, 0, 0, 0, 2078, 2079, 6, 275, 25, 0, 2079, 569, 1, 0, 0, 0, 2080, 2081, 3, 208, 95, 0, 2081, 2082, 1, 0, 0, 0, 2082, 2083, 6, 276, 49, 0, 2083, 571, 1, 0, 0, 0, 2084, 2085, 3, 206, 94, 0, 2085, 2086, 1, 0, 0, 0, 2086, 2087, 6, 277, 50, 0, 2087, 573, 1, 0, 0, 0, 2088, 2089, 3, 224, 103, 0, 2089, 2090, 1, 0, 0, 0, 2090, 2091, 6, 278, 22, 0, 2091, 575, 1, 0, 0, 0, 2092, 2093, 3, 228, 105, 0, 2093, 2094, 1, 0, 0, 0, 2094, 2095, 6, 279, 21, 0, 2095, 577, 1, 0, 0, 0, 2096, 2097, 3, 252, 117, 0, 2097, 2098, 1, 0, 0, 0, 2098, 2099, 6, 280, 33, 0, 2099, 579, 1, 0, 0, 0, 2100, 2101, 3, 292, 137, 0, 2101, 2102, 1, 0, 0, 0, 2102, 2103, 6, 281, 34, 0, 2103, 581, 1, 0, 0, 0, 2104, 2105, 3, 288, 135, 0, 2105, 2106, 1, 0, 0, 0, 2106, 2107, 6, 282, 35, 0, 2107, 583, 1, 0, 0, 0, 2108, 2109, 3, 294, 138, 0, 2109, 2110, 1, 0, 0, 0, 2110, 2111, 6, 283, 36, 0, 2111, 585, 1, 0, 0, 0, 2112, 2113, 3, 296, 139, 0, 2113, 2114, 1, 0, 0, 0, 2114, 2115, 6, 284, 23, 0, 2115, 587, 1, 0, 0, 0, 2116, 2117, 3, 298, 140, 0, 2117, 2118, 1, 0, 0, 0, 2118, 2119, 6, 285, 24, 0, 2119, 589, 1, 0, 0, 0, 2120, 2121, 3, 514, 248, 0, 2121, 2122, 1, 0, 0, 0, 2122, 2123, 6, 286, 32, 0, 2123, 591, 1, 0, 0, 0, 2124, 2125, 3, 18, 0, 0, 2125, 2126, 1, 0, 0, 0, 2126, 2127, 6, 287, 0, 0, 2127, 593, 1, 0, 0, 0, 2128, 2129, 3, 20, 1, 0, 2129, 2130, 1, 0, 0, 0, 2130, 2131, 6, 288, 0, 0, 2131, 595, 1, 0, 0, 0, 2132, 2133, 3, 22, 2, 0, 2133, 2134, 1, 0, 0, 0, 2134, 2135, 6, 289, 0, 0, 2135, 597, 1, 0, 0, 0, 2136, 2137, 3, 182, 82, 0, 2137, 2138, 1, 0, 0, 0, 2138, 2139, 6, 290, 16, 0, 2139, 2140, 6, 290, 17, 0, 2140, 599, 1, 0, 0, 0, 2141, 2142, 7, 10, 0, 0, 2142, 2143, 7, 5, 0, 0, 2143, 2144, 7, 21, 0, 0, 2144, 2145, 7, 9, 0, 0, 2145, 601, 1, 0, 0, 0, 2146, 2147, 3, 18, 0, 0, 2147, 2148, 1, 0, 0, 0, 2148, 2149, 6, 292, 0, 0, 2149, 603, 1, 0, 0, 0, 2150, 2151, 3, 20, 1, 0, 2151, 2152, 1, 0, 0, 0, 2152, 2153, 6, 293, 0, 0, 2153, 605, 1, 0, 0, 0, 2154, 2155, 3, 22, 2, 0, 2155, 2156, 1, 0, 0, 0, 2156, 2157, 6, 294, 0, 0, 2157, 607, 1, 0, 0, 0, 70, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 614, 618, 621, 630, 632, 643, 932, 1017, 1021, 1026, 1158, 1163, 1172, 1179, 1184, 1186, 1197, 1205, 1208, 1210, 1215, 1220, 1226, 1233, 1238, 1244, 1247, 1255, 1259, 1400, 1405, 1412, 1414, 1419, 1424, 1431, 1433, 1459, 1464, 1469, 1471, 1477, 1539, 1544, 1940, 1944, 1949, 1954, 1959, 1961, 1965, 1967, 51, 0, 1, 0, 5, 1, 0, 5, 2, 0, 5, 4, 0, 5, 5, 0, 5, 6, 0, 5, 7, 0, 5, 8, 0, 5, 9, 0, 5, 10, 0, 5, 11, 0, 5, 13, 0, 5, 14, 0, 5, 15, 0, 5, 16, 0, 5, 17, 0, 7, 50, 0, 4, 0, 0, 7, 99, 0, 7, 73, 0, 7, 141, 0, 7, 63, 0, 7, 61, 0, 7, 96, 0, 7, 97, 0, 7, 101, 0, 7, 100, 0, 5, 3, 0, 7, 78, 0, 7, 40, 0, 7, 51, 0, 7, 56, 0, 7, 137, 0, 7, 75, 0, 7, 94, 0, 7, 93, 0, 7, 95, 0, 7, 98, 0, 5, 0, 0, 7, 17, 0, 7, 59, 0, 7, 58, 0, 7, 106, 0, 7, 57, 0, 5, 12, 0, 7, 77, 0, 7, 64, 0, 7, 71, 0, 7, 60, 0, 7, 53, 0, 7, 52, 0]);
(0, _defineProperty2.default)(esql_lexer, "__ATN", void 0);
(0, _defineProperty2.default)(esql_lexer, "DecisionsToDFA", _esql_lexer._ATN.decisionToState.map((ds, index) => new _antlr.DFA(ds, index)));
module.exports = exports.default;