"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelineJSONBadges = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../../common/constants");
var _is_managed = require("../../../../shared/pipelines/is_managed");
var _pipelines_json_configurations_logic = require("./pipelines_json_configurations_logic");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/enterprise_search_content/components/search_index/pipelines/pipeline_json_badges.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ManagedPipelineBadge = () => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  position: "top",
  content: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.tabs.jsonConfigurations.managed.description', {
    defaultMessage: 'This pipeline is managed and cannot be edited'
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 24,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
  iconType: "lock",
  color: "warning",
  tabIndex: 0,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 31,
    columnNumber: 5
  }
}, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.tabs.jsonConfigurations.managed', {
  defaultMessage: 'Managed'
})));
const UnmanagedPipelineBadge = () => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  position: "top",
  content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.content.indices.pipelines.tabs.jsonConfigurations.unmanaged.description",
    defaultMessage: "Edit this pipeline from {ingestPipelines} in Stack Management",
    values: {
      ingestPipelines: /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 49,
          columnNumber: 13
        }
      }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.tabs.jsonConfigurations.ingestPipelines', {
        defaultMessage: 'Ingest Pipelines'
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 7
    }
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 41,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
  iconType: "lockOpen",
  tabIndex: 0,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 60,
    columnNumber: 5
  }
}, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.tabs.jsonConfigurations.unmanaged', {
  defaultMessage: 'Unmanaged'
})));
const SharedPipelineBadge = () => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  position: "top",
  content: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.tabs.jsonConfigurations.shared.description', {
    defaultMessage: 'This pipeline is shared across all Search ingestion methods'
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 70,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
  iconType: "logstashIf",
  color: "hollow",
  tabIndex: 0,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 77,
    columnNumber: 5
  }
}, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.tabs.jsonConfigurations.shared', {
  defaultMessage: 'Shared'
})));
const IndexPipelineBadge = () => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  position: "top",
  content: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.tabs.jsonConfigurations.indexSpecific.description', {
    defaultMessage: 'This pipeline contains configurations specific to this index only'
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 87,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
  iconType: "document",
  color: "hollow",
  tabIndex: 0,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 94,
    columnNumber: 5
  }
}, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.tabs.jsonConfigurations.indexSpecific', {
  defaultMessage: 'Index specific'
})));
const MlInferenceBadge = () => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  position: "top",
  content: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.tabs.jsonConfigurations.mlInference.description', {
    defaultMessage: 'This pipeline references one or more ML Inference Pipelines for this index'
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 104,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
  iconType: "compute",
  color: "hollow",
  tabIndex: 0,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 114,
    columnNumber: 5
  }
}, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.tabs.jsonConfigurations.mlInference', {
  defaultMessage: 'ML Inference'
})));
const PipelineJSONBadges = () => {
  const {
    indexName,
    selectedPipeline: pipeline,
    selectedPipelineId: pipelineName
  } = (0, _kea.useValues)(_pipelines_json_configurations_logic.IndexPipelinesConfigurationsLogic);
  if (!pipeline) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }
  const badges = [];
  if ((0, _is_managed.isManagedPipeline)(pipeline)) {
    badges.push(/*#__PURE__*/_react.default.createElement(ManagedPipelineBadge, {
      key: "managed-pipeline",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 134,
        columnNumber: 17
      }
    }));
  } else {
    badges.push(/*#__PURE__*/_react.default.createElement(UnmanagedPipelineBadge, {
      key: "unmanaged-pipeline",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 136,
        columnNumber: 17
      }
    }));
  }
  if (pipelineName === _constants.DEFAULT_PIPELINE_NAME) {
    badges.push(/*#__PURE__*/_react.default.createElement(SharedPipelineBadge, {
      key: "shared-pipeline",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 17
      }
    }));
  }
  if (pipelineName !== null && pipelineName !== void 0 && pipelineName.endsWith('@ml-inference')) {
    badges.push(/*#__PURE__*/_react.default.createElement(MlInferenceBadge, {
      key: "inference-pipeline",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 142,
        columnNumber: 17
      }
    }));
  } else if (pipelineName !== null && pipelineName !== void 0 && pipelineName.includes(indexName)) {
    badges.push(/*#__PURE__*/_react.default.createElement(IndexPipelineBadge, {
      key: "index-pipeline",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 144,
        columnNumber: 17
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadgeGroup, {
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 10
    }
  }, badges);
};
exports.PipelineJSONBadges = PipelineJSONBadges;