"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUserProfile = void 0;
var _reactQuery = require("@kbn/react-query");
var _typed_kibana_context = require("../../context/typed_kibana_context/typed_kibana_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useUserProfile = ({
  user
}) => {
  var _user$id, _user$id3;
  const {
    userProfile
  } = (0, _typed_kibana_context.useKibana)().services;
  return (0, _reactQuery.useQuery)({
    queryKey: ['userProfile', (_user$id = user === null || user === void 0 ? void 0 : user.id) !== null && _user$id !== void 0 ? _user$id : ''],
    queryFn: async () => {
      var _user$id2;
      if (!(user !== null && user !== void 0 && user.id)) {
        return [];
      }
      const data = await (userProfile === null || userProfile === void 0 ? void 0 : userProfile.bulkGet({
        uids: new Set([(_user$id2 = user === null || user === void 0 ? void 0 : user.id) !== null && _user$id2 !== void 0 ? _user$id2 : '']),
        dataPath: 'avatar'
      }));
      return data !== null && data !== void 0 ? data : [];
    },
    select: profiles => {
      var _profile$data;
      if (!profiles || !profiles[0]) return null;
      const profile = profiles[0];
      return {
        ...profile,
        avatar: (_profile$data = profile.data) === null || _profile$data === void 0 ? void 0 : _profile$data.avatar
      };
    },
    enabled: !!(user !== null && user !== void 0 && (_user$id3 = user.id) !== null && _user$id3 !== void 0 && _user$id3.length)
  });
};
exports.useUserProfile = useUserProfile;