"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelectOption = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/elastic_assistant/public/src/components/get_comments/typed_interrupt/typed_interrupts/select_option.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SelectOption = ({
  interrupt,
  resumeGraph,
  resumedValue: initialResumeValue,
  isLastInConversation
}) => {
  var _interrupt$options2;
  const [resumeValue, setResumeValue] = _react.default.useState(initialResumeValue);
  const handleOnSelect = value => {
    const newResumeValue = {
      type: 'SELECT_OPTION',
      value
    };
    setResumeValue(newResumeValue);
    resumeGraph(interrupt.threadId, newResumeValue);
  };
  const disabled = resumeValue !== undefined || interrupt.expired === true || !isLastInConversation;
  const getOutcome = () => {
    var _interrupt$options$fi, _interrupt$options, _interrupt$options$fi2;
    switch (true) {
      case isLastInConversation === false && resumeValue === undefined:
      case interrupt.expired:
        return 'Expired';
      case resumeValue === undefined:
        return undefined;
      case resumeValue !== undefined:
        return (_interrupt$options$fi = (_interrupt$options = interrupt.options) === null || _interrupt$options === void 0 ? void 0 : (_interrupt$options$fi2 = _interrupt$options.find(option => option.value === resumeValue.value)) === null || _interrupt$options$fi2 === void 0 ? void 0 : _interrupt$options$fi2.label) !== null && _interrupt$options$fi !== void 0 ? _interrupt$options$fi : 'Actioned';
    }
  };
  const outcome = getOutcome();
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "select-option-interrupt",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }, interrupt.description), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "s",
    alignItems: "center",
    justifyContent: "flexStart",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  }, (_interrupt$options2 = interrupt.options) === null || _interrupt$options2 === void 0 ? void 0 : _interrupt$options2.map(option => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: option.value,
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: option.buttonColor,
      size: "s",
      onClick: () => handleOnSelect(option.value),
      disabled: disabled,
      "data-test-subj": `select-option-${option.value}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 15
      }
    }, option.label));
  }), outcome && /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 21
    }
  }, outcome)));
};
exports.SelectOption = SelectOption;