"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Query = exports.IntervalApiSchedule = exports.Filters = exports.AttackDiscoveryApiScheduleUpdateProps = exports.AttackDiscoveryApiScheduleSystemAction = exports.AttackDiscoveryApiScheduleParams = exports.AttackDiscoveryApiScheduleGeneralAction = exports.AttackDiscoveryApiScheduleExecutionStatusEnum = exports.AttackDiscoveryApiScheduleExecutionStatus = exports.AttackDiscoveryApiScheduleExecution = exports.AttackDiscoveryApiScheduleCreateProps = exports.AttackDiscoveryApiScheduleActionThrottle = exports.AttackDiscoveryApiScheduleActionParams = exports.AttackDiscoveryApiScheduleActionNotifyWhenEnum = exports.AttackDiscoveryApiScheduleActionNotifyWhen = exports.AttackDiscoveryApiScheduleActionId = exports.AttackDiscoveryApiScheduleActionGroup = exports.AttackDiscoveryApiScheduleActionFrequency = exports.AttackDiscoveryApiScheduleActionAlertsFilter = exports.AttackDiscoveryApiScheduleAction = exports.AttackDiscoveryApiSchedule = void 0;
var _zod = require("@kbn/zod");
var _common_attributes = require("../../../../conversations/common_attributes.gen");
var _common_attributes2 = require("../../../../common_attributes.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Common Attack Discovery Schedule Types (API)
 *   version: not applicable
 */

/**
 * An query condition to filter alerts
 */

const Query = exports.Query = _zod.z.object({
  query: _zod.z.union([_zod.z.string(), _zod.z.object({}).catchall(_zod.z.unknown())]),
  language: _zod.z.string()
});

/**
 * The filter array used to define the conditions for when alerts are selected as an attack discovery context. Defaults to an empty array.
 */

const Filters = exports.Filters = _zod.z.array(_zod.z.unknown());

/**
 * An attack discovery schedule params
 */

const AttackDiscoveryApiScheduleParams = exports.AttackDiscoveryApiScheduleParams = _zod.z.object({
  /**
   * The index pattern to get alerts from
   */
  alerts_index_pattern: _zod.z.string(),
  /**
   * LLM API configuration.
   */
  api_config: _common_attributes.ApiConfig.merge(_zod.z.object({
    /**
     * The name of the connector
     */
    name: _zod.z.string()
  })),
  end: _zod.z.string().optional(),
  query: Query.optional(),
  filters: Filters.optional(),
  combined_filter: _zod.z.object({}).catchall(_zod.z.unknown()).optional(),
  size: _zod.z.number(),
  start: _zod.z.string().optional()
});
const IntervalApiSchedule = exports.IntervalApiSchedule = _zod.z.object({
  /**
   * The schedule interval
   */
  interval: _zod.z.string()
});

/**
 * Groups actions by use cases. Use `default` for alert notifications.
 */

const AttackDiscoveryApiScheduleActionGroup = exports.AttackDiscoveryApiScheduleActionGroup = _zod.z.string();

/**
 * The connector ID.
 */

const AttackDiscoveryApiScheduleActionId = exports.AttackDiscoveryApiScheduleActionId = _zod.z.string();

/**
 * Object containing the allowed connector fields, which varies according to the connector type.
 */

const AttackDiscoveryApiScheduleActionParams = exports.AttackDiscoveryApiScheduleActionParams = _zod.z.object({}).catchall(_zod.z.unknown());
const AttackDiscoveryApiScheduleActionAlertsFilter = exports.AttackDiscoveryApiScheduleActionAlertsFilter = _zod.z.object({}).catchall(_zod.z.unknown());

/**
 * The condition for throttling the notification: `onActionGroupChange`, `onActiveAlert`,  or `onThrottleInterval`
 */

const AttackDiscoveryApiScheduleActionNotifyWhen = exports.AttackDiscoveryApiScheduleActionNotifyWhen = _zod.z.enum(['onActiveAlert', 'onThrottleInterval', 'onActionGroupChange']);
const AttackDiscoveryApiScheduleActionNotifyWhenEnum = exports.AttackDiscoveryApiScheduleActionNotifyWhenEnum = AttackDiscoveryApiScheduleActionNotifyWhen.enum;

/**
 * Defines how often schedule actions are taken. Time interval in seconds, minutes, hours, or days.
 */

const AttackDiscoveryApiScheduleActionThrottle = exports.AttackDiscoveryApiScheduleActionThrottle = _zod.z.string().regex(/^[1-9]\d*[smhd]$/);

/**
 * The action frequency defines when the action runs (for example, only on schedule execution or at specific time intervals).
 */

const AttackDiscoveryApiScheduleActionFrequency = exports.AttackDiscoveryApiScheduleActionFrequency = _zod.z.object({
  /**
   * Action summary indicates whether we will send a summary notification about all the generate alerts or notification per individual alert
   */
  summary: _zod.z.boolean(),
  notify_when: AttackDiscoveryApiScheduleActionNotifyWhen,
  throttle: AttackDiscoveryApiScheduleActionThrottle.nullable()
});
const AttackDiscoveryApiScheduleGeneralAction = exports.AttackDiscoveryApiScheduleGeneralAction = _zod.z.object({
  /**
   * The action type used for sending notifications.
   */
  action_type_id: _zod.z.string(),
  group: AttackDiscoveryApiScheduleActionGroup,
  id: AttackDiscoveryApiScheduleActionId,
  params: AttackDiscoveryApiScheduleActionParams,
  uuid: _common_attributes2.NonEmptyString.optional(),
  alerts_filter: AttackDiscoveryApiScheduleActionAlertsFilter.optional(),
  frequency: AttackDiscoveryApiScheduleActionFrequency.optional()
});
const AttackDiscoveryApiScheduleSystemAction = exports.AttackDiscoveryApiScheduleSystemAction = _zod.z.object({
  /**
   * The action type used for sending notifications.
   */
  action_type_id: _zod.z.string(),
  id: AttackDiscoveryApiScheduleActionId,
  params: AttackDiscoveryApiScheduleActionParams,
  uuid: _common_attributes2.NonEmptyString.optional()
});
const AttackDiscoveryApiScheduleAction = exports.AttackDiscoveryApiScheduleAction = _zod.z.union([AttackDiscoveryApiScheduleGeneralAction, AttackDiscoveryApiScheduleSystemAction]);

/**
 * An attack discovery schedule execution status
 */

const AttackDiscoveryApiScheduleExecutionStatus = exports.AttackDiscoveryApiScheduleExecutionStatus = _zod.z.enum(['ok', 'active', 'error', 'unknown', 'warning']);
const AttackDiscoveryApiScheduleExecutionStatusEnum = exports.AttackDiscoveryApiScheduleExecutionStatusEnum = AttackDiscoveryApiScheduleExecutionStatus.enum;

/**
 * An attack discovery schedule execution information
 */

const AttackDiscoveryApiScheduleExecution = exports.AttackDiscoveryApiScheduleExecution = _zod.z.object({
  /**
   * Date of the execution
   */
  date: _zod.z.string().datetime(),
  /**
   * Duration of the execution
   */
  duration: _zod.z.number().optional(),
  /**
   * Status of the execution
   */
  status: AttackDiscoveryApiScheduleExecutionStatus,
  message: _zod.z.string().optional()
});

/**
 * An attack discovery schedule
 */

const AttackDiscoveryApiSchedule = exports.AttackDiscoveryApiSchedule = _zod.z.object({
  /**
   * UUID of attack discovery schedule
   */
  id: _zod.z.string(),
  /**
   * The name of the schedule
   */
  name: _zod.z.string(),
  /**
   * The name of the user that created the schedule
   */
  created_by: _zod.z.string(),
  /**
   * The name of the user that updated the schedule
   */
  updated_by: _zod.z.string(),
  /**
   * The date the schedule was created
   */
  created_at: _zod.z.string().datetime(),
  /**
   * The date the schedule was updated
   */
  updated_at: _zod.z.string().datetime(),
  /**
   * Indicates whether the schedule is enabled
   */
  enabled: _zod.z.boolean(),
  /**
   * The attack discovery schedule configuration parameters
   */
  params: AttackDiscoveryApiScheduleParams,
  /**
   * The attack discovery schedule interval
   */
  schedule: IntervalApiSchedule,
  /**
   * The attack discovery schedule actions
   */
  actions: _zod.z.array(AttackDiscoveryApiScheduleAction),
  /**
   * The attack discovery schedule last execution summary
   */
  last_execution: AttackDiscoveryApiScheduleExecution.optional()
});

/**
 * An attack discovery schedule create properties
 */

const AttackDiscoveryApiScheduleCreateProps = exports.AttackDiscoveryApiScheduleCreateProps = _zod.z.object({
  /**
   * The name of the schedule
   */
  name: _zod.z.string(),
  /**
   * Indicates whether the schedule is enabled
   */
  enabled: _zod.z.boolean().optional(),
  /**
   * The attack discovery schedule configuration parameters
   */
  params: AttackDiscoveryApiScheduleParams,
  /**
   * The attack discovery schedule interval
   */
  schedule: IntervalApiSchedule,
  /**
   * The attack discovery schedule actions
   */
  actions: _zod.z.array(AttackDiscoveryApiScheduleAction).optional()
});

/**
 * An attack discovery schedule update properties
 */

const AttackDiscoveryApiScheduleUpdateProps = exports.AttackDiscoveryApiScheduleUpdateProps = _zod.z.object({
  /**
   * The name of the schedule
   */
  name: _zod.z.string(),
  /**
   * The attack discovery schedule configuration parameters
   */
  params: AttackDiscoveryApiScheduleParams,
  /**
   * The attack discovery schedule interval
   */
  schedule: IntervalApiSchedule,
  /**
   * The attack discovery schedule actions
   */
  actions: _zod.z.array(AttackDiscoveryApiScheduleAction)
});