"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.USER_AGENT_VERSION_FIELD = exports.USER_AGENT_NAME_FIELD = exports.TRANSACTION_TYPE_FIELD = exports.TRANSACTION_NAME_FIELD = exports.TRANSACTION_ID_FIELD = exports.TRANSACTION_DURATION_FIELD = exports.TRACE_ID_FIELD = exports.TIMESTAMP_FIELD = exports.SPAN_TYPE_FIELD = exports.SPAN_SUBTYPE_FIELD = exports.SPAN_NAME_FIELD = exports.SPAN_LINKS_TRACE_ID = exports.SPAN_LINKS_SPAN_ID = exports.SPAN_ID_FIELD = exports.SPAN_DURATION_FIELD = exports.SPAN_DESTINATION_SERVICE_RESOURCE_FIELD = exports.SPAN_ACTION_FIELD = exports.SERVICE_NAME_FIELD = exports.SERVICE_ENVIRONMENT_FIELD = exports.PROCESSOR_EVENT_FIELD = exports.PARENT_ID_FIELD = exports.OTEL_STATUS_CODE = exports.OTEL_SPAN_KIND = exports.OTEL_RESOURCE_ATTRIBUTES_TELEMETRY_SDK_LANGUAGE = exports.OTEL_LINKS_TRACE_ID = exports.OTEL_LINKS_SPAN_ID = exports.OTEL_EVENT_NAME_FIELD = exports.OTEL_DURATION = exports.OTEL_ATTRIBUTES_EXCEPTION_STACKTRACE = exports.OTEL_ATTRIBUTES_EXCEPTION_MESSAGE = exports.ORCHESTRATOR_RESOURCE_ID_FIELD = exports.ORCHESTRATOR_NAMESPACE_FIELD = exports.ORCHESTRATOR_CLUSTER_NAME_FIELD = exports.ORCHESTRATOR_CLUSTER_ID_FIELD = exports.MESSAGE_FIELD = exports.LOG_LEVEL_FIELD = exports.LOG_FILE_PATH_FIELD = exports.INDEX_FIELD = exports.IGNORED_FIELD_VALUES_FIELD = exports.IGNORED_FIELD = exports.HTTP_RESPONSE_STATUS_CODE_FIELD = exports.HOST_NAME_FIELD = exports.EXCEPTION_MESSAGE_FIELD = exports.EVENT_OUTCOME_FIELD = exports.EVENT_ORIGINAL_FIELD = exports.EVENT_CATEGORY_FIELD = exports.ERROR_STACK_TRACE = exports.ERROR_MESSAGE_FIELD = exports.ERROR_LOG_STACKTRACE_ABS_PATH = exports.ERROR_LOG_LEVEL_FIELD = exports.ERROR_EXCEPTION_STACKTRACE_ABS_PATH = exports.ERROR_EXCEPTION_MESSAGE = exports.DEGRADED_DOCS_FIELDS = exports.DATASTREAM_TYPE_FIELD = exports.DATASTREAM_NAMESPACE_FIELD = exports.DATASTREAM_DATASET_FIELD = exports.CONTAINER_NAME_FIELD = exports.CONTAINER_ID_FIELD = exports.CLOUD_REGION_FIELD = exports.CLOUD_PROVIDER_FIELD = exports.CLOUD_PROJECT_ID_FIELD = exports.CLOUD_INSTANCE_ID_FIELD = exports.CLOUD_AVAILABILITY_ZONE_FIELD = exports.AGENT_NAME_FIELD = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// Fields constants
const TIMESTAMP_FIELD = exports.TIMESTAMP_FIELD = '@timestamp';
const HOST_NAME_FIELD = exports.HOST_NAME_FIELD = 'host.name';
const LOG_LEVEL_FIELD = exports.LOG_LEVEL_FIELD = 'log.level';
const ERROR_LOG_LEVEL_FIELD = exports.ERROR_LOG_LEVEL_FIELD = 'error.log.level';
const MESSAGE_FIELD = exports.MESSAGE_FIELD = 'message';
const EXCEPTION_MESSAGE_FIELD = exports.EXCEPTION_MESSAGE_FIELD = 'exception.message';
const ERROR_MESSAGE_FIELD = exports.ERROR_MESSAGE_FIELD = 'error.message';
const EVENT_ORIGINAL_FIELD = exports.EVENT_ORIGINAL_FIELD = 'event.original';
const EVENT_OUTCOME_FIELD = exports.EVENT_OUTCOME_FIELD = 'event.outcome';
const INDEX_FIELD = exports.INDEX_FIELD = '_index';
const EVENT_CATEGORY_FIELD = exports.EVENT_CATEGORY_FIELD = 'event.category';

// Trace fields
const TRACE_ID_FIELD = exports.TRACE_ID_FIELD = 'trace.id';
const PARENT_ID_FIELD = exports.PARENT_ID_FIELD = 'parent.id';
const TRANSACTION_ID_FIELD = exports.TRANSACTION_ID_FIELD = 'transaction.id';
const TRANSACTION_TYPE_FIELD = exports.TRANSACTION_TYPE_FIELD = 'transaction.type';
const TRANSACTION_NAME_FIELD = exports.TRANSACTION_NAME_FIELD = 'transaction.name';
const TRANSACTION_DURATION_FIELD = exports.TRANSACTION_DURATION_FIELD = 'transaction.duration.us';
const SPAN_NAME_FIELD = exports.SPAN_NAME_FIELD = 'span.name';
const SPAN_ID_FIELD = exports.SPAN_ID_FIELD = 'span.id';
const SPAN_ACTION_FIELD = exports.SPAN_ACTION_FIELD = 'span.action';
const SPAN_DURATION_FIELD = exports.SPAN_DURATION_FIELD = 'span.duration.us';
const SPAN_TYPE_FIELD = exports.SPAN_TYPE_FIELD = 'span.type';
const SPAN_SUBTYPE_FIELD = exports.SPAN_SUBTYPE_FIELD = 'span.subtype';
const SPAN_DESTINATION_SERVICE_RESOURCE_FIELD = exports.SPAN_DESTINATION_SERVICE_RESOURCE_FIELD = 'span.destination.service.resource';
const PROCESSOR_EVENT_FIELD = exports.PROCESSOR_EVENT_FIELD = 'processor.event';
const OTEL_SPAN_KIND = exports.OTEL_SPAN_KIND = 'kind';
const OTEL_DURATION = exports.OTEL_DURATION = 'duration';
const OTEL_STATUS_CODE = exports.OTEL_STATUS_CODE = 'status.code';
const OTEL_RESOURCE_ATTRIBUTES_TELEMETRY_SDK_LANGUAGE = exports.OTEL_RESOURCE_ATTRIBUTES_TELEMETRY_SDK_LANGUAGE = 'resource.attributes.telemetry.sdk.language';
const OTEL_ATTRIBUTES_EXCEPTION_MESSAGE = exports.OTEL_ATTRIBUTES_EXCEPTION_MESSAGE = 'attributes.exception.message';
const OTEL_ATTRIBUTES_EXCEPTION_STACKTRACE = exports.OTEL_ATTRIBUTES_EXCEPTION_STACKTRACE = 'attributes.exception.stacktrace';
const OTEL_EVENT_NAME_FIELD = exports.OTEL_EVENT_NAME_FIELD = 'event_name';
const LOG_FILE_PATH_FIELD = exports.LOG_FILE_PATH_FIELD = 'log.file.path';
const DATASTREAM_NAMESPACE_FIELD = exports.DATASTREAM_NAMESPACE_FIELD = 'data_stream.namespace';
const DATASTREAM_DATASET_FIELD = exports.DATASTREAM_DATASET_FIELD = 'data_stream.dataset';
const DATASTREAM_TYPE_FIELD = exports.DATASTREAM_TYPE_FIELD = 'data_stream.type';
const OTEL_LINKS_TRACE_ID = exports.OTEL_LINKS_TRACE_ID = 'links.trace_id';
const OTEL_LINKS_SPAN_ID = exports.OTEL_LINKS_SPAN_ID = 'links.span_id';
const SPAN_LINKS_TRACE_ID = exports.SPAN_LINKS_TRACE_ID = 'span.links.trace.id';
const SPAN_LINKS_SPAN_ID = exports.SPAN_LINKS_SPAN_ID = 'span.links.span.id';

// Resource Fields
const AGENT_NAME_FIELD = exports.AGENT_NAME_FIELD = 'agent.name';
const CLOUD_PROVIDER_FIELD = exports.CLOUD_PROVIDER_FIELD = 'cloud.provider';
const CLOUD_REGION_FIELD = exports.CLOUD_REGION_FIELD = 'cloud.region';
const CLOUD_AVAILABILITY_ZONE_FIELD = exports.CLOUD_AVAILABILITY_ZONE_FIELD = 'cloud.availability_zone';
const CLOUD_PROJECT_ID_FIELD = exports.CLOUD_PROJECT_ID_FIELD = 'cloud.project.id';
const CLOUD_INSTANCE_ID_FIELD = exports.CLOUD_INSTANCE_ID_FIELD = 'cloud.instance.id';
const SERVICE_NAME_FIELD = exports.SERVICE_NAME_FIELD = 'service.name';
const SERVICE_ENVIRONMENT_FIELD = exports.SERVICE_ENVIRONMENT_FIELD = 'service.environment';
const ORCHESTRATOR_CLUSTER_NAME_FIELD = exports.ORCHESTRATOR_CLUSTER_NAME_FIELD = 'orchestrator.cluster.name';
const ORCHESTRATOR_CLUSTER_ID_FIELD = exports.ORCHESTRATOR_CLUSTER_ID_FIELD = 'orchestrator.cluster.id';
const ORCHESTRATOR_RESOURCE_ID_FIELD = exports.ORCHESTRATOR_RESOURCE_ID_FIELD = 'orchestrator.resource.id';
const ORCHESTRATOR_NAMESPACE_FIELD = exports.ORCHESTRATOR_NAMESPACE_FIELD = 'orchestrator.namespace';
const CONTAINER_NAME_FIELD = exports.CONTAINER_NAME_FIELD = 'container.name';
const CONTAINER_ID_FIELD = exports.CONTAINER_ID_FIELD = 'container.id';
const USER_AGENT_NAME_FIELD = exports.USER_AGENT_NAME_FIELD = 'user_agent.name';
const USER_AGENT_VERSION_FIELD = exports.USER_AGENT_VERSION_FIELD = 'user_agent.version';
const HTTP_RESPONSE_STATUS_CODE_FIELD = exports.HTTP_RESPONSE_STATUS_CODE_FIELD = 'http.response.status_code';

// Degraded Docs
const IGNORED_FIELD = exports.IGNORED_FIELD = '_ignored';
const IGNORED_FIELD_VALUES_FIELD = exports.IGNORED_FIELD_VALUES_FIELD = 'ignored_field_values';
const DEGRADED_DOCS_FIELDS = exports.DEGRADED_DOCS_FIELDS = [IGNORED_FIELD, IGNORED_FIELD_VALUES_FIELD];

// Error Stacktrace
const ERROR_STACK_TRACE = exports.ERROR_STACK_TRACE = 'error.stack_trace';
const ERROR_EXCEPTION_MESSAGE = exports.ERROR_EXCEPTION_MESSAGE = 'error.exception.message';
const ERROR_EXCEPTION_STACKTRACE_ABS_PATH = exports.ERROR_EXCEPTION_STACKTRACE_ABS_PATH = 'error.exception.stacktrace.abs_path';
const ERROR_LOG_STACKTRACE_ABS_PATH = exports.ERROR_LOG_STACKTRACE_ABS_PATH = 'error.log.stacktrace.abs_path';