"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDiscoverHistogram = void 0;
var _unifiedHistogram = require("@kbn/unified-histogram");
var _lodash = require("lodash");
var _react = require("react");
var _rxjs = require("rxjs");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _esQuery = require("@kbn/es-query");
var _common = require("@kbn/data-plugin/common");
var _context_awareness = require("../../../../context_awareness");
var _customizations = require("../../../../customizations");
var _use_discover_services = require("../../../../hooks/use_discover_services");
var _types = require("../../../types");
var _use_saved_search_messages = require("../../hooks/use_saved_search_messages");
var _add_log = require("../../../../utils/add_log");
var _discover_app_state_container = require("../../state_management/discover_app_state_container");
var _discover_state_provider = require("../../state_management/discover_state_provider");
var _use_is_esql_mode = require("../../hooks/use_is_esql_mode");
var _redux = require("../../state_management/redux");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const EMPTY_ESQL_COLUMNS = [];
const EMPTY_FILTERS = [];
const useDiscoverHistogram = (stateContainer, options) => {
  var _options$initialLayou;
  const services = (0, _use_discover_services.useDiscoverServices)();
  const {
    data$: {
      main$,
      documents$,
      totalHits$
    },
    inspectorAdapters,
    getAbortController
  } = stateContainer.dataState;
  const savedSearchState = (0, _discover_state_provider.useSavedSearch)();
  const isEsqlMode = (0, _use_is_esql_mode.useIsEsqlMode)();

  /**
   * API initialization
   */

  const [unifiedHistogramApi, setUnifiedHistogramApi] = (0, _react.useState)();
  const [isSuggestionLoading, setIsSuggestionLoading] = (0, _react.useState)(false);

  /**
   * Sync Unified Histogram state with Discover state
   */

  (0, _react.useEffect)(() => {
    var _createUnifiedHistogr;
    const subscription = (_createUnifiedHistogr = createUnifiedHistogramStateObservable(unifiedHistogramApi === null || unifiedHistogramApi === void 0 ? void 0 : unifiedHistogramApi.state$)) === null || _createUnifiedHistogr === void 0 ? void 0 : _createUnifiedHistogr.subscribe(changes => {
      const {
        lensRequestAdapter,
        ...stateChanges
      } = changes;
      const appState = stateContainer.appState.get();
      const oldState = {
        hideChart: appState.hideChart,
        interval: appState.interval
      };
      const newState = {
        ...oldState,
        ...stateChanges
      };
      if ('lensRequestAdapter' in changes) {
        inspectorAdapters.lensRequests = lensRequestAdapter;
      }
      if (!(0, _lodash.isEqual)(oldState, newState)) {
        stateContainer.appState.update(newState);
      }
    });
    return () => {
      subscription === null || subscription === void 0 ? void 0 : subscription.unsubscribe();
    };
  }, [inspectorAdapters, stateContainer.appState, unifiedHistogramApi === null || unifiedHistogramApi === void 0 ? void 0 : unifiedHistogramApi.state$]);

  /**
   * Sync URL query params with Unified Histogram
   */

  (0, _react.useEffect)(() => {
    const subscription = createAppStateObservable(stateContainer.appState.state$).subscribe(changes => {
      if ('timeInterval' in changes && changes.timeInterval) {
        unifiedHistogramApi === null || unifiedHistogramApi === void 0 ? void 0 : unifiedHistogramApi.setTimeInterval(changes.timeInterval);
      }
      if ('chartHidden' in changes && typeof changes.chartHidden === 'boolean') {
        unifiedHistogramApi === null || unifiedHistogramApi === void 0 ? void 0 : unifiedHistogramApi.setChartHidden(changes.chartHidden);
      }
    });
    return () => {
      subscription === null || subscription === void 0 ? void 0 : subscription.unsubscribe();
    };
  }, [stateContainer.appState.state$, unifiedHistogramApi]);

  /**
   * Total hits
   */

  const setTotalHitsError = (0, _react.useMemo)(() => (0, _use_saved_search_messages.sendErrorTo)(totalHits$), [totalHits$]);
  (0, _react.useEffect)(() => {
    var _createTotalHitsObser;
    const subscription = (_createTotalHitsObser = createTotalHitsObservable(unifiedHistogramApi === null || unifiedHistogramApi === void 0 ? void 0 : unifiedHistogramApi.state$)) === null || _createTotalHitsObser === void 0 ? void 0 : _createTotalHitsObser.subscribe(({
      status,
      result
    }) => {
      if (isEsqlMode) {
        // ignore histogram's total hits updates for ES|QL as Discover manages them during docs fetching
        return;
      }
      if (result instanceof Error) {
        // Set totalHits$ to an error state
        setTotalHitsError(result);
        return;
      }
      const {
        result: totalHitsResult
      } = totalHits$.getValue();
      if ((status === _unifiedHistogram.UnifiedHistogramFetchStatus.loading || status === _unifiedHistogram.UnifiedHistogramFetchStatus.uninitialized) && totalHitsResult && typeof result !== 'number') {
        // ignore the histogram initial loading state if discover state already has a total hits value
        return;
      }
      const fetchStatus = status.toString();

      // Do not sync the loading state since it's already handled by fetchAll
      if (fetchStatus !== _types.FetchStatus.LOADING) {
        totalHits$.next({
          fetchStatus,
          result
        });
      }
      if (status !== _unifiedHistogram.UnifiedHistogramFetchStatus.complete || typeof result !== 'number') {
        return;
      }

      // Check the hits count to set a partial or no results state
      (0, _use_saved_search_messages.checkHitCount)(main$, result);
    });
    return () => {
      subscription === null || subscription === void 0 ? void 0 : subscription.unsubscribe();
    };
  }, [isEsqlMode, main$, totalHits$, setTotalHitsError, stateContainer.appState, unifiedHistogramApi === null || unifiedHistogramApi === void 0 ? void 0 : unifiedHistogramApi.state$]);

  /**
   * Request params
   */
  const requestParams = (0, _redux.useCurrentTabSelector)(state => state.dataRequestParams);
  const currentTabControlState = (0, _redux.useCurrentTabSelector)(tab => tab.controlGroupState);
  const {
    timeRangeRelative: relativeTimeRange,
    timeRangeAbsolute: timeRange,
    searchSessionId,
    lastReloadRequestTime
  } = requestParams;
  // When in ES|QL mode, update the data view, query, and
  // columns only when documents are done fetching so the Lens suggestions
  // don't frequently change, such as when the user modifies the table
  // columns, which would trigger unnecessary refetches.
  const esqlFetchComplete$ = (0, _react.useMemo)(() => createFetchCompleteObservable(stateContainer), [stateContainer]);
  const [initialEsqlProps] = (0, _react.useState)(() => getUnifiedHistogramPropsForEsql({
    documentsValue: documents$.getValue(),
    savedSearch: stateContainer.savedSearchState.getState()
  }));
  const {
    dataView: esqlDataView,
    query: esqlQuery,
    columns: esqlColumns,
    table
  } = (0, _useObservable.default)(esqlFetchComplete$, initialEsqlProps);
  (0, _react.useEffect)(() => {
    if (!isEsqlMode) {
      setIsSuggestionLoading(false);
      return;
    }
    const fetchStart = stateContainer.dataState.fetchChart$.subscribe(() => {
      setIsSuggestionLoading(true);
    });
    const fetchComplete = esqlFetchComplete$.subscribe(() => {
      setIsSuggestionLoading(false);
    });
    return () => {
      fetchStart.unsubscribe();
      fetchComplete.unsubscribe();
    };
  }, [isEsqlMode, stateContainer.dataState.fetchChart$, esqlFetchComplete$]);

  /**
   * Data fetching
   */

  // Handle unified histogram refetching
  (0, _react.useEffect)(() => {
    if (!unifiedHistogramApi) {
      return;
    }
    let fetchChart$;

    // When in ES|QL mode, we refetch under two conditions:
    // 1. When the current Lens suggestion changes. This syncs the visualization
    //    with the user's selection.
    // 2. When the documents are done fetching. This is necessary because we don't
    //    have access to the latest columns until after the documents are fetched,
    //    which are required to get the latest Lens suggestion, which would trigger
    //    a refetch anyway and result in multiple unnecessary fetches.
    if (isEsqlMode) {
      fetchChart$ = (0, _rxjs.merge)(createCurrentSuggestionObservable(unifiedHistogramApi.state$).pipe((0, _rxjs.map)(() => 'lens')), esqlFetchComplete$.pipe((0, _rxjs.map)(() => 'discover'))).pipe((0, _rxjs.debounceTime)(50));
    } else {
      fetchChart$ = stateContainer.dataState.fetchChart$.pipe((0, _rxjs.map)(() => 'discover'));
    }
    const subscription = fetchChart$.subscribe(source => {
      if (source === 'discover') (0, _add_log.addLog)('Unified Histogram - Discover refetch');
      if (source === 'lens') (0, _add_log.addLog)('Unified Histogram - Lens suggestion refetch');
      unifiedHistogramApi.fetch();
    });
    return () => {
      subscription.unsubscribe();
    };
  }, [isEsqlMode, stateContainer.dataState.fetchChart$, esqlFetchComplete$, unifiedHistogramApi]);
  const dataView = (0, _redux.useCurrentDataView)();
  const histogramCustomization = (0, _customizations.useDiscoverCustomization)('unified_histogram');
  const query = (0, _discover_app_state_container.useAppStateSelector)(state => state.query);
  const appFilters = (0, _discover_app_state_container.useAppStateSelector)(state => state.filters);
  const {
    filters: globalFilters
  } = (0, _redux.useCurrentTabSelector)(state => state.globalState);
  const filtersMemoized = (0, _react.useMemo)(() => {
    const allFilters = [...(globalFilters !== null && globalFilters !== void 0 ? globalFilters : []), ...(appFilters !== null && appFilters !== void 0 ? appFilters : [])];
    return allFilters.length ? allFilters : EMPTY_FILTERS;
  }, [appFilters, globalFilters]);

  // eslint-disable-next-line react-hooks/exhaustive-deps
  const timeRangeMemoized = (0, _react.useMemo)(() => timeRange, [timeRange === null || timeRange === void 0 ? void 0 : timeRange.from, timeRange === null || timeRange === void 0 ? void 0 : timeRange.to]);
  const setOverriddenVisContextAfterInvalidation = (0, _redux.useCurrentTabAction)(_redux.internalStateActions.setOverriddenVisContextAfterInvalidation);
  const dispatch = (0, _redux.useInternalStateDispatch)();
  const onVisContextChanged = (0, _react.useCallback)((nextVisContext, externalVisContextStatus) => {
    switch (externalVisContextStatus) {
      case _unifiedHistogram.UnifiedHistogramExternalVisContextStatus.manuallyCustomized:
        // if user customized the visualization manually
        // (only this action should trigger Unsaved changes badge)
        stateContainer.savedSearchState.updateVisContext({
          nextVisContext
        });
        dispatch(setOverriddenVisContextAfterInvalidation({
          overriddenVisContextAfterInvalidation: undefined
        }));
        break;
      case _unifiedHistogram.UnifiedHistogramExternalVisContextStatus.automaticallyOverridden:
        // if the visualization was invalidated as incompatible and rebuilt
        // (it will be used later for saving the visualization via Save button)
        dispatch(setOverriddenVisContextAfterInvalidation({
          overriddenVisContextAfterInvalidation: nextVisContext
        }));
        break;
      case _unifiedHistogram.UnifiedHistogramExternalVisContextStatus.automaticallyCreated:
      case _unifiedHistogram.UnifiedHistogramExternalVisContextStatus.applied:
        // clearing the value in the internal state so we don't use it during saved search saving
        dispatch(setOverriddenVisContextAfterInvalidation({
          overriddenVisContextAfterInvalidation: undefined
        }));
        break;
      case _unifiedHistogram.UnifiedHistogramExternalVisContextStatus.unknown:
        // using `{}` to overwrite the value inside the saved search SO during saving
        dispatch(setOverriddenVisContextAfterInvalidation({
          overriddenVisContextAfterInvalidation: {}
        }));
        break;
    }
  }, [dispatch, setOverriddenVisContextAfterInvalidation, stateContainer.savedSearchState]);
  const getModifiedVisAttributesAccessor = (0, _context_awareness.useProfileAccessor)('getModifiedVisAttributes');
  const getModifiedVisAttributes = (0, _react.useCallback)(attributes => getModifiedVisAttributesAccessor(params => params.attributes)({
    attributes
  }), [getModifiedVisAttributesAccessor]);
  const chartHidden = (0, _discover_app_state_container.useAppStateSelector)(state => state.hideChart);
  const timeInterval = (0, _discover_app_state_container.useAppStateSelector)(state => state.interval);
  const breakdownField = (0, _discover_app_state_container.useAppStateSelector)(state => state.breakdownField);
  const esqlVariables = (0, _redux.useCurrentTabSelector)(tab => tab.esqlVariables);
  const onBreakdownFieldChange = (0, _react.useCallback)(nextBreakdownField => {
    if (nextBreakdownField !== breakdownField) {
      stateContainer.appState.update({
        breakdownField: nextBreakdownField
      });
    }
  }, [breakdownField, stateContainer.appState]);
  return {
    setUnifiedHistogramApi,
    services,
    localStorageKeyPrefix: 'discover',
    requestAdapter: inspectorAdapters.requests,
    abortController: getAbortController(),
    initialState: {
      chartHidden,
      timeInterval,
      topPanelHeight: options === null || options === void 0 ? void 0 : (_options$initialLayou = options.initialLayoutProps) === null || _options$initialLayou === void 0 ? void 0 : _options$initialLayou.topPanelHeight,
      totalHitsStatus: _unifiedHistogram.UnifiedHistogramFetchStatus.loading,
      totalHitsResult: undefined
    },
    dataView: isEsqlMode ? esqlDataView : dataView,
    query: isEsqlMode ? esqlQuery : query,
    filters: isEsqlMode ? EMPTY_FILTERS : filtersMemoized,
    timeRange: timeRangeMemoized,
    relativeTimeRange,
    lastReloadRequestTime,
    columns: isEsqlMode ? esqlColumns : undefined,
    table: isEsqlMode ? table : undefined,
    onFilter: histogramCustomization === null || histogramCustomization === void 0 ? void 0 : histogramCustomization.onFilter,
    onBrushEnd: histogramCustomization === null || histogramCustomization === void 0 ? void 0 : histogramCustomization.onBrushEnd,
    withDefaultActions: histogramCustomization === null || histogramCustomization === void 0 ? void 0 : histogramCustomization.withDefaultActions,
    disabledActions: histogramCustomization === null || histogramCustomization === void 0 ? void 0 : histogramCustomization.disabledActions,
    isChartLoading: isSuggestionLoading,
    // visContext should be in sync with current query
    externalVisContext: isEsqlMode && (0, _unifiedHistogram.canImportVisContext)(savedSearchState === null || savedSearchState === void 0 ? void 0 : savedSearchState.visContext) ? savedSearchState === null || savedSearchState === void 0 ? void 0 : savedSearchState.visContext : undefined,
    onVisContextChanged: isEsqlMode ? onVisContextChanged : undefined,
    breakdownField,
    esqlVariables,
    controlsState: currentTabControlState,
    onBreakdownFieldChange,
    searchSessionId,
    getModifiedVisAttributes
  };
};

// Use pairwise to diff the previous and current state (starting with undefined to ensure
// pairwise triggers after a single emission), and return an object containing only the
// changed properties. By only including the changed properties, we avoid accidentally
// overwriting other state properties that may have been updated between the time this
// obersverable was triggered and the time the state changes are applied.
exports.useDiscoverHistogram = useDiscoverHistogram;
const createUnifiedHistogramStateObservable = state$ => {
  return state$ === null || state$ === void 0 ? void 0 : state$.pipe((0, _rxjs.startWith)(undefined), (0, _rxjs.pairwise)(), (0, _rxjs.map)(([prev, curr]) => {
    const changes = {};
    if (!curr) {
      return changes;
    }
    if ((prev === null || prev === void 0 ? void 0 : prev.lensRequestAdapter) !== curr.lensRequestAdapter) {
      changes.lensRequestAdapter = curr.lensRequestAdapter;
    }
    if ((prev === null || prev === void 0 ? void 0 : prev.chartHidden) !== curr.chartHidden) {
      changes.hideChart = curr.chartHidden;
    }
    if ((prev === null || prev === void 0 ? void 0 : prev.timeInterval) !== curr.timeInterval) {
      changes.interval = curr.timeInterval;
    }
    return changes;
  }), (0, _rxjs.filter)(changes => Object.keys(changes).length > 0));
};
const createAppStateObservable = state$ => {
  return state$.pipe((0, _rxjs.startWith)(undefined), (0, _rxjs.pairwise)(), (0, _rxjs.map)(([prev, curr]) => {
    const changes = {};
    if (!curr) {
      return changes;
    }
    if ((prev === null || prev === void 0 ? void 0 : prev.interval) !== curr.interval) {
      changes.timeInterval = curr.interval;
    }
    if ((prev === null || prev === void 0 ? void 0 : prev.hideChart) !== curr.hideChart) {
      changes.chartHidden = curr.hideChart;
    }
    return changes;
  }), (0, _rxjs.filter)(changes => Object.keys(changes).length > 0));
};
const createFetchCompleteObservable = stateContainer => {
  return stateContainer.dataState.data$.documents$.pipe((0, _rxjs.distinctUntilChanged)((prev, curr) => prev.fetchStatus === curr.fetchStatus), (0, _rxjs.filter)(({
    fetchStatus
  }) => [_types.FetchStatus.COMPLETE, _types.FetchStatus.ERROR].includes(fetchStatus)), (0, _rxjs.filter)(({
    fetchStatus
  }) => {
    var _stateContainer$dataS;
    const isAlreadyAborted = (_stateContainer$dataS = stateContainer.dataState.getAbortController()) === null || _stateContainer$dataS === void 0 ? void 0 : _stateContainer$dataS.signal.aborted;
    // skip updating the histogram props if the fetch was aborted
    // this will prevent the redundant histogram fetching
    return !(fetchStatus === _types.FetchStatus.ERROR && isAlreadyAborted);
  }), (0, _rxjs.map)(documentsValue => {
    return getUnifiedHistogramPropsForEsql({
      documentsValue,
      savedSearch: stateContainer.savedSearchState.getState()
    });
  }));
};
const createTotalHitsObservable = state$ => {
  return state$ === null || state$ === void 0 ? void 0 : state$.pipe((0, _rxjs.map)(state => ({
    status: state.totalHitsStatus,
    result: state.totalHitsResult
  })), (0, _rxjs.distinctUntilChanged)((prev, curr) => prev.status === curr.status && prev.result === curr.result));
};
const createCurrentSuggestionObservable = state$ => {
  return state$.pipe((0, _rxjs.map)(state => state.currentSuggestionContext), (0, _rxjs.distinctUntilChanged)(_lodash.isEqual),
  // Skip the first emission since it's the
  // initial state and doesn't need a refetch
  (0, _rxjs.skip)(1));
};
function getUnifiedHistogramPropsForEsql({
  documentsValue,
  savedSearch
}) {
  const columns = (documentsValue === null || documentsValue === void 0 ? void 0 : documentsValue.esqlQueryColumns) || EMPTY_ESQL_COLUMNS;
  const query = savedSearch.searchSource.getField('query');
  const isEsqlMode = (0, _esQuery.isOfAggregateQueryType)(query);
  const table = isEsqlMode && documentsValue !== null && documentsValue !== void 0 && documentsValue.result ? {
    type: 'datatable',
    rows: documentsValue.result.map(r => r.raw),
    columns,
    meta: {
      type: _common.ESQL_TABLE_TYPE
    }
  } : undefined;
  const nextProps = {
    dataView: savedSearch.searchSource.getField('index'),
    query: savedSearch.searchSource.getField('query'),
    columns,
    table
  };
  (0, _add_log.addLog)('[UnifiedHistogram] delayed next props for ES|QL', nextProps);
  return nextProps;
}