"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNonAggregatableDataStreams = getNonAggregatableDataStreams;
var _boom = require("@hapi/boom");
var _es_fields = require("../../../../common/es_fields");
var _utils = require("../../../utils");
var _queries = require("../../../utils/queries");
var _extract_non_aggregatable_datasets = require("./extract_non_aggregatable_datasets");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getNonAggregatableDataStreams({
  esClient,
  types = [],
  start,
  end,
  dataStream
}) {
  if (types.length === 0 && !dataStream) {
    throw (0, _boom.badRequest)(`Either types or dataStream must be provided.`);
  }
  const datasetQualityESClient = (0, _utils.createDatasetQualityESClient)(esClient);
  const dataStreamTypes = types.map(type => `${type}-*-*`).join(',');
  try {
    var _response$indices, _response$fields$_ign, _response$fields$_ign2, _response$fields$_ign3, _response$fields$_ign4, _response$fields$_ign5, _response$fields$_ign6, _response$fields$_ign7;
    const response = await datasetQualityESClient.fieldCaps({
      index: dataStream !== null && dataStream !== void 0 ? dataStream : dataStreamTypes,
      fields: [_es_fields._IGNORED],
      index_filter: {
        ...(0, _queries.rangeQuery)(start, end)[0]
      }
    });
    const indices = (_response$indices = response === null || response === void 0 ? void 0 : response.indices) !== null && _response$indices !== void 0 ? _response$indices : [];

    // if no indices are returned, it means there are no data streams matching the criteria
    // so we return an empty response - aggregatable is set to true so no error is thrown in the UI
    if (indices.length === 0) {
      return {
        aggregatable: true,
        datasets: []
      };
    }
    const nonAggregatableIndices = (_response$fields$_ign = (_response$fields$_ign2 = response.fields._ignored) === null || _response$fields$_ign2 === void 0 ? void 0 : (_response$fields$_ign3 = _response$fields$_ign2._ignored) === null || _response$fields$_ign3 === void 0 ? void 0 : _response$fields$_ign3.non_aggregatable_indices) !== null && _response$fields$_ign !== void 0 ? _response$fields$_ign : [];
    const datasets = (0, _extract_non_aggregatable_datasets.extractNonAggregatableDatasets)(indices, nonAggregatableIndices);
    // If there are no non_aggregatable_indices, it means that either all indices are either aggregatable or non-aggregatable
    // so we need to check the aggregatable field to determine
    const aggregatable = (_response$fields$_ign4 = response.fields._ignored) !== null && _response$fields$_ign4 !== void 0 && (_response$fields$_ign5 = _response$fields$_ign4._ignored) !== null && _response$fields$_ign5 !== void 0 && _response$fields$_ign5.non_aggregatable_indices ? datasets.length === 0 : Boolean((_response$fields$_ign6 = response.fields._ignored) === null || _response$fields$_ign6 === void 0 ? void 0 : (_response$fields$_ign7 = _response$fields$_ign6._ignored) === null || _response$fields$_ign7 === void 0 ? void 0 : _response$fields$_ign7.aggregatable);
    return {
      aggregatable,
      datasets
    };
  } catch (error) {
    if (error.message.includes('index_closed_exception')) {
      return {
        aggregatable: true,
        datasets: []
      };
    }
    throw error;
  }
}