"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getOrCreateDataViewByIndexPattern = getOrCreateDataViewByIndexPattern;
var _esqlUtils = require("@kbn/esql-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Get a saved data view that matches the index pattern (as close as possible)
 * or create a new adhoc data view if no matches found
 * @param dataViews
 * @param indexPatternFromQuery
 * @param currentDataView
 * @returns
 */
async function getOrCreateDataViewByIndexPattern(dataViews, query, currentDataView, http) {
  const indexPatternFromQuery = (0, _esqlUtils.getIndexPatternFromESQLQuery)(query);
  const newTimeField = (0, _esqlUtils.getTimeFieldFromESQLQuery)(query);
  if (currentDataView !== null && currentDataView !== void 0 && currentDataView.isPersisted() || indexPatternFromQuery !== (currentDataView === null || currentDataView === void 0 ? void 0 : currentDataView.getIndexPattern()) ||
  // here the pattern hasn't changed but the time field has
  newTimeField !== (currentDataView === null || currentDataView === void 0 ? void 0 : currentDataView.timeFieldName) && indexPatternFromQuery === (currentDataView === null || currentDataView === void 0 ? void 0 : currentDataView.getIndexPattern())) {
    return await (0, _esqlUtils.getESQLAdHocDataview)({
      dataViewsService: dataViews,
      query,
      http
    });
  }
  return currentDataView;
}