"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FileClashWarning = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _fileUpload = require("@kbn/file-upload");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/file_data_visualizer/new/file_clash_warning.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const FileClashWarning = () => {
  const {
    uploadStatus,
    fileUploadManager
  } = (0, _fileUpload.useFileUploadContext)();
  const fileClashes = uploadStatus.fileClashes;
  const clashType = fileClashes.some(fileClash => fileClash.clashType === _fileUpload.CLASH_TYPE.FORMAT) ? _fileUpload.CLASH_TYPE.FORMAT : fileClashes.some(fileClash => fileClash.clashType === _fileUpload.CLASH_TYPE.MAPPING) ? _fileUpload.CLASH_TYPE.MAPPING : fileClashes.some(fileClash => fileClash.clashType === _fileUpload.CLASH_TYPE.EXISTING_INDEX_MAPPING) ? _fileUpload.CLASH_TYPE.EXISTING_INDEX_MAPPING : _fileUpload.CLASH_TYPE.UNSUPPORTED;
  const {
    title,
    description
  } = clashType === _fileUpload.CLASH_TYPE.MAPPING ? {
    title: _i18n.i18n.translate('xpack.dataVisualizer.file.fileClashWarning.mappingClashTitle', {
      defaultMessage: 'Incompatible mapping'
    }),
    description: _i18n.i18n.translate('xpack.dataVisualizer.file.fileClashWarning.mappingClashDescription', {
      defaultMessage: 'Mappings in the selected files are not compatible with each other'
    })
  } : clashType === _fileUpload.CLASH_TYPE.FORMAT ? {
    title: _i18n.i18n.translate('xpack.dataVisualizer.file.fileClashWarning.fileFormatClashTitle', {
      defaultMessage: 'Incompatible file formats'
    }),
    description: _i18n.i18n.translate('xpack.dataVisualizer.file.fileClashWarning.fileFormatClashDescription', {
      defaultMessage: 'The selected files must have the same format. e.g. all CSV or all log files'
    })
  } : clashType === _fileUpload.CLASH_TYPE.EXISTING_INDEX_MAPPING ? {
    title: _i18n.i18n.translate('xpack.dataVisualizer.file.fileClashWarning.existingIndexMappingClashTitle', {
      defaultMessage: 'Incompatible mapping'
    }),
    description: _i18n.i18n.translate('xpack.dataVisualizer.file.fileClashWarning.existingIndexMappingClashDescription', {
      defaultMessage: 'Mappings in the selected files are not compatible with the existing index'
    })
  } : {
    title: _i18n.i18n.translate('xpack.dataVisualizer.file.fileClashWarning.fileFormatNotSupportedTitle', {
      defaultMessage: 'File format not supported'
    }),
    description: _i18n.i18n.translate('xpack.dataVisualizer.file.fileClashWarning.fileFormatNotSupportedDescription', {
      defaultMessage: 'Some of the selected files are not supported for upload.'
    })
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: title,
    color: "danger",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 7
    }
  }, description), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: () => fileUploadManager.removeClashingFiles(),
    color: "danger",
    size: "s",
    fill: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.fileClashWarning.deleteAllButtonLabel",
    defaultMessage: "Delete all",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 9
    }
  })));
};
exports.FileClashWarning = FileClashWarning;