"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFieldFormatter = exports.getFieldFormatType = void 0;
var _react = require("react");
var _common = require("@kbn/field-formats-plugin/common");
var _kibana_context = require("../../kibana_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getFieldFormatType = type => {
  switch (type) {
    case 'number':
      return _common.FIELD_FORMAT_IDS.NUMBER;
    case 'boolean':
      return _common.FIELD_FORMAT_IDS.BOOLEAN;
    default:
      return _common.FIELD_FORMAT_IDS.STRING;
  }
};
exports.getFieldFormatType = getFieldFormatType;
const useFieldFormatter = fieldType => {
  const {
    services: {
      data: {
        fieldFormats
      }
    }
  } = (0, _kibana_context.useDataVisualizerKibana)();
  const fieldFormatter = (0, _react.useMemo)(() => {
    return fieldFormats.deserialize({
      id: fieldType
    });
  }, [fieldFormats, fieldType]);
  return (0, _react.useCallback)(v => {
    const func = fieldFormatter.convert.bind(fieldFormatter);
    return func(v);
  }, [fieldFormatter]);
};
exports.useFieldFormatter = useFieldFormatter;