"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerUISettings = void 0;
var _configSchema = require("@kbn/config-schema");
var _i18n = require("@kbn/i18n");
var _managementSettingsIds = require("@kbn/management-settings-ids");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerUISettings = ({
  uiSettings
}) => {
  uiSettings.register({
    [_managementSettingsIds.DATA_CONNECTORS_ENABLED_SETTING_ID]: {
      description: _i18n.i18n.translate('xpack.dataConnectors.uiSettings.description', {
        defaultMessage: 'Enable Data Connectors'
      }),
      name: _i18n.i18n.translate('xpack.dataConnectors.uiSettings.name', {
        defaultMessage: 'Data Connectors'
      }),
      schema: _configSchema.schema.boolean(),
      value: false,
      technicalPreview: true,
      requiresPageReload: true,
      readonly: false
    }
  });
};
exports.registerUISettings = registerUISettings;