"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataConnectorsPlugin = void 0;
var _managementSettingsIds = require("@kbn/management-settings-ids");
var _register = require("./register");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class DataConnectorsPlugin {
  constructor(context) {}
  setup(core) {
    const isDataConnectorsEnabled = core.settings.client.get(_managementSettingsIds.DATA_CONNECTORS_ENABLED_SETTING_ID);
    if (isDataConnectorsEnabled) {
      (0, _register.registerApp)({
        core
      });
    }
    return {};
  }
  start(core) {
    return {};
  }
}
exports.DataConnectorsPlugin = DataConnectorsPlugin;