"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.create = create;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _dashboard_saved_object = require("../../dashboard_saved_object");
var _transforms = require("../../content_management/v1/transforms");
var _saved_object_utils = require("../saved_object_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function create(requestCtx, searchBody) {
  const {
    core
  } = await requestCtx.resolve(['core']);
  const {
    references: incomingReferences,
    ...incomingDashboardState
  } = searchBody.data;
  const {
    attributes: soAttributes,
    references: soReferences,
    error: transformInError
  } = (0, _transforms.transformDashboardIn)({
    dashboardState: incomingDashboardState,
    incomingReferences
  });
  if (transformInError) {
    throw _boom.default.badRequest(`Invalid data. ${transformInError.message}`);
  }
  const savedObject = await core.savedObjects.client.create(_dashboard_saved_object.DASHBOARD_SAVED_OBJECT_TYPE, soAttributes, {
    references: soReferences,
    ...(searchBody.id && {
      id: searchBody.id
    }),
    ...(searchBody.spaces && {
      initialNamespaces: searchBody.spaces
    })
  });
  return (0, _saved_object_utils.getDashboardCRUResponseBody)(savedObject, 'create');
}