"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createPackagePolicy = createPackagePolicy;
var _coreHttpCommon = require("@kbn/core-http-common");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function createPackagePolicy(supertest, agentPolicyId, policyTemplate, input, deployment, posture, packageName = 'cloud_security_posture-1', roleAuthc, internalRequestHeader) {
  const version = _constants.CLOUD_SECURITY_PLUGIN_VERSION;
  const title = 'Security Posture Management';
  const streams = [{
    enabled: true,
    data_stream: {
      type: 'logs',
      dataset: 'cloud_security_posture.vulnerabilities'
    }
  }];
  const inputTemplate = {
    enabled: true,
    type: input,
    policy_template: policyTemplate
  };
  const inputs = posture === 'vuln_mgmt' ? {
    ...inputTemplate,
    streams
  } : {
    ...inputTemplate
  };
  const {
    body: postPackageResponse
  } = roleAuthc && internalRequestHeader ? await supertest.post(`/api/fleet/package_policies`).set(_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER, '2023-10-31').set(internalRequestHeader).set(roleAuthc.apiKeyHeader).send({
    force: true,
    name: packageName,
    description: '',
    namespace: 'default',
    policy_id: agentPolicyId,
    enabled: true,
    inputs: [inputs],
    package: {
      name: 'cloud_security_posture',
      title,
      version
    },
    vars: {
      deployment: {
        value: deployment,
        type: 'text'
      },
      posture: {
        value: posture,
        type: 'text'
      }
    }
  }).expect(200) : await supertest.post(`/api/fleet/package_policies`).set(_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER, '2023-10-31').set('kbn-xsrf', 'xxxx').send({
    force: true,
    name: packageName,
    description: '',
    namespace: 'default',
    policy_id: agentPolicyId,
    enabled: true,
    inputs: [inputs],
    package: {
      name: 'cloud_security_posture',
      title,
      version
    },
    vars: {
      deployment: {
        value: deployment,
        type: 'text'
      },
      posture: {
        value: posture,
        type: 'text'
      }
    }
  }).expect(200);
  return postPackageResponse.item;
}