"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  ALREADY_PUSHED_TO_SERVICE: true,
  REQUIRED_UPDATE_TO_SERVICE: true,
  COPY_REFERENCE_LINK: true,
  MOVE_TO_ORIGINAL_COMMENT: true,
  ALERT_COMMENT_LABEL_TITLE: true,
  EVENT_COMMENT_LABEL_TITLE: true,
  SHOW_EVENT_TOOLTIP: true,
  MULTIPLE_ALERTS_COMMENT_LABEL_TITLE: true,
  MULTIPLE_EVENTS_COMMENT_LABEL_TITLE: true,
  SHOW_ALERT_TOOLTIP: true,
  SHOW_ALERT_TABLE_TOOLTIP: true,
  UNKNOWN_RULE: true,
  ISOLATED_HOST: true,
  RELEASED_HOST: true,
  OTHER_ENDPOINTS: true,
  CANCEL_BUTTON: true,
  DELETE: true,
  ASSIGNED: true,
  UNASSIGNED: true,
  THEMSELVES: true,
  AND: true,
  UNSAVED_DRAFT_DESCRIPTION: true,
  SHOW_MORE: true,
  CREATE_CASE: true,
  CASE_INITIATED: true,
  CASE_DELETED: true,
  SEVERITY: true,
  TITLE: true,
  SETTING: true,
  CUSTOM_FIELDS: true,
  OBSERVABLES: true,
  USER_ACTION_EDITED: true
};
exports.USER_ACTION_EDITED = exports.UNSAVED_DRAFT_DESCRIPTION = exports.UNKNOWN_RULE = exports.UNASSIGNED = exports.TITLE = exports.THEMSELVES = exports.SHOW_MORE = exports.SHOW_EVENT_TOOLTIP = exports.SHOW_ALERT_TOOLTIP = exports.SHOW_ALERT_TABLE_TOOLTIP = exports.SEVERITY = exports.SETTING = exports.REQUIRED_UPDATE_TO_SERVICE = exports.RELEASED_HOST = exports.OTHER_ENDPOINTS = exports.OBSERVABLES = exports.MULTIPLE_EVENTS_COMMENT_LABEL_TITLE = exports.MULTIPLE_ALERTS_COMMENT_LABEL_TITLE = exports.MOVE_TO_ORIGINAL_COMMENT = exports.ISOLATED_HOST = exports.EVENT_COMMENT_LABEL_TITLE = exports.DELETE = exports.CUSTOM_FIELDS = exports.CREATE_CASE = exports.COPY_REFERENCE_LINK = exports.CASE_INITIATED = exports.CASE_DELETED = exports.CANCEL_BUTTON = exports.ASSIGNED = exports.AND = exports.ALREADY_PUSHED_TO_SERVICE = exports.ALERT_COMMENT_LABEL_TITLE = void 0;
var _i18n = require("@kbn/i18n");
var _translations = require("../case_view/translations");
Object.keys(_translations).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _translations[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _translations[key];
    }
  });
});
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ALREADY_PUSHED_TO_SERVICE = externalService => _i18n.i18n.translate('xpack.cases.caseView.alreadyPushedToExternalService', {
  values: {
    externalService
  },
  defaultMessage: 'Already pushed to { externalService } incident'
});
exports.ALREADY_PUSHED_TO_SERVICE = ALREADY_PUSHED_TO_SERVICE;
const REQUIRED_UPDATE_TO_SERVICE = externalService => _i18n.i18n.translate('xpack.cases.caseView.requiredUpdateToExternalService', {
  values: {
    externalService
  },
  defaultMessage: 'Requires update to { externalService } incident'
});
exports.REQUIRED_UPDATE_TO_SERVICE = REQUIRED_UPDATE_TO_SERVICE;
const COPY_REFERENCE_LINK = exports.COPY_REFERENCE_LINK = _i18n.i18n.translate('xpack.cases.caseView.copyCommentLinkAria', {
  defaultMessage: 'Copy reference link'
});
const MOVE_TO_ORIGINAL_COMMENT = exports.MOVE_TO_ORIGINAL_COMMENT = _i18n.i18n.translate('xpack.cases.caseView.moveToCommentAria', {
  defaultMessage: 'Highlight the referenced comment'
});
const ALERT_COMMENT_LABEL_TITLE = exports.ALERT_COMMENT_LABEL_TITLE = _i18n.i18n.translate('xpack.cases.caseView.alertCommentLabelTitle', {
  defaultMessage: 'added an alert from'
});
const EVENT_COMMENT_LABEL_TITLE = exports.EVENT_COMMENT_LABEL_TITLE = _i18n.i18n.translate('xpack.cases.caseView.eventCommentLabelTitle', {
  defaultMessage: 'added an event'
});
const SHOW_EVENT_TOOLTIP = exports.SHOW_EVENT_TOOLTIP = _i18n.i18n.translate('xpack.cases.caseView.showEventTooltip', {
  defaultMessage: 'Show event details'
});
const MULTIPLE_ALERTS_COMMENT_LABEL_TITLE = totalAlerts => _i18n.i18n.translate('xpack.cases.caseView.generatedAlertCommentLabelTitle', {
  values: {
    totalAlerts
  },
  defaultMessage: 'added {totalAlerts} alerts from'
});
exports.MULTIPLE_ALERTS_COMMENT_LABEL_TITLE = MULTIPLE_ALERTS_COMMENT_LABEL_TITLE;
const MULTIPLE_EVENTS_COMMENT_LABEL_TITLE = totalEvents => _i18n.i18n.translate('xpack.cases.caseView.generatedEventCommentLabelTitle', {
  values: {
    totalEvents
  },
  defaultMessage: 'added {totalEvents} events'
});
exports.MULTIPLE_EVENTS_COMMENT_LABEL_TITLE = MULTIPLE_EVENTS_COMMENT_LABEL_TITLE;
const SHOW_ALERT_TOOLTIP = exports.SHOW_ALERT_TOOLTIP = _i18n.i18n.translate('xpack.cases.caseView.showAlertTooltip', {
  defaultMessage: 'Show alert details'
});
const SHOW_ALERT_TABLE_TOOLTIP = exports.SHOW_ALERT_TABLE_TOOLTIP = _i18n.i18n.translate('xpack.cases.caseView.showAlertTableTooltip', {
  defaultMessage: 'Show alerts'
});
const UNKNOWN_RULE = exports.UNKNOWN_RULE = _i18n.i18n.translate('xpack.cases.caseView.unknownRule.label', {
  defaultMessage: 'Unknown rule'
});
const ISOLATED_HOST = exports.ISOLATED_HOST = _i18n.i18n.translate('xpack.cases.caseView.isolatedHost', {
  defaultMessage: 'submitted isolate request on host'
});
const RELEASED_HOST = exports.RELEASED_HOST = _i18n.i18n.translate('xpack.cases.caseView.releasedHost', {
  defaultMessage: 'submitted release request on host'
});
const OTHER_ENDPOINTS = endpoints => _i18n.i18n.translate('xpack.cases.caseView.otherEndpoints', {
  values: {
    endpoints
  },
  defaultMessage: ` and {endpoints} {endpoints, plural, =1 {other} other {others}}`
});
exports.OTHER_ENDPOINTS = OTHER_ENDPOINTS;
const CANCEL_BUTTON = exports.CANCEL_BUTTON = _i18n.i18n.translate('xpack.cases.caseView.delete.cancel', {
  defaultMessage: 'Cancel'
});
const DELETE = exports.DELETE = _i18n.i18n.translate('xpack.cases.caseView.delete.confirm', {
  defaultMessage: 'Delete'
});
const ASSIGNED = exports.ASSIGNED = _i18n.i18n.translate('xpack.cases.caseView.assigned', {
  defaultMessage: 'assigned'
});
const UNASSIGNED = exports.UNASSIGNED = _i18n.i18n.translate('xpack.cases.caseView.unAssigned', {
  defaultMessage: 'unassigned'
});
const THEMSELVES = exports.THEMSELVES = _i18n.i18n.translate('xpack.cases.caseView.assignee.themselves', {
  defaultMessage: 'themselves'
});
const AND = exports.AND = _i18n.i18n.translate('xpack.cases.caseView.assignee.and', {
  defaultMessage: 'and'
});
const UNSAVED_DRAFT_DESCRIPTION = exports.UNSAVED_DRAFT_DESCRIPTION = _i18n.i18n.translate('xpack.cases.caseView.description.unsavedDraftDescription', {
  defaultMessage: 'You have unsaved edits for the description'
});
const SHOW_MORE = exports.SHOW_MORE = _i18n.i18n.translate('xpack.cases.caseView.userActions.showMore', {
  defaultMessage: 'Show more'
});
const CREATE_CASE = exports.CREATE_CASE = _i18n.i18n.translate('xpack.cases.caseView.userActions.createCase', {
  defaultMessage: 'Created case'
});
const CASE_INITIATED = exports.CASE_INITIATED = _i18n.i18n.translate('xpack.cases.caseView.userActions.caseInitiated', {
  defaultMessage: 'Case initiated'
});
const CASE_DELETED = exports.CASE_DELETED = _i18n.i18n.translate('xpack.cases.caseView.userActions.caseDeleted', {
  defaultMessage: `Case deleted`
});
const SEVERITY = exports.SEVERITY = _i18n.i18n.translate('xpack.cases.caseView.userActions.severity', {
  defaultMessage: 'Severity'
});
const TITLE = exports.TITLE = _i18n.i18n.translate('xpack.cases.caseView.userActions..title', {
  defaultMessage: 'Title'
});
const SETTING = exports.SETTING = _i18n.i18n.translate('xpack.cases.caseView.userActions..settings', {
  defaultMessage: 'Settings'
});
const CUSTOM_FIELDS = exports.CUSTOM_FIELDS = _i18n.i18n.translate('xpack.cases.caseView.userActions.customFields', {
  defaultMessage: 'Custom Fields'
});
const OBSERVABLES = exports.OBSERVABLES = _i18n.i18n.translate('xpack.cases.caseView.userActions.observables', {
  defaultMessage: 'Observables'
});
const USER_ACTION_EDITED = type => _i18n.i18n.translate('xpack.cases.caseView.userActions.edited', {
  values: {
    type
  },
  defaultMessage: `Edited "{type}"`
});
exports.USER_ACTION_EDITED = USER_ACTION_EDITED;