"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataStreamSamplesMetaData = exports.DataStreamSamples = void 0;
var _zod = require("@kbn/zod");
var _primitive = require("./primitive.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Automatic Import Samples document model
 *   version: not applicable
 */

/**
 * The data stream samples metadata object with its settings.
 */

const DataStreamSamplesMetaData = exports.DataStreamSamplesMetaData = _zod.z.object({
  /**
   * The user profile ID of the user who created the samples.
   */
  createdBy: _primitive.NonEmptyString,
  /**
   * The moment samples were created
   */
  createdAt: _primitive.NonEmptyString,
  /**
   * The original filename of the samples
   */
  originalFilename: _primitive.NonEmptyString
});

/**
 * The data stream samples object with its settings.
 */

const DataStreamSamples = exports.DataStreamSamples = _zod.z.object({
  /**
   * The integration id
   */
  integrationId: _primitive.NonEmptyString,
  /**
   * The data stream id
   */
  dataStreamId: _primitive.NonEmptyString,
  /**
   * The Serverless project id
   */
  projectId: _primitive.NonEmptyString.optional(),
  /**
   * The log samples
   */
  logData: _zod.z.array(_zod.z.string())
}).merge(DataStreamSamplesMetaData);