"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useProcessorEvent = useProcessorEvent;
var _common = require("@kbn/observability-plugin/common");
var _reactRouterDom = require("react-router-dom");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Infer the processor.event to used based on the route path
 */
function useProcessorEvent() {
  const {
    pathname
  } = (0, _reactRouterDom.useLocation)();
  const paths = pathname.split('/').slice(1);
  const pageName = paths[0];
  switch (pageName) {
    case 'services':
      let servicePageName = paths[2];
      if (servicePageName === 'nodes' && paths.length > 3) {
        servicePageName = 'metrics';
      }
      switch (servicePageName) {
        case 'transactions':
          return _common.ProcessorEvent.transaction;
        case 'errors':
          return _common.ProcessorEvent.error;
        case 'metrics':
          return _common.ProcessorEvent.metric;
        case 'nodes':
          return _common.ProcessorEvent.metric;
        default:
          return undefined;
      }
    case 'traces':
      return _common.ProcessorEvent.transaction;
    default:
      return undefined;
  }
}