"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateAgentKeyFlyout = CreateAgentKeyFlyout;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _create_call_apm_api = require("../../../../services/rest/create_call_apm_api");
var _use_current_user = require("../../../../hooks/use_current_user");
var _privilege_type = require("../../../../../common/privilege_type");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/settings/agent_keys/create_agent_key.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function CreateAgentKeyFlyout({
  onCancel,
  onSuccess,
  onError
}) {
  const [formTouched, setFormTouched] = (0, _react.useState)(false);
  const [agentKeyBody, setAgentKeyBody] = (0, _react.useState)({
    name: '',
    event: true,
    agentConfig: true
  });
  const {
    name,
    event,
    agentConfig
  } = agentKeyBody;
  const currentUser = (0, _use_current_user.useCurrentUser)();
  const isInputInvalid = (0, _lodash.isEmpty)(name);
  const isFormInvalid = formTouched && isInputInvalid;
  const formError = _i18n.i18n.translate('xpack.apm.settings.agentKeys.createKeyFlyout.name.placeholder', {
    defaultMessage: 'Enter a name'
  });
  const createAgentKeyTitle = _i18n.i18n.translate('xpack.apm.settings.agentKeys.createKeyFlyout.createAgentKey', {
    defaultMessage: 'Create APM agent key'
  });
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const createAgentKey = async () => {
    setFormTouched(true);
    if (isInputInvalid) {
      return;
    }
    try {
      const privileges = [];
      if (event) {
        privileges.push(_privilege_type.PrivilegeType.EVENT);
      }
      if (agentConfig) {
        privileges.push(_privilege_type.PrivilegeType.AGENT_CONFIG);
      }
      const {
        agentKey
      } = await (0, _create_call_apm_api.callApmApi)('POST /api/apm/agent_keys 2023-10-31', {
        signal: null,
        params: {
          body: {
            name,
            privileges
          }
        }
      });
      onSuccess(agentKey);
    } catch (error) {
      var _error$body;
      onError(name, ((_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message) || error.message);
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onCancel,
    size: "s",
    "aria-labelledby": modalTitleId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: modalTitleId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 11
    }
  }, createAgentKeyTitle))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    isInvalid: isFormInvalid,
    error: formError,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 9
    }
  }, currentUser && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.apm.settings.agentKeys.createKeyFlyout.userTitle', {
      defaultMessage: 'User'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 15
    }
  }, currentUser === null || currentUser === void 0 ? void 0 : currentUser.username)), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.apm.settings.agentKeys.createKeyFlyout.nameTitle', {
      defaultMessage: 'Name'
    }),
    helpText: _i18n.i18n.translate('xpack.apm.settings.agentKeys.createKeyFlyout.nameHelpText', {
      defaultMessage: 'What is this key used for?'
    }),
    isInvalid: isFormInvalid,
    error: formError,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "apmCreateAgentKeyFlyoutFieldText",
    name: "name",
    placeholder: _i18n.i18n.translate('xpack.apm.settings.agentKeys.createKeyFlyout.namePlaceholder', {
      defaultMessage: 'e.g. apm-key'
    }),
    onChange: e => setAgentKeyBody(state => ({
      ...state,
      name: e.target.value
    })),
    isInvalid: isFormInvalid,
    onBlur: () => setFormTouched(true),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormFieldset, {
    legend: {
      children: _i18n.i18n.translate('xpack.apm.settings.agentKeys.createKeyFlyout.privilegesFieldset', {
        defaultMessage: 'Assign privileges'
      })
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    helpText: _i18n.i18n.translate('xpack.apm.settings.agentKeys.createKeyFlyout.agentConfigHelpText', {
      defaultMessage: 'Required for agents to read agent configuration remotely.'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: (0, _eui.htmlIdGenerator)()(),
    label: "config_agent:read",
    checked: agentConfig,
    onChange: () => setAgentKeyBody(state => ({
      ...state,
      agentConfig: !state.agentConfig
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    helpText: _i18n.i18n.translate('xpack.apm.settings.agentKeys.createKeyFlyout.ingestAgentEvents', {
      defaultMessage: 'Required for ingesting events.'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: (0, _eui.htmlIdGenerator)()(),
    label: "event:write",
    checked: event,
    onChange: () => setAgentKeyBody(state => ({
      ...state,
      event: !state.event
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "apmCreateAgentKeyFlyoutCancelButton",
    onClick: onCancel,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.apm.settings.agentKeys.createKeyFlyout.cancelButton', {
    defaultMessage: 'Cancel'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "apmCreateAgentKeyFlyoutButton",
    fill: true,
    onClick: createAgentKey,
    type: "submit",
    disabled: isFormInvalid,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 13
    }
  }, createAgentKeyTitle)))));
}