"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ParentRelationshipAnalysis = ParentRelationshipAnalysis;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/service_map/diagnostic_tool/parent_relationship_analysis.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function ParentRelationshipAnalysis({
  hasParent,
  destinationHits,
  sourceNode,
  destinationNode
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m",
    color: "subdued",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.apm.serviceMap.diagnosticResults.parentIdsTitle', {
    defaultMessage: 'Parent Relationship Analysis'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }), hasParent ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "checkInCircleFilled",
    color: "success",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("strong", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.apm.serviceMap.diagnosticResults.parentIdsFound', {
    defaultMessage: 'Parent relationships found for {destinationNode}',
    values: {
      destinationNode
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "success",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.apm.diagnosticResults.documentsBadgeLabel', {
    defaultMessage: '{count, plural, one {# document} other {# documents}}',
    values: {
      count: destinationHits.length
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.apm.serviceMap.diagnosticResults.parentIdsFoundDescription', {
    defaultMessage: 'Found {count, plural, one {# document} other {# documents}} showing parent relationships pointing to {destinationNode} from {sourceNode} during the selected time range.',
    values: {
      count: destinationHits.length,
      destinationNode,
      sourceNode
    }
  })))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "alert",
    color: "warning",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("strong", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.apm.serviceMap.diagnosticResults.parentIdsNotFound', {
    defaultMessage: 'No parent relationships found for {destinationNode}',
    values: {
      destinationNode
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "warning",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.apm.diagnosticResults.documentsBadgeLabel', {
    defaultMessage: '{count, plural, one {# document} other {# documents}}',
    values: {
      count: destinationHits.length
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.apm.serviceMap.diagnosticResults.parentIdsNotFoundDescription', {
    defaultMessage: 'No parent IDs were found pointing from {sourceNode} to {destinationNode} during the selected time range. Found {count, plural, one {# document} other {# documents}} for analysis. This could indicate:',
    values: {
      sourceNode,
      destinationNode,
      count: destinationHits.length
    }
  })), /*#__PURE__*/_react.default.createElement("ul", {
    style: {
      marginTop: euiTheme.size.s,
      paddingLeft: euiTheme.size.base
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("li", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.apm.serviceMap.diagnosticResults.parentIdsNotFoundReason1', {
    defaultMessage: 'An instrumentation issue preventing proper trace correlation'
  })), /*#__PURE__*/_react.default.createElement("li", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.apm.serviceMap.diagnosticResults.parentIdsNotFoundReason2', {
    defaultMessage: 'Missing distributed tracing configuration between services'
  }))))));
}