"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HelpPopover = HelpPopover;
exports.HelpPopoverButton = HelpPopoverButton;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/help_popover/help_popover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const PopoverContent = (0, _styled.default)(_eui.EuiText)`
  max-width: 480px;
  max-height: 40vh;
`;
function HelpPopoverButton({
  buttonTextEnabled = false,
  onClick
}) {
  const buttonText = _i18n.i18n.translate('xpack.apm.helpPopover.ariaLabel', {
    defaultMessage: 'Help'
  });
  if (buttonTextEnabled) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "apmHelpPopoverButtonButton",
      className: "apmHelpPopover__buttonIcon",
      iconType: "question",
      "aria-label": buttonText,
      onClick: onClick,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 33,
        columnNumber: 7
      }
    }, buttonText);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "apmHelpPopoverButtonButton",
    className: "apmHelpPopover__buttonIcon",
    iconType: "question",
    "aria-label": buttonText,
    onClick: onClick,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 5
    }
  });
}
function HelpPopover({
  anchorPosition,
  button,
  children,
  closePopover,
  isOpen,
  title
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    anchorPosition: anchorPosition,
    button: button,
    closePopover: closePopover,
    isOpen: isOpen,
    panelPaddingSize: "s",
    ownFocus: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 5
    }
  }, title && /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 17
    }
  }, title), /*#__PURE__*/_react.default.createElement(PopoverContent, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 7
    }
  }, children));
}