"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDescriptionFields = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDescriptionFields = ({
  rule,
  prebuildFields
}) => {
  if (!rule || !prebuildFields) {
    return [];
  }
  const searchConfig = rule.params.searchConfiguration;
  if (!searchConfig) {
    return [];
  }
  if (searchConfig.query.query && typeof searchConfig.query.query === 'string') {
    return [prebuildFields.customQuery(searchConfig.query.query)];
  }
  return [];
};
exports.getDescriptionFields = getDescriptionFields;