"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.checkPrivileges = checkPrivileges;
exports.convertIndiciesToPrivilege = convertIndiciesToPrivilege;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function convertIndiciesToPrivilege(apmIndices) {
  return Object.values(apmIndices).flatMap(value => value.split(',')).reduce((obj, item, index) => {
    obj[item] = ['read'];
    return obj;
  }, {});
}
async function checkPrivileges({
  request,
  getApmIndices,
  security
}) {
  const authorization = security === null || security === void 0 ? void 0 : security.authz;
  if (!authorization) {
    return true;
  }
  const [apmIndices, checkPrivilegesFn] = await Promise.all([getApmIndices(request), authorization.checkPrivilegesDynamicallyWithRequest(request)]);
  const {
    hasAllRequested
  } = await checkPrivilegesFn({
    elasticsearch: {
      cluster: [],
      index: convertIndiciesToPrivilege(apmIndices)
    }
  });
  return hasAllRequested;
}