"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSummarizedAlerts = void 0;
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _server = require("@kbn/task-manager-plugin/server");
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSummarizedAlerts = async ({
  alertsClient,
  queryOptions
}) => {
  let alerts;
  try {
    alerts = await alertsClient.getSummarizedAlerts(queryOptions);
  } catch (e) {
    throw (0, _server.createTaskRunError)(e, _server.TaskErrorSource.FRAMEWORK);
  }

  /**
   * We need to remove all new alerts with maintenance windows retrieved from getSummarizedAlerts
   * because we update the alerts with maintenance window IDs after scheduling actions.
   * So we need to rely on the in memory alerts to do this.
   */
  const newAlertsInMemory = Object.values(alertsClient.getProcessedAlerts('new'));
  const newAlertsWithMaintenanceWindowIds = newAlertsInMemory.reduce((result, alert) => {
    if (alert.getMaintenanceWindowIds().length > 0) {
      result.push(alert.getUuid());
    }
    return result;
  }, []);
  const newAlerts = alerts.new.data.filter(alert => {
    return !newAlertsWithMaintenanceWindowIds.includes((0, _lodash.get)(alert, _ruleDataUtils.ALERT_UUID));
  });
  const total = newAlerts.length + alerts.ongoing.count + alerts.recovered.count;
  return {
    ...alerts,
    new: {
      count: newAlerts.length,
      data: newAlerts
    },
    all: {
      count: total,
      data: [...newAlerts, ...alerts.ongoing.data, ...alerts.recovered.data]
    }
  };
};
exports.getSummarizedAlerts = getSummarizedAlerts;