"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerFieldsRoute = registerFieldsRoute;
var _i18n = require("@kbn/i18n");
var _configSchema = require("@kbn/config-schema");
var _saved_objects_index_pattern = require("@kbn/core-saved-objects-server/src/saved_objects_index_pattern");
var _server = require("@kbn/data-views-plugin/server");
var _lib = require("../lib");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerFieldsRoute(router, licenseState, usageCounter) {
  router.post({
    path: '/internal/rules/saved_objects/fields',
    security: _constants.DEFAULT_ALERTING_ROUTE_SECURITY,
    options: {
      access: 'internal'
    },
    validate: {
      body: _configSchema.schema.nullable(_configSchema.schema.object({
        fields: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.arrayOf(_configSchema.schema.string())]))
      }))
    }
  }, router.handleLegacyErrors((0, _lib.verifyAccessAndContext)(licenseState, async function (context, request, response) {
    var _request$body$fields, _request$body;
    const tmpFields = (_request$body$fields = (_request$body = request.body) === null || _request$body === void 0 ? void 0 : _request$body.fields) !== null && _request$body$fields !== void 0 ? _request$body$fields : ['alert.*'];
    const requestedFields = Array.isArray(tmpFields) ? tmpFields : [tmpFields];
    const isAllFieldsValid = requestedFields.every(f => f.startsWith('alert.'));
    if (!isAllFieldsValid) {
      return response.badRequest({
        body: new Error(_i18n.i18n.translate('xpack.alerting.api.error.rules.fields', {
          defaultMessage: 'You can only request fields starting with "alert."'
        }))
      });
    }
    const indices = [_saved_objects_index_pattern.ALERTING_CASES_SAVED_OBJECT_INDEX];
    const {
      elasticsearch,
      uiSettings
    } = await context.core;
    const indexPatternsFetcherAsInternalUser = new _server.IndexPatternsFetcher(elasticsearch.client.asInternalUser, {
      uiSettingsClient: uiSettings.client
    });
    const {
      fields
    } = await indexPatternsFetcherAsInternalUser.getFieldsForWildcard({
      pattern: indices,
      fields: requestedFields,
      fieldCapsOptions: {
        allow_no_indices: true
      }
    });
    return response.ok({
      body: fields
    });
  })));
}