"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findMaintenanceWindowsResponseBodySchema = exports.findMaintenanceWindowsRequestQuerySchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _response = require("../../../response");
var _v = require("../../../../shared/schemas/v1");
var _v2 = require("../../../../shared/validation/v1");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const findMaintenanceWindowsRequestQuerySchema = exports.findMaintenanceWindowsRequestQuerySchema = _configSchema.schema.object({
  page: _v.maintenanceWindowPageSchema,
  per_page: _v.maintenanceWindowPerPageSchema,
  search: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'An Elasticsearch simple_query_string query that filters the objects in the response.'
    }
  })),
  status: _configSchema.schema.maybe(_configSchema.schema.oneOf([_v.maintenanceWindowStatusSchema, _configSchema.schema.arrayOf(_v.maintenanceWindowStatusSchema)]))
}, {
  validate: _v2.validatePagination
});
const findMaintenanceWindowsResponseBodySchema = exports.findMaintenanceWindowsResponseBodySchema = _configSchema.schema.object({
  page: _configSchema.schema.number(),
  per_page: _configSchema.schema.number(),
  total: _configSchema.schema.number(),
  data: _configSchema.schema.arrayOf(_response.maintenanceWindowResponseSchemaV1)
});