"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformGetAllConnectorsResponse = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformGetAllConnectorsResponse = results => {
  return results.map(({
    id,
    name,
    config,
    actionTypeId,
    isPreconfigured,
    isDeprecated,
    referencedByCount,
    isMissingSecrets,
    isSystemAction,
    isConnectorTypeDeprecated
  }) => ({
    id,
    name,
    config,
    connector_type_id: actionTypeId,
    is_preconfigured: isPreconfigured,
    is_deprecated: isDeprecated,
    referenced_by_count: referencedByCount,
    is_missing_secrets: isMissingSecrets,
    is_system_action: isSystemAction,
    is_connector_type_deprecated: isConnectorTypeDeprecated
  }));
};
exports.transformGetAllConnectorsResponse = transformGetAllConnectorsResponse;