"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useHighContrastModifications = void 0;
var _react = require("react");
var _euiThemeCommon = require("@elastic/eui-theme-common");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
// Rather than being calculated when the theme's styles are being computed, we're bogarting the
// `modify` logic so we can ensure consumer modifications to border-color are also overriden.
// If in the future we need more complex high contrast mode logic (e.g. changing color tokens)
// we'll need to actually dive into theme/utils.ts's Computed.getValue logic at that point.
var useHighContrastModifications = exports.useHighContrastModifications = function useHighContrastModifications(_ref) {
  var _modifications$border2;
  var highContrastMode = _ref.highContrastMode,
    colorMode = _ref.colorMode,
    system = _ref.system,
    modifications = _ref.modifications;
  var highContrastModifications = (0, _react.useMemo)(function () {
    var borderColor = colorMode === 'DARK' ? system.root.colors.plainLight : system.root.colors.plainDark;
    var getBorderWidth = function getBorderWidth(width) {
      var _modifications$border;
      return (modifications === null || modifications === void 0 || (_modifications$border = modifications.border) === null || _modifications$border === void 0 || (_modifications$border = _modifications$border.width) === null || _modifications$border === void 0 ? void 0 : _modifications$border[width]) || system.root.border.width[width];
    };
    var systemTheme = (0, _euiThemeCommon.getComputed)(system, {}, colorMode);
    var borderColorModifications = {
      borderBasePrimary: systemTheme.colors.textPrimary,
      borderBaseAccent: systemTheme.colors.textAccent,
      borderBaseAccentSecondary: systemTheme.colors.textAccentSecondary,
      borderBaseNeutral: systemTheme.colors.textNeutral,
      borderBaseSuccess: systemTheme.colors.textSuccess,
      borderBaseWarning: systemTheme.colors.textWarning,
      borderBaseRisk: systemTheme.colors.textRisk,
      borderBaseDanger: systemTheme.colors.textDanger,
      borderBasePlain: borderColor,
      borderBaseSubdued: borderColor,
      borderBaseProminent: borderColor,
      borderBaseDisabled: systemTheme.colors.textDisabled,
      borderBaseFloating: borderColor,
      borderStrongPrimary: systemTheme.colors.textPrimary,
      borderStrongAccent: systemTheme.colors.textAccent,
      borderStrongAccentSecondary: systemTheme.colors.textAccentSecondary,
      borderStrongNeutral: systemTheme.colors.textNeutral,
      borderStrongSuccess: systemTheme.colors.textSuccess,
      borderStrongWarning: systemTheme.colors.textWarning,
      borderStrongRisk: systemTheme.colors.textRisk,
      borderStrongDanger: systemTheme.colors.textDanger
    };
    return {
      colors: {
        LIGHT: _objectSpread({}, borderColorModifications),
        DARK: _objectSpread({}, borderColorModifications)
      },
      border: {
        color: borderColor,
        thin: "".concat(getBorderWidth('thin'), " solid ").concat(borderColor),
        thick: "".concat(getBorderWidth('thick'), " solid ").concat(borderColor)
      }
    };
  }, [system, colorMode, modifications === null || modifications === void 0 || (_modifications$border2 = modifications.border) === null || _modifications$border2 === void 0 ? void 0 : _modifications$border2.width]);

  // Memoizing the object(s) returned is important for performance/referential equality
  return (0, _react.useMemo)(function () {
    return highContrastMode ? _objectSpread(_objectSpread({}, modifications), highContrastModifications) : modifications;
  }, [highContrastMode, modifications, highContrastModifications]);
};