"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SIZES = exports.POSITIONS = exports.EuiProgress = exports.COLORS = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _i18n = require("../i18n");
var _predicate = require("../../services/predicate");
var _services = require("../../services");
var _accessibility = require("../accessibility");
var _progress = require("./progress.styles");
var _react2 = require("@emotion/react");
var _excluded = ["className", "color", "size", "position", "max", "valueText", "label", "value", "labelProps"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var SIZES = exports.SIZES = ['xs', 's', 'm', 'l'];
var COLORS = exports.COLORS = ['primary', 'success', 'warning', 'danger', 'subdued', 'accent', 'accentSecondary', 'vis0', 'vis1', 'vis2', 'vis3', 'vis4', 'vis5', 'vis6', 'vis7', 'vis8', 'vis9'];
var POSITIONS = exports.POSITIONS = ['fixed', 'absolute', 'static'];
var EuiProgress = exports.EuiProgress = function EuiProgress(_ref) {
  var className = _ref.className,
    _ref$color = _ref.color,
    color = _ref$color === void 0 ? 'success' : _ref$color,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 'm' : _ref$size,
    _ref$position = _ref.position,
    position = _ref$position === void 0 ? 'static' : _ref$position,
    max = _ref.max,
    _ref$valueText = _ref.valueText,
    valueText = _ref$valueText === void 0 ? false : _ref$valueText,
    label = _ref.label,
    value = _ref.value,
    labelProps = _ref.labelProps,
    rest = _objectWithoutProperties(_ref, _excluded);
  var valueTextRef = (0, _react.useRef)(null);
  var labelRef = (0, _react.useRef)(null);
  var _useState = (0, _react.useState)(),
    _useState2 = _slicedToArray(_useState, 2),
    innerValueText = _useState2[0],
    setInnerValueText = _useState2[1];
  var _useState3 = (0, _react.useState)(),
    _useState4 = _slicedToArray(_useState3, 2),
    labelText = _useState4[0],
    setLabelText = _useState4[1];
  var determinate = !(0, _predicate.isNil)(max);
  var isNamedColor = COLORS.includes(color);
  var euiTheme = (0, _services.useEuiTheme)();
  var customColorStyles = !isNamedColor ? {
    color: color
  } : {};
  var customTextColorStyles = !isNamedColor ? {
    color: (0, _services.makeHighContrastColor)(color)(euiTheme.euiTheme)
  } : {};
  var styles = (0, _progress.euiProgressStyles)(euiTheme, determinate);
  var cssStyles = [styles.euiProgress, determinate && styles.native, !determinate && styles.indeterminate, styles[size], styles[position], isNamedColor ? styles[color] : styles.customColor];
  var dataStyles = (0, _progress.euiProgressDataStyles)(euiTheme);
  var dataCssStyles = [dataStyles.euiProgress__data, size === 'l' && dataStyles[size]];
  var labelCssStyles = [_progress.euiProgressLabelStyles.euiProgress__label, labelProps === null || labelProps === void 0 ? void 0 : labelProps.css];
  var valueTextStyles = (0, _progress.euiProgressValueTextStyles)(euiTheme);
  var valueTextCssStyles = [valueTextStyles.euiProgress__valueText, isNamedColor ? valueTextStyles[color] : styles.customColor];
  var classes = (0, _classnames.default)('euiProgress', className);
  var labelClasses = (0, _classnames.default)('euiProgress__label', labelProps === null || labelProps === void 0 ? void 0 : labelProps.className);
  var valueRender;
  if (valueText === true) {
    // valueText is true
    valueRender = (0, _react2.jsx)(_i18n.EuiI18n, {
      token: "euiProgress.valueText",
      default: "{value}%",
      values: {
        value: value
      }
    });
  } else if (valueText) {
    // valueText exists
    valueRender = valueText;
  }
  (0, _react.useEffect)(function () {
    var _valueTextRef$current, _valueTextRef$current2, _labelRef$current$tex, _labelRef$current;
    setInnerValueText((_valueTextRef$current = (_valueTextRef$current2 = valueTextRef.current) === null || _valueTextRef$current2 === void 0 ? void 0 : _valueTextRef$current2.textContent) !== null && _valueTextRef$current !== void 0 ? _valueTextRef$current : '');
    setLabelText((_labelRef$current$tex = (_labelRef$current = labelRef.current) === null || _labelRef$current === void 0 ? void 0 : _labelRef$current.textContent) !== null && _labelRef$current$tex !== void 0 ? _labelRef$current$tex : '');
  }, [label, valueRender, value]);

  // Because of a Firefox animation issue, indeterminate progress needs to not use <progress />.
  // See https://css-tricks.com/html5-progress-element/

  if (determinate) {
    return (0, _react2.jsx)(_react.default.Fragment, null, label || valueText ? (0, _react2.jsx)("div", {
      css: dataCssStyles,
      className: "euiProgress__data"
    }, label && (0, _react2.jsx)("div", _extends({
      ref: function ref(node) {
        labelRef.current = node;
      }
    }, labelProps, {
      className: labelClasses,
      css: labelCssStyles,
      "aria-hidden": "true"
    }), label), valueRender && (0, _react2.jsx)("div", {
      ref: function ref(node) {
        valueTextRef.current = node;
      },
      style: customTextColorStyles,
      css: valueTextCssStyles,
      className: "euiProgress__valueText",
      "aria-hidden": "true"
    }, valueRender)) : undefined, (0, _react2.jsx)(_accessibility.EuiScreenReaderOnly, null, (0, _react2.jsx)("div", {
      "aria-live": "polite",
      "aria-atomic": "true"
    }, (0, _react2.jsx)("span", null, label && (0, _react2.jsx)(_react.default.Fragment, null, labelText, " "), valueRender || value))), (0, _react2.jsx)("progress", _extends({
      css: cssStyles,
      className: classes,
      style: customColorStyles,
      max: max,
      value: value,
      "aria-valuetext": innerValueText || undefined,
      "aria-label": labelText || undefined
    }, rest)));
  } else {
    return (0, _react2.jsx)("div", _extends({
      css: cssStyles,
      style: customColorStyles,
      className: classes
    }, rest));
  }
};
EuiProgress.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  size: _propTypes.default.any,
  /**
     * One of EUI's color palette, vis colors or a valid CSS color value https://developer.mozilla.org/en-US/docs/Web/CSS/color_value
     */
  /**
     * One of EUI's color palette, vis colors or a valid CSS color value https://developer.mozilla.org/en-US/docs/Web/CSS/color_value
     */
  color: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.any.isRequired]),
  position: _propTypes.default.any,
  /**
       * When set, creates determinate progress with a value/max ratio
       */
  max: _propTypes.default.number,
  /**
       * Displays custom text or percentage
       * Pass `true` to display the percentage value
       * Pass a ReactNode for custom text
       * @default false
       */
  valueText: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.node.isRequired]),
  label: _propTypes.default.node,
  /**
       * Object of props passed to the <span/> wrapping the determinate progress's label
       */
  labelProps: _propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any
  })
};