"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiFilterSelectItemClass = exports.EuiFilterSelectItem = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _flex = require("../flex");
var _tool_tip = require("../tool_tip");
var _icon = require("../icon");
var _filter_select_item = require("./filter_select_item.styles");
var _react2 = require("@emotion/react");
var _excluded = ["theme", "children", "className", "disabled", "checked", "isFocused", "showIcons", "toolTipContent", "toolTipProps", "style", "truncateContent", "forwardRef"];
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var resolveIconAndColor = function resolveIconAndColor(checked) {
  if (!checked) {
    return {
      icon: 'empty'
    };
  }
  return checked === 'on' ? {
    icon: 'check',
    color: 'text'
  } : {
    icon: 'cross',
    color: 'text'
  };
};

/**
 * TODO: This component should removed in favor of EuiSelectable usage
 * once EuiComboBox has been converted to dogfood EuiSelectable.
 *
 * @deprecated - Use EuiSelectable instead
 */
var EuiFilterSelectItemClass = exports.EuiFilterSelectItemClass = /*#__PURE__*/function (_Component) {
  function EuiFilterSelectItemClass() {
    var _this;
    _classCallCheck(this, EuiFilterSelectItemClass);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _callSuper(this, EuiFilterSelectItemClass, [].concat(args));
    _defineProperty(_this, "buttonRef", null);
    _defineProperty(_this, "tooltipRef", /*#__PURE__*/(0, _react.createRef)());
    _defineProperty(_this, "state", {
      hasFocus: false
    });
    _defineProperty(_this, "setButtonRef", function (node) {
      var _this$props$forwardRe, _this$props;
      _this.buttonRef = node;
      (_this$props$forwardRe = (_this$props = _this.props).forwardRef) === null || _this$props$forwardRe === void 0 || _this$props$forwardRe.call(_this$props, node);
    });
    _defineProperty(_this, "focus", function () {
      if (_this.buttonRef) {
        _this.buttonRef.focus();
      }
    });
    _defineProperty(_this, "toggleToolTip", function (isFocused) {
      if (isFocused) {
        var _this$tooltipRef;
        (_this$tooltipRef = _this.tooltipRef) === null || _this$tooltipRef === void 0 || (_this$tooltipRef = _this$tooltipRef.current) === null || _this$tooltipRef === void 0 || _this$tooltipRef.showToolTip();
      } else {
        var _this$tooltipRef2;
        (_this$tooltipRef2 = _this.tooltipRef) === null || _this$tooltipRef2 === void 0 || (_this$tooltipRef2 = _this$tooltipRef2.current) === null || _this$tooltipRef2 === void 0 || _this$tooltipRef2.hideToolTip();
      }
    });
    _defineProperty(_this, "hasFocus", function () {
      return _this.state.hasFocus;
    });
    return _this;
  }
  _inherits(EuiFilterSelectItemClass, _Component);
  return _createClass(EuiFilterSelectItemClass, [{
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (this.props.isFocused && !prevProps.isFocused) {
        var _this$buttonRef, _this$buttonRef$scrol;
        (_this$buttonRef = this.buttonRef) === null || _this$buttonRef === void 0 || (_this$buttonRef$scrol = _this$buttonRef.scrollIntoView) === null || _this$buttonRef$scrol === void 0 || _this$buttonRef$scrol.call(_this$buttonRef, {
          block: 'nearest'
        });
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
        theme = _this$props2.theme,
        children = _this$props2.children,
        className = _this$props2.className,
        disabled = _this$props2.disabled,
        checked = _this$props2.checked,
        isFocused = _this$props2.isFocused,
        showIcons = _this$props2.showIcons,
        toolTipContent = _this$props2.toolTipContent,
        toolTipProps = _this$props2.toolTipProps,
        style = _this$props2.style,
        truncateContent = _this$props2.truncateContent,
        forwardRef = _this$props2.forwardRef,
        rest = _objectWithoutProperties(_this$props2, _excluded);
      var styles = (0, _filter_select_item.euiFilterSelectItemStyles)(theme);
      var cssStyles = [styles.euiFilterSelectItem, isFocused && styles.isFocused];
      var classes = (0, _classnames.default)('euiFilterSelectItem', className);
      var hasToolTip =
      // we're using isValidElement here as EuiToolTipAnchor uses
      // cloneElement to enhance the element with required attributes
      /*#__PURE__*/_react.default.isValidElement(children) && !disabled && toolTipContent;
      var anchorProps = undefined;
      if (hasToolTip) {
        var _toolTipProps$anchorP, _toolTipProps$anchorP2;
        var anchorStyles = toolTipProps !== null && toolTipProps !== void 0 && (_toolTipProps$anchorP = toolTipProps.anchorProps) !== null && _toolTipProps$anchorP !== void 0 && _toolTipProps$anchorP.style ? _objectSpread(_objectSpread({}, toolTipProps === null || toolTipProps === void 0 || (_toolTipProps$anchorP2 = toolTipProps.anchorProps) === null || _toolTipProps$anchorP2 === void 0 ? void 0 : _toolTipProps$anchorP2.style), style) : style;
        anchorProps = toolTipProps !== null && toolTipProps !== void 0 && toolTipProps.anchorProps ? _objectSpread(_objectSpread({}, toolTipProps.anchorProps), {}, {
          style: anchorStyles
        }) : {
          style: style
        };
        this.toggleToolTip(isFocused !== null && isFocused !== void 0 ? isFocused : false);
      }
      var iconNode;
      if (showIcons) {
        var _resolveIconAndColor = resolveIconAndColor(checked),
          icon = _resolveIconAndColor.icon,
          color = _resolveIconAndColor.color;
        iconNode = (0, _react2.jsx)(_flex.EuiFlexItem, {
          grow: false
        }, (0, _react2.jsx)(_icon.EuiIcon, {
          color: color,
          type: icon
        }));
      }
      var optionItem = (0, _react2.jsx)("button", _extends({
        ref: this.setButtonRef,
        role: "option",
        type: "button",
        "aria-selected": checked === 'on',
        className: classes,
        css: cssStyles,
        disabled: disabled,
        "aria-disabled": disabled,
        style: !hasToolTip ? style : undefined
      }, rest), (0, _react2.jsx)(_flex.EuiFlexGroup, {
        alignItems: "center",
        gutterSize: "s",
        component: "span",
        responsive: false
      }, iconNode, (0, _react2.jsx)(_flex.EuiFlexItem, {
        className: (0, _classnames.default)('euiFilterSelectItem__content', this.props.truncateContent && 'eui-textTruncate'),
        component: "span"
      }, children)));
      return hasToolTip ? (0, _react2.jsx)(_tool_tip.EuiToolTip, _extends({
        ref: this.tooltipRef,
        display: "block",
        content: toolTipContent,
        position: "left"
      }, toolTipProps, {
        anchorProps: anchorProps
      }), optionItem) : optionItem;
    }
  }]);
}(_react.Component);
/**
 * @deprecated - Use EuiSelectable instead
 */
_defineProperty(EuiFilterSelectItemClass, "defaultProps", {
  showIcons: true,
  truncateContent: true
});
EuiFilterSelectItemClass.propTypes = {
  checked: _propTypes.default.oneOf(["on", "off"]),
  showIcons: _propTypes.default.bool,
  isFocused: _propTypes.default.bool,
  truncateContent: _propTypes.default.bool,
  toolTipContent: _propTypes.default.node,
  toolTipProps: _propTypes.default.any,
  forwardRef: _propTypes.default.func,
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any
};
var EuiFilterSelectItem = exports.EuiFilterSelectItem = (0, _services.withEuiTheme)(EuiFilterSelectItemClass);