"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiDataGridVariables = exports.euiDataGridStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
var _high_contrast = require("../../global_styling/functions/high_contrast");
var _data_grid_cell = require("./body/cell/data_grid_cell.styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiDataGridVariables = exports.euiDataGridVariables = function euiDataGridVariables(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    cellPadding: {
      s: euiTheme.size.xs,
      m: (0, _global_styling.mathWithUnits)(euiTheme.size.m, function (x) {
        return x / 2;
      }),
      l: euiTheme.size.s
    },
    lineHeight: {
      s: (0, _global_styling.euiFontSize)(euiThemeContext, 'xs').lineHeight,
      m: (0, _global_styling.euiFontSize)(euiThemeContext, 'm').lineHeight
    },
    fontSize: {
      s: (0, _global_styling.euiFontSize)(euiThemeContext, 'xs').fontSize,
      m: (0, _global_styling.euiFontSize)(euiThemeContext, 's').fontSize
    },
    levels: {
      cellPopover: Number(euiTheme.levels.header),
      // Same z-index as EuiFlyout mask overlays - cell popovers should be under both modal and flyout overlays
      get stickyHeader() {
        return this.cellPopover - 1; // Needs to sit above the content + cell focus outlines/actions, but below actual popovers
      }
    }
  };
};
var euiDataGridStyles = exports.euiDataGridStyles = function euiDataGridStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme,
    highContrastMode = euiThemeContext.highContrastMode;
  var _euiDataGridVariables = euiDataGridVariables(euiThemeContext),
    _cellPadding = _euiDataGridVariables.cellPadding,
    lineHeight = _euiDataGridVariables.lineHeight,
    _fontSize = _euiDataGridVariables.fontSize;
  var _euiDataGridCellOutli = (0, _data_grid_cell.euiDataGridCellOutlineSelectors)(),
    outlineSelectors = _euiDataGridCellOutli.outline;
  var borderColors = {
    default: highContrastMode ? euiTheme.border.color : euiTheme.components.dataGridBorderColor,
    vertical: highContrastMode ? euiTheme.border.color : euiTheme.components.dataGridVerticalLineBorderColor
  };
  var border = "".concat(euiTheme.border.width.thin, " solid ").concat(borderColors.default);
  return {
    euiDataGrid: /*#__PURE__*/(0, _react.css)("display:flex;flex-direction:column;align-items:stretch;", (0, _global_styling.logicalCSS)('height', '100%'), " overflow:hidden;*:where(& .euiDataGridRow){background-color:", euiTheme.components.dataGridRowBackground, ";}*:where(&.euiDataGrid--rowHoverHighlight .euiDataGridRow:hover){background-color:", euiTheme.components.dataGridRowBackgroundHover, ";}*:where(& .euiDataGridRow--selected){background-color:", euiTheme.components.dataGridRowBackgroundSelect, ";}*:where(& .euiDataGridRow--marked){background-color:", euiTheme.components.dataGridRowBackgroundMarked, ";.euiDataGridRowCell.euiDataGridRowCell{", outlineSelectors.marked, "{", (0, _data_grid_cell.euiDataGridCellOutlineStyles)(euiThemeContext).markedStyles, ";}}}*:where(&.euiDataGrid--rowHoverHighlight .euiDataGridRow--marked){&:hover{background-color:", euiTheme.components.dataGridRowBackgroundMarkedHover, ";}}*:where(\n          &.euiDataGrid--rowHoverHighlight .euiDataGridRow--selected:hover\n        ){background-color:", euiTheme.components.dataGridRowBackgroundSelectHover, ";}*:where(&.euiDataGrid--stripes .euiDataGridRow){background-color:", euiTheme.components.dataGridRowStripesBackground, ";}*:where(&.euiDataGrid--stripes .euiDataGridRow--striped){background-color:", euiTheme.components.dataGridRowStripesBackgroundStriped, ";}*:where(\n          &.euiDataGrid--stripes.euiDataGrid--rowHoverHighlight\n            .euiDataGridRow:hover\n        ){background-color:", euiTheme.components.dataGridRowStripesBackgroundHover, ";}*:where(\n          &.euiDataGrid--stripes.euiDataGrid--rowHoverHighlight\n            .euiDataGridRow--striped:hover\n        ){background-color:", euiTheme.components.dataGridRowStripesBackgroundStripedHover, ";}*:where(&.euiDataGrid--stripes .euiDataGridRow--selected){background-color:", euiTheme.components.dataGridRowStripesBackgroundSelect, ";}*:where(&.euiDataGrid--stripes .euiDataGridRow--marked){background-color:", euiTheme.components.dataGridRowBackgroundMarked, ";}*:where(\n          &.euiDataGrid--stripes.euiDataGrid--rowHoverHighlight\n            .euiDataGridRow--selected:hover\n        ){background-color:", euiTheme.components.dataGridRowStripesBackgroundSelectHover, ";}*:where(&.euiDataGrid--rowHoverHighlight .euiDataGridRow)::before{content:'';position:absolute;z-index:-1;pointer-events:none;inset:0;background-color:", euiTheme.components.dataGridRowBackground, ";};label:euiDataGrid;"),
    cellPadding: {
      cellPadding: function cellPadding(size) {
        return /*#__PURE__*/(0, _react.css)(".euiDataGridHeaderCell,.euiDataGridRowCell__content{padding:", _cellPadding[size], ";}.euiDataGridRowCell__content--lineCountHeight,.euiDataGridRowCell__content--autoBelowLineCountHeight{", (0, _high_contrast.highContrastModeStyles)(euiThemeContext, {
          // Workaround to trim line-clamp and padding - @see https://github.com/elastic/eui/issues/7780
          none: "\n              ".concat((0, _global_styling.logicalCSS)('padding-bottom', 0), "\n              ").concat((0, _global_styling.logicalCSS)('border-bottom', "".concat(_cellPadding[size], " solid transparent")), "\n            "),
          // Unfortunately this workaround backfires in Windows high contrast themes, which force
          // border-color, so we can't use it. We'll use a clip-path workaround instead.
          get forced() {
            var bottomY = "calc(100% - ".concat(_cellPadding[size], ")");
            return "clip-path: polygon(0 0, 100% 0, 100% ".concat(bottomY, ", 0 ").concat(bottomY, ");");
          }
        }), ";}.euiDataGridHeaderCell__button{margin-block:-", _cellPadding[size], ";};label:cellPadding;");
      },
      get s() {
        return /*#__PURE__*/(0, _react.css)(this.cellPadding('s'), ";label:s;");
      },
      get m() {
        return /*#__PURE__*/(0, _react.css)(this.cellPadding('m'), ";label:m;");
      },
      get l() {
        return /*#__PURE__*/(0, _react.css)(this.cellPadding('l'), ";label:l;");
      }
    },
    fontSize: {
      fontSize: function fontSize(size) {
        return /*#__PURE__*/(0, _react.css)(".euiDataGridHeaderCell,.euiDataGridRowCell{font-size:", _fontSize[size], ";line-height:", lineHeight[size], ";};label:fontSize;");
      },
      get s() {
        return /*#__PURE__*/(0, _react.css)(this.fontSize('s'), ";label:s;");
      },
      get m() {
        return /*#__PURE__*/(0, _react.css)(this.fontSize('m'), ";label:m;");
      },
      get l() {
        return /*#__PURE__*/(0, _react.css)(this.fontSize('m'), ";label:l;");
      }
    },
    borders: {
      none: null,
      horizontal: /*#__PURE__*/(0, _react.css)("label:borders;.euiDataGridRowCell:not(.euiDataGridFooterCell),.euiDataGridFooter,&:not(.euiDataGrid--headerUnderline) .euiDataGridHeader{", (0, _global_styling.logicalCSS)('border-bottom', border), ";}&:not(.euiDataGrid--footerOverline) .euiDataGridFooter{", (0, _global_styling.logicalCSS)('border-top', border), " ", (0, _global_styling.logicalCSS)('margin-top', "-".concat(euiTheme.border.width.thin)), ";}.euiDataGridHeader{", (0, _global_styling.logicalCSS)('border-top', border), ";};label:horizontal;"),
      all: /*#__PURE__*/(0, _react.css)("label:borders;.euiDataGridRowCell{&:not(.euiDataGridFooterCell){", (0, _global_styling.logicalCSS)('border-bottom', border), " ", (0, _global_styling.logicalCSS)('border-right', // Visually lighten vertical borders
      "".concat(euiTheme.border.width.thin, " solid ").concat(borderColors.vertical)), ";}&--firstColumn{", (0, _global_styling.logicalCSS)('border-left', border), ";}&--lastColumn{", (0, _global_styling.logicalCSS)('border-right-color', euiTheme.components.dataGridBorderColor), ";}}.euiDataGridFooterCell,.euiDataGridHeaderCell{", (0, _global_styling.logicalCSS)('border-right', border), " &:first-of-type{", (0, _global_styling.logicalCSS)('border-left', border), ";}}.euiDataGridFooter{", (0, _global_styling.logicalCSS)('border-bottom', border), ";}&:not(.euiDataGrid--footerOverline) .euiDataGridFooter{", (0, _global_styling.logicalCSS)('border-top', border), " ", (0, _global_styling.logicalCSS)('margin-top', "-".concat(euiTheme.border.width.thin)), ";}&:not(.euiDataGrid--headerUnderline) .euiDataGridHeader{", (0, _global_styling.logicalCSS)('border-bottom', border), ";}&:is(.euiDataGrid--noControls) .euiDataGridHeader{", (0, _global_styling.logicalCSS)('border-top', border), ";}.euiDataGrid__controls{border:", border, ";background-color:", euiTheme.colors.body, ";};label:all;")
    },
    // Sits below the controls above it and pagination below it
    euiDataGrid__content: /*#__PURE__*/(0, _react.css)("z-index:1;position:relative;flex-grow:1;", (0, _global_styling.logicalSizeCSS)('100%'), " ", (0, _global_styling.logicalCSS)('max-width', '100%'), " overflow:hidden;font-feature-settings:'tnum' 1;;label:euiDataGrid__content;"),
    // Wrapper around EuiDataGrid
    euiDataGrid__focusWrap: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('height', '100%'), ";;label:euiDataGrid__focusWrap;")
  };
};