"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.LandingLinksIcons = exports.LandingLinkIcon = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _beta_badge = require("./beta_badge");
var _landing_links = require("./landing_links");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/packages/navigation/src/landing_links/landing_links_icons.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const useLinkIconStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return {
    title: (0, _react2.css)`
      min-height: ${euiTheme.size.l};
      margin-top: ${euiTheme.size.m};
      margin-bottom: ${euiTheme.size.xs};
    `,
    description: (0, _react2.css)`
      max-width: 22em;
    `
  };
};
const LandingLinkIcon = exports.LandingLinkIcon = /*#__PURE__*/_react.default.memo(function LandingLinkIcon({
  item,
  urlState,
  onLinkClick,
  children
}) {
  const styles = useLinkIconStyles();
  const {
    title,
    description,
    landingIcon,
    isBeta,
    betaOptions
  } = item;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "flexStart",
    gutterSize: "none",
    responsive: false,
    "data-test-subj": "LandingItem",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    "aria-hidden": "true",
    size: "xl",
    type: landingIcon !== null && landingIcon !== void 0 ? landingIcon : '',
    role: "presentation",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    css: styles.title,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_landing_links.LandingLink, {
    item: item,
    urlState: urlState,
    onLinkClick: onLinkClick,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 17
    }
  }, title)), isBeta && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_beta_badge.BetaBadge, {
    text: betaOptions === null || betaOptions === void 0 ? void 0 : betaOptions.text,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 19
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: styles.description,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 11
    }
  }, description)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 9
    }
  }, children));
});
const linkIconContainerStyles = (0, _react2.css)`
  min-width: 22em;
`;
const LandingLinksIcons = ({
  items,
  urlState,
  onLinkClick
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xl",
    wrap: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 5
    }
  }, items.map(item => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: item.id,
    grow: false,
    css: linkIconContainerStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(LandingLinkIcon, {
    item: item,
    urlState: urlState,
    onLinkClick: onLinkClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 11
    }
  }))));
};

// eslint-disable-next-line import/no-default-export
exports.LandingLinksIcons = LandingLinksIcons;
var _default = exports.default = LandingLinksIcons;