"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createNavigationTree = void 0;
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _links = require("@kbn/security-solution-navigation/links");
var _navigation_tree = require("@kbn/security-solution-navigation/navigation_tree");
var _translations = require("./translations");
var _v2_footer_items = require("./v2_footer_items");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createNavigationTree = services => ({
  body: [{
    type: 'navGroup',
    id: 'security_solution_nav',
    title: _translations.SOLUTION_NAME,
    icon: 'logoSecurity',
    breadcrumbStatus: 'hidden',
    defaultIsCollapsed: false,
    isCollapsible: false,
    children: [{
      link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.landing),
      title: _translations.SOLUTION_NAME,
      icon: 'logoSecurity',
      renderAs: 'home',
      sideNavVersion: 'v2'
    }, {
      link: 'discover',
      iconV2: 'discoverApp',
      sideNavVersion: 'v1'
    }, _navigation_tree.defaultNavigationTree.dashboards({
      sideNavVersion: 'v1'
    }), {
      breadcrumbStatus: 'hidden',
      children: [_navigation_tree.defaultNavigationTree.rules({
        sideNavVersion: 'v1'
      }), services.featureFlags.getBooleanValue(_securitySolutionNavigation.ATTACKS_ALERTS_ALIGNMENT_ENABLED, false) ? _navigation_tree.defaultNavigationTree.alertDetections({
        sideNavVersion: 'v1'
      }) : {
        id: _securitySolutionNavigation.SecurityPageName.alerts,
        link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.alerts),
        sideNavVersion: 'v1'
      }, {
        link: 'workflows',
        withBadge: true,
        badgeTypeV2: 'techPreview',
        badgeOptions: {
          icon: 'beaker',
          tooltip: _links.i18nStrings.workflows.badgeTooltip
        },
        sideNavVersion: 'v1'
      }, {
        id: _securitySolutionNavigation.SecurityPageName.attackDiscovery,
        link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.attackDiscovery),
        sideNavVersion: 'v1'
      }, {
        id: _securitySolutionNavigation.SecurityPageName.cloudSecurityPostureFindings,
        link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.cloudSecurityPostureFindings),
        sideNavVersion: 'v1'
      }, _navigation_tree.defaultNavigationTree.cases({
        sideNavVersion: 'v1'
      })]
    }, {
      breadcrumbStatus: 'hidden',
      children: [_navigation_tree.defaultNavigationTree.entityAnalytics({
        sideNavVersion: 'v1'
      }), _navigation_tree.defaultNavigationTree.explore({
        sideNavVersion: 'v1'
      }), _navigation_tree.defaultNavigationTree.investigations({
        sideNavVersion: 'v1'
      }), {
        id: _securitySolutionNavigation.SecurityPageName.threatIntelligence,
        link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.threatIntelligence),
        sideNavVersion: 'v1'
      }]
    }, {
      breadcrumbStatus: 'hidden',
      children: [{
        id: _securitySolutionNavigation.SecurityPageName.assetInventory,
        link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.assetInventory),
        sideNavVersion: 'v1'
      }, {
        id: _securitySolutionNavigation.SecurityPageName.siemReadiness,
        link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.siemReadiness),
        sideNavVersion: 'v1'
      }, _navigation_tree.defaultNavigationTree.assets(services, {
        sideNavVersion: 'v1'
      })]
    }, _navigation_tree.defaultNavigationTree.ml({
      sideNavVersion: 'v1'
    }),
    // version 2 sidenav
    ..._navigation_tree.defaultNavigationTree.v2(services)]
  }],
  footer: [{
    id: 'security_solution_nav_footer',
    type: 'navGroup',
    children: [{
      id: _securitySolutionNavigation.SecurityPageName.landing,
      link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.landing),
      sideNavVersion: 'v1',
      icon: 'launch'
    },
    // version 2 sidenav launchpad
    {
      id: 'launchpad',
      title: _links.i18nStrings.launchPad.title,
      renderAs: 'panelOpener',
      sideNavVersion: 'v2',
      iconV2: 'launch',
      children: [{
        children: [{
          id: 'launchpad_get_started',
          link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.landing),
          sideNavVersion: 'v2'
        }, {
          link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.siemReadiness),
          sideNavVersion: 'v2'
        }, {
          // value report
          link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.aiValue),
          sideNavVersion: 'v2'
        }]
      }, {
        title: _links.i18nStrings.launchPad.migrations.title,
        children: [{
          id: _securitySolutionNavigation.SecurityPageName.siemMigrationsRules,
          link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.siemMigrationsRules),
          sideNavVersion: 'v2'
        }, {
          id: _securitySolutionNavigation.SecurityPageName.siemMigrationsDashboards,
          link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.siemMigrationsDashboards),
          sideNavVersion: 'v2'
        }]
      }]
    }, {
      link: 'dev_tools',
      title: _links.i18nStrings.devTools,
      icon: 'editorCodeBlock'
    },
    // version 2 sidenav footer items
    ..._v2_footer_items.v2FooterItems, {
      title: _links.i18nStrings.management.title,
      icon: 'gear',
      breadcrumbStatus: 'hidden',
      renderAs: 'accordion',
      spaceBefore: null,
      sideNavVersion: 'v1',
      children: [{
        id: 'stack_management',
        title: _links.i18nStrings.stackManagement.title,
        renderAs: 'panelOpener',
        spaceBefore: null,
        children: [{
          title: _links.i18nStrings.stackManagement.ingest.title,
          children: [{
            link: 'management:ingest_pipelines'
          }, {
            link: 'management:pipelines'
          }]
        }, {
          title: _links.i18nStrings.stackManagement.data.title,
          children: [{
            link: 'management:index_management'
          }, {
            link: 'management:index_lifecycle_management'
          }, {
            link: 'management:snapshot_restore'
          }, {
            link: 'management:rollup_jobs'
          }, {
            link: 'management:transform'
          }, {
            link: 'management:cross_cluster_replication'
          }, {
            link: 'management:remote_clusters'
          }, {
            link: 'management:migrate_data'
          }, {
            link: 'management:content_connectors'
          }]
        }, {
          title: _links.i18nStrings.stackManagement.alertsAndInsights.title,
          children: [{
            link: 'management:triggersActions'
          }, {
            link: 'management:cases'
          }, {
            link: 'management:triggersActionsConnectors'
          }, {
            link: 'management:reporting'
          }, {
            link: 'management:jobsListLink'
          }, {
            link: 'management:watcher'
          }, {
            link: 'management:maintenanceWindows'
          }, {
            id: _securitySolutionNavigation.SecurityPageName.entityAnalyticsManagement,
            link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.entityAnalyticsManagement)
          }, {
            id: _securitySolutionNavigation.SecurityPageName.entityAnalyticsEntityStoreManagement,
            link: (0, _links.securityLink)(_securitySolutionNavigation.SecurityPageName.entityAnalyticsEntityStoreManagement)
          }]
        }, {
          title: _links.i18nStrings.ml.title,
          children: [{
            link: 'management:overview'
          }, {
            link: 'management:anomaly_detection'
          }, {
            link: 'management:analytics'
          }, {
            link: 'management:trained_models'
          }, {
            link: 'management:supplied_configurations'
          }]
        }, {
          title: _links.i18nStrings.stackManagement.security.title,
          children: [{
            link: 'management:users'
          }, {
            link: 'management:roles'
          }, {
            link: 'management:api_keys'
          }, {
            link: 'management:role_mappings'
          }]
        }, {
          title: _links.i18nStrings.stackManagement.kibana.title,
          children: [{
            link: 'management:dataViews'
          }, {
            link: 'management:filesManagement'
          }, {
            link: 'management:objects'
          }, {
            link: 'management:tags'
          }, {
            link: 'management:search_sessions'
          }, {
            link: 'management:spaces'
          }, {
            link: 'maps'
          }, {
            link: 'visualize'
          }, {
            link: 'graph'
          }, {
            link: 'canvas'
          }, {
            link: 'management:settings'
          }]
        }, {
          title: 'AI',
          children: [{
            link: 'management:genAiSettings'
          }, {
            link: 'management:aiAssistantManagementSelection'
          }]
        }, {
          title: _links.i18nStrings.stackManagement.stack.title,
          children: [{
            link: 'management:license_management'
          }, {
            link: 'management:upgrade_assistant'
          }]
        }]
      }, {
        link: 'monitoring',
        sideNavVersion: 'v1'
      }, {
        link: 'integrations',
        sideNavVersion: 'v1'
      }]
    }]
  }]
});
exports.createNavigationTree = createNavigationTree;