"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateApiKeyForm = void 0;
var _eui = require("@elastic/eui");
var _reactHookForm = _interopRequireWildcard(require("react-hook-form"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _use_create_api_key_query = require("../../hooks/use_create_api_key_query");
var _use_kibana = require("../../hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_playground/public/components/view_code/create_api_key_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var ApiKeyFormFields = /*#__PURE__*/function (ApiKeyFormFields) {
  ApiKeyFormFields["Name"] = "name";
  ApiKeyFormFields["ExpireInDays"] = "expiresInDays";
  return ApiKeyFormFields;
}(ApiKeyFormFields || {});
const CreateApiKeyForm = () => {
  const {
    http
  } = (0, _use_kibana.useKibana)().services;
  const managementApiKeysLinks = http.basePath.prepend('/app/management/security/api_keys');
  const {
    control,
    getValues,
    reset,
    formState: {
      isDirty,
      isValid
    },
    handleSubmit
  } = (0, _reactHookForm.useForm)();
  const {
    action,
    isLoading,
    isSuccess,
    isError
  } = (0, _use_create_api_key_query.useCreateApiKeyQuery)();
  const onSubmit = async data => {
    await action(data);
    reset(getValues());
  };
  return /*#__PURE__*/_reactHookForm.default.createElement(_eui.EuiForm, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 5
    }
  }, /*#__PURE__*/_reactHookForm.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.searchPlayground.viewCode.apiForm.name.label', {
      defaultMessage: 'Name'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 7
    }
  }, /*#__PURE__*/_reactHookForm.default.createElement(_reactHookForm.Controller, {
    name: ApiKeyFormFields.Name,
    control: control,
    defaultValue: "",
    rules: {
      required: true
    },
    render: ({
      field
    }) => /*#__PURE__*/_reactHookForm.default.createElement(_eui.EuiFieldText, {
      fullWidth: true,
      placeholder: _i18n.i18n.translate('xpack.searchPlayground.viewCode.apiForm.name.placeholder', {
        defaultMessage: 'Enter a name for your API key'
      }),
      value: field.value,
      onChange: field.onChange,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 13
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 9
    }
  })), /*#__PURE__*/_reactHookForm.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: "Lifetime",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 7
    }
  }, /*#__PURE__*/_reactHookForm.default.createElement(_reactHookForm.Controller, {
    name: ApiKeyFormFields.ExpireInDays,
    control: control,
    rules: {
      min: 0,
      required: true
    },
    render: ({
      field
    }) => /*#__PURE__*/_reactHookForm.default.createElement(_eui.EuiFieldText, {
      fullWidth: true,
      append: /*#__PURE__*/_reactHookForm.default.createElement(_eui.EuiText, {
        size: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 88,
          columnNumber: 17
        }
      }, /*#__PURE__*/_reactHookForm.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 89,
          columnNumber: 19
        }
      }, /*#__PURE__*/_reactHookForm.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.searchPlayground.viewCode.apiForm.expire.days",
        defaultMessage: "Days",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 90,
          columnNumber: 21
        }
      }))),
      type: "number",
      placeholder: _i18n.i18n.translate('xpack.searchPlayground.viewCode.apiForm.expire.placeholder', {
        defaultMessage: 'Set expiry in days'
      }),
      value: field.value || '',
      onChange: field.onChange,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 13
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 9
    }
  })), /*#__PURE__*/_reactHookForm.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 7
    }
  }, /*#__PURE__*/_reactHookForm.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 9
    }
  }, isSuccess && !isDirty ? /*#__PURE__*/_reactHookForm.default.createElement(_eui.EuiButton, {
    color: "success",
    iconType: "check",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 13
    }
  }, /*#__PURE__*/_reactHookForm.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.viewCode.apiForm.createdButton",
    defaultMessage: "Created",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 15
    }
  })) : /*#__PURE__*/_reactHookForm.default.createElement(_eui.EuiButton, {
    isDisabled: !isValid || isLoading,
    isLoading: isLoading,
    onClick: handleSubmit(onSubmit),
    color: isError ? 'danger' : 'primary',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 13
    }
  }, /*#__PURE__*/_reactHookForm.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.viewCode.apiForm.createButton",
    defaultMessage: "Create API key",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 15
    }
  })), /*#__PURE__*/_reactHookForm.default.createElement(_eui.EuiButtonEmpty, {
    iconSide: "left",
    iconType: "popout",
    href: managementApiKeysLinks,
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 11
    }
  }, /*#__PURE__*/_reactHookForm.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.viewCode.apiForm.viewKeysButton",
    defaultMessage: "View all API keys",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 13
    }
  })))));
};
exports.CreateApiKeyForm = CreateApiKeyForm;