"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SaveNewPlaygroundButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _use_kibana = require("../hooks/use_kibana");
var _unsaved_form_provider = require("../providers/unsaved_form_provider");
var _types = require("../types");
var _saved_playgrounds = require("../utils/saved_playgrounds");
var _save_playground_modal = require("./saved_playground/save_playground_modal");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_playground/public/components/save_new_playground_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SaveNewPlaygroundButton = ({
  disabled,
  storage = localStorage
}) => {
  const [showSavePlaygroundModal, setShowSavePlaygroundModal] = (0, _react.useState)(false);
  const {
    history
  } = (0, _use_kibana.useKibana)().services;
  const {
    formState: {
      errors: formErrors
    }
  } = (0, _reactHookForm.useFormContext)();
  const hasErrors = (0, _saved_playgrounds.hasSavedPlaygroundFormErrors)(formErrors);
  const onSave = (0, _react.useCallback)(e => {
    e.preventDefault();
    setShowSavePlaygroundModal(true);
  }, []);
  const onNavigateToNewPlayground = (0, _react.useCallback)(id => {
    setShowSavePlaygroundModal(false);
    const path = `/p/${id}/${_types.PlaygroundPageMode.Chat}`;
    storage.removeItem(_unsaved_form_provider.LOCAL_STORAGE_KEY);
    history.push(path);
  }, [history, storage]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "playground-save-button",
    size: "s",
    iconType: "save",
    fill: true,
    isDisabled: hasErrors || disabled,
    onClick: onSave,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.header.saveButton.text",
    defaultMessage: "Save",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 9
    }
  })), showSavePlaygroundModal && /*#__PURE__*/_react.default.createElement(_save_playground_modal.SavePlaygroundModal, {
    onNavigateToNewPlayground: onNavigateToNewPlayground,
    onClose: () => setShowSavePlaygroundModal(false),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 9
    }
  }));
};
exports.SaveNewPlaygroundButton = SaveNewPlaygroundButton;