"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CitationsTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _use_usage_tracker = require("../../hooks/use_usage_tracker");
var _constants = require("../../analytics/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_playground/public/components/message_list/citations_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CitationsTable = ({
  citations
}) => {
  const usageTracker = (0, _use_usage_tracker.useUsageTracker)();
  const [itemIdToExpandedRowMap, setItemIdToExpandedRowMap] = (0, _react.useState)({});

  // Add an ID to each citation to use for expanding the row
  const citationsWithId = citations.map(citation => ({
    ...citation,
    id: citation.metadata._id
  }));
  const toggleDetails = citation => {
    const itemIdToExpandedRowMapValues = {
      ...itemIdToExpandedRowMap
    };
    if (itemIdToExpandedRowMapValues[citation.metadata._id]) {
      delete itemIdToExpandedRowMapValues[citation.metadata._id];
      usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.click(_constants.AnalyticsEvents.citationDetailsCollapsed);
    } else {
      itemIdToExpandedRowMapValues[citation.metadata._id] = /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 38,
          columnNumber: 9
        }
      }, citation.content);
      usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.click(_constants.AnalyticsEvents.citationDetailsExpanded);
    }
    setItemIdToExpandedRowMap(itemIdToExpandedRowMapValues);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    columns: [{
      field: 'metadata._id',
      name: _i18n.i18n.translate('xpack.searchPlayground.chat.message.assistant.citations.idField', {
        defaultMessage: 'ID'
      }),
      truncateText: true
    }, {
      truncateText: false,
      align: 'right',
      isExpander: true,
      render: citation => {
        const itemIdToExpandedRowMapValues = {
          ...itemIdToExpandedRowMap
        };
        return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
          iconSide: "right",
          size: "s",
          "data-test-subj": `expandButton-${citation.metadata._id}`,
          onClick: () => toggleDetails(citation),
          iconType: itemIdToExpandedRowMapValues[citation.metadata._id] ? 'arrowDown' : 'arrowRight',
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 64,
            columnNumber: 15
          }
        }, _i18n.i18n.translate('xpack.searchPlayground.chat.message.assistant.citations.snippet', {
          defaultMessage: 'Snippet'
        }));
      }
    }],
    items: citationsWithId,
    itemId: "id",
    itemIdToExpandedRowMap: itemIdToExpandedRowMap,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 5
    }
  });
};
exports.CitationsTable = CitationsTable;