"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getErrorCode = getErrorCode;
exports.getErrorMessage = getErrorMessage;
exports.isKibanaServerError = isKibanaServerError;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getErrorMessage(error, defaultMessage) {
  if (typeof error === 'string') {
    return error;
  }
  if (isKibanaServerError(error)) {
    return error.body.message;
  }
  if (typeof error === 'object' && error.name) {
    return error.name;
  }
  return defaultMessage !== null && defaultMessage !== void 0 ? defaultMessage : '';
}
function getErrorCode(error) {
  if (isKibanaServerError(error)) {
    return error.body.statusCode;
  }
  return undefined;
}
function isKibanaServerError(input) {
  if (typeof input === 'object' && input.body && typeof input.body.message === 'string') {
    return true;
  }
  return false;
}