"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateIndex = void 0;
var _react = _interopRequireWildcard(require("react"));
var _constants = require("../../analytics/constants");
var _use_user_permissions = require("../../hooks/api/use_user_permissions");
var _use_kibana = require("../../hooks/use_kibana");
var _use_usage_tracker = require("../../hooks/use_usage_tracker");
var _indices = require("../../utils/indices");
var _language = require("../../utils/language");
var _create_index_panel = require("../shared/create_index_panel/create_index_panel");
var _create_index_code_view = require("./create_index_code_view");
var _create_index_ui_view = require("./create_index_ui_view");
var _use_workflow = require("../shared/hooks/use_workflow");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_indices/public/components/create_index/create_index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function initCreateIndexState() {
  const defaultIndexName = (0, _indices.generateRandomIndexName)();
  return {
    indexName: defaultIndexName,
    defaultIndexName,
    codingLanguage: (0, _language.getDefaultCodingLanguage)()
  };
}
var CreateIndexViewMode = /*#__PURE__*/function (CreateIndexViewMode) {
  CreateIndexViewMode["UI"] = "ui";
  CreateIndexViewMode["Code"] = "code";
  return CreateIndexViewMode;
}(CreateIndexViewMode || {});
const CreateIndex = ({
  indicesData
}) => {
  const {
    application
  } = (0, _use_kibana.useKibana)().services;
  const [formState, setFormState] = (0, _react.useState)(initCreateIndexState);
  const {
    data: userPrivileges
  } = (0, _use_user_permissions.useUserPrivilegesQuery)(formState.defaultIndexName);
  const [createIndexView, setCreateIndexView] = (0, _react.useState)((userPrivileges === null || userPrivileges === void 0 ? void 0 : userPrivileges.privileges.canManageIndex) === false ? CreateIndexViewMode.Code : CreateIndexViewMode.UI);
  const {
    workflow,
    setSelectedWorkflowId,
    createIndexExamples: selectedCodeExamples
  } = (0, _use_workflow.useWorkflow)();
  const usageTracker = (0, _use_usage_tracker.useUsageTracker)();
  const onChangeView = (0, _react.useCallback)(id => {
    switch (id) {
      case CreateIndexViewMode.UI:
        usageTracker.click(_constants.AnalyticsEvents.createIndexShowUIClick);
        setCreateIndexView(CreateIndexViewMode.UI);
        return;
      case CreateIndexViewMode.Code:
        usageTracker.click(_constants.AnalyticsEvents.createIndexShowCodeClick);
        setCreateIndexView(CreateIndexViewMode.Code);
        return;
    }
  }, [usageTracker]);
  const onChangeCodingLanguage = (0, _react.useCallback)(language => {
    setFormState({
      ...formState,
      codingLanguage: language
    });
    usageTracker.count([_constants.AnalyticsEvents.createIndexLanguageSelect, `${_constants.AnalyticsEvents.createIndexLanguageSelect}_${language}`]);
  }, [usageTracker, formState, setFormState]);
  const onClose = (0, _react.useCallback)(() => {
    application.navigateToApp('elasticsearchIndexManagement');
  }, [application]);
  return /*#__PURE__*/_react.default.createElement(_create_index_panel.CreateIndexPanel, {
    createIndexView: createIndexView,
    onChangeView: onChangeView,
    onClose: onClose,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 5
    }
  }, createIndexView === CreateIndexViewMode.UI && /*#__PURE__*/_react.default.createElement(_create_index_ui_view.CreateIndexUIView, {
    formState: formState,
    setFormState: setFormState,
    userPrivileges: userPrivileges,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 9
    }
  }), createIndexView === CreateIndexViewMode.Code && /*#__PURE__*/_react.default.createElement(_create_index_code_view.CreateIndexCodeView, {
    indicesData: indicesData,
    selectedLanguage: formState.codingLanguage,
    indexName: formState.indexName,
    changeCodingLanguage: onChangeCodingLanguage,
    changeWorkflowId: workflowId => {
      setSelectedWorkflowId(workflowId);
      usageTracker.click([_constants.AnalyticsEvents.createIndexWorkflowSelect, `${_constants.AnalyticsEvents.createIndexWorkflowSelect}_${workflowId}`]);
    },
    selectedWorkflow: workflow,
    selectedCodeExamples: selectedCodeExamples,
    canCreateApiKey: userPrivileges === null || userPrivileges === void 0 ? void 0 : userPrivileges.privileges.canCreateApiKeys,
    analyticsEvents: {
      runInConsole: _constants.AnalyticsEvents.createIndexRunInConsole,
      installCommands: _constants.AnalyticsEvents.createIndexCodeCopyInstall,
      createIndex: _constants.AnalyticsEvents.createIndexCodeCopy
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 9
    }
  }));
};
exports.CreateIndex = CreateIndex;