"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateRollupCron = validateRollupCron;
var _react = _interopRequireDefault(require("react"));
var _cronstrue = _interopRequireDefault(require("cronstrue"));
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/rollup/public/crud_app/sections/job_create/steps_config/validate_rollup_cron.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function validateRollupCron(rollupCron) {
  if (!rollupCron || !rollupCron.trim()) {
    return [/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.create.errors.rollupCronMissing",
      defaultMessage: "Cron pattern or basic interval is required.",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 15,
        columnNumber: 7
      }
    })];
  }
  try {
    _cronstrue.default.toString(rollupCron);
  } catch (error) {
    const prefix = 'Error: ';
    const prefixIndex = error.indexOf(prefix);

    // Note: cronstrue ships with a localizable version. Refer to the docs for more
    // info on how we can display a localized error value.
    return error.substring(prefixIndex + prefix.length);
  }
  return undefined;
}